/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixPackedCell;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixPackedCell;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CollectMultipleConvertedOutputs;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.MapperBase;
import org.apache.sysml.runtime.util.MapReduceTool;

public class GMRMapper
extends MapperBase
implements Mapper<Writable, Writable, Writable, Writable> {
    private boolean mapOnlyJob = false;
    protected byte[] resultIndexes = null;
    protected byte[] resultDimsUnknown = null;
    protected CollectMultipleConvertedOutputs collectFinalMultipleOutputs;
    protected long[] resultsNonZeros = null;
    protected long[] resultsMaxRowDims = null;
    protected long[] resultsMaxColDims = null;
    protected String dimsUnknownFilePrefix;
    protected Reporter cachedReporter = null;
    protected String mapperID;
    private TaggedMatrixValue taggedValueBuffer = null;
    private HashMap<Byte, ArrayList<Integer>> tagMapping;
    private boolean _filterEmptyInputBlocks = false;

    public void map(Writable rawKey, Writable rawValue, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.cachedReporter = reporter;
        if (this._filterEmptyInputBlocks && ((MatrixValue)rawValue).isEmpty()) {
            return;
        }
        this.commonMap(rawKey, rawValue, out, reporter);
    }

    @Override
    protected void specialOperationsForActualMap(int index, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this.processMapperInstructionsForMatrix(index);
        if (this.mapOnlyJob) {
            this.processMapFinalOutput(index, this.taggedValueBuffer, this.collectFinalMultipleOutputs, reporter, this.tagMapping);
        } else {
            this.processMapOutputToReducerForGMR(index, this.taggedValueBuffer, out);
        }
    }

    protected void processMapOutputToReducerForGMR(int index, TaggedMatrixValue taggedValueBuffer, OutputCollector<Writable, Writable> out) throws IOException {
        Iterator iterator = ((ArrayList)this.outputIndexes.get(index)).iterator();
        while (iterator.hasNext()) {
            byte output = (Byte)iterator.next();
            ArrayList<IndexedMatrixValue> results = this.cachedValues.get(output);
            if (results == null) continue;
            for (IndexedMatrixValue result : results) {
                if (result == null) continue;
                if (this.valueClass.equals(MatrixCell.class)) {
                    ((MatrixValue)taggedValueBuffer.getBaseObject()).copy(result.getValue());
                } else {
                    taggedValueBuffer.setBaseObject(result.getValue());
                }
                taggedValueBuffer.setTag(output);
                out.collect((Object)result.getIndexes(), (Object)taggedValueBuffer);
            }
        }
    }

    protected void processMapFinalOutput(int index, TaggedMatrixValue taggedValueBuffer, CollectMultipleConvertedOutputs collectFinalMultipleOutputs, Reporter reporter, HashMap<Byte, ArrayList<Integer>> tagMapping) throws IOException {
        Iterator iterator = ((ArrayList)this.outputIndexes.get(index)).iterator();
        while (iterator.hasNext()) {
            byte output = (Byte)iterator.next();
            ArrayList<IndexedMatrixValue> results = this.cachedValues.get(output);
            if (results == null) continue;
            for (IndexedMatrixValue result : results) {
                if (result == null) continue;
                taggedValueBuffer.setBaseObject(result.getValue());
                taggedValueBuffer.setTag(output);
                for (int outputIndex : tagMapping.get(output)) {
                    this.collectOutput_N_Increase_Counter(result.getIndexes(), (MatrixValue)taggedValueBuffer.getBaseObject(), outputIndex, reporter, collectFinalMultipleOutputs, this.resultDimsUnknown, this.resultsNonZeros, this.resultsMaxRowDims, this.resultsMaxColDims);
                }
            }
        }
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        this.mapperID = job.get(MRConfigurationNames.MR_TASK_ATTEMPT_ID);
        this.dimsUnknownFilePrefix = job.get("dims.unknown.file.prefix");
        this._filterEmptyInputBlocks = this.allowsFilterEmptyInputBlocks();
        try {
            this.taggedValueBuffer = job.getMapOutputValueClass().equals(TaggedMatrixPackedCell.class) ? TaggedMatrixValue.createObject(MatrixPackedCell.class) : TaggedMatrixValue.createObject(this.valueClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean bl = this.mapOnlyJob = job.getNumReduceTasks() <= 0;
        if (!this.mapOnlyJob) {
            return;
        }
        this.resultIndexes = MRJobConfiguration.getResultIndexes(job);
        this.resultDimsUnknown = MRJobConfiguration.getResultDimsUnknown(job);
        this.resultsNonZeros = new long[this.resultIndexes.length];
        this.resultsMaxRowDims = new long[this.resultIndexes.length];
        this.resultsMaxColDims = new long[this.resultIndexes.length];
        this.tagMapping = new HashMap();
        for (int i = 0; i < this.resultIndexes.length; ++i) {
            byte output = this.resultIndexes[i];
            ArrayList<Integer> vec = this.tagMapping.get(output);
            if (vec == null) {
                vec = new ArrayList();
                this.tagMapping.put(output, vec);
            }
            vec.add(i);
        }
        this.collectFinalMultipleOutputs = MRJobConfiguration.getMultipleConvertedOutputs(job);
    }

    public void close() throws IOException {
        if (this.cachedReporter != null && this.mapOnlyJob) {
            int taskid;
            String[] parts = this.mapperID.split("_");
            String jobID = "job_" + parts[1] + "_" + parts[2];
            if (parts[0].equalsIgnoreCase("task")) {
                taskid = Integer.parseInt(parts[parts.length - 1]);
            } else if (parts[0].equalsIgnoreCase("attempt")) {
                taskid = Integer.parseInt(parts[parts.length - 2]);
            } else {
                throw new RuntimeException("Unrecognized format for reducerID: " + this.mapperID);
            }
            boolean dimsUnknown = false;
            for (int i = 0; i < this.resultIndexes.length; ++i) {
                this.cachedReporter.incrCounter("nonzeros", Integer.toString(i), this.resultsNonZeros[i]);
                if (this.resultDimsUnknown == null || this.resultDimsUnknown[i] == 0) continue;
                dimsUnknown = true;
            }
            if (dimsUnknown) {
                MapReduceTool.writeDimsFile(this.dimsUnknownFilePrefix + "/" + jobID + "_dimsFile/m_" + taskid, this.resultDimsUnknown, this.resultsMaxRowDims, this.resultsMaxColDims);
            }
        }
        if (this.collectFinalMultipleOutputs != null) {
            this.collectFinalMultipleOutputs.close();
        }
    }
}

