/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.HashMap;
import org.apache.sysds.runtime.compress.BitmapEncoder;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.sample.HassAndStokes;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CompressedSizeEstimatorSample
extends CompressedSizeEstimator {
    private int[] _sampleRows = null;
    private HashMap<Integer, Double> _solveCache = null;

    public CompressedSizeEstimatorSample(MatrixBlock data, CompressionSettings compSettings, int sampleSize) {
        super(data, compSettings);
        this._sampleRows = CompressedSizeEstimatorSample.getSortedUniformSample(this._numRows, sampleSize, this._compSettings.seed);
        MatrixBlock select = new MatrixBlock(this._numRows, 1, false);
        for (int i = 0; i < sampleSize; ++i) {
            select.quickSetValue(this._sampleRows[i], 0, 1.0);
        }
        this._data = this._data.removeEmptyOperations(new MatrixBlock(), !this._compSettings.transposeInput, true, select);
        this._solveCache = new HashMap();
    }

    @Override
    public CompressedSizeInfoColGroup estimateCompressedColGroupSize(int[] colIndexes) {
        int sampleSize = this._sampleRows.length;
        int numCols = colIndexes.length;
        int[] sampleRows = this._sampleRows;
        ABitmap ubm = BitmapEncoder.extractBitmap(colIndexes, this._data, this._compSettings);
        EstimationFactors fact = EstimationFactors.computeSizeEstimationFactors(ubm, false, this._numRows, numCols);
        int totalCardinality = CompressedSizeEstimatorSample.getNumDistinctValues(ubm, this._numRows, sampleRows, this._solveCache);
        totalCardinality = Math.max(totalCardinality, fact.numVals);
        totalCardinality = this._compSettings.lossy ? Math.min(totalCardinality, numCols * 127) : totalCardinality;
        totalCardinality = Math.min(totalCardinality, this._numRows);
        int numZeros = ubm.getZeroCounts();
        double C = Math.max(1.0 - (double)fact.numSingle / (double)sampleSize, (double)sampleSize / (double)this._numRows);
        int numNonZeros = (int)Math.ceil((double)this._numRows - (double)this._numRows / (double)sampleSize * C * (double)numZeros);
        numNonZeros = Math.max(numNonZeros, totalCardinality);
        int totalNumRuns = ubm.getNumValues() > 0 ? CompressedSizeEstimatorSample.getNumRuns(ubm, sampleSize, this._numRows, sampleRows) : 0;
        boolean containsZero = numZeros > 0;
        EstimationFactors totalFacts = new EstimationFactors(numCols, totalCardinality, numNonZeros, totalNumRuns, fact.numSingle, this._numRows, containsZero, ubm.getType() == ABitmap.BitmapType.Lossy);
        return new CompressedSizeInfoColGroup(totalFacts, this._compSettings.validCompressions);
    }

    private static int getNumDistinctValues(ABitmap ubm, int numRows, int[] sampleRows, HashMap<Integer, Double> solveCache) {
        return HassAndStokes.haasAndStokes(ubm, numRows, sampleRows.length, solveCache);
    }

    private static int getNumRuns(ABitmap ubm, int sampleSize, int totalNumRows, int[] sampleRows) {
        int numVals = ubm.getNumValues();
        double numRuns = 0.0;
        for (int vi = 0; vi < numVals; ++vi) {
            double nonOffsetProb;
            double additionalOffsets;
            int intervalSize;
            int intervalEnd;
            int[] offsets = ubm.getOffsetsList(vi).extractValues();
            int offsetsSize = ubm.getNumOffsets(vi);
            double offsetsRatio = (double)offsetsSize / (double)sampleSize;
            double avgAdditionalOffsets = offsetsRatio * (double)totalNumRows / (double)sampleSize;
            if (avgAdditionalOffsets < 1.0) {
                numRuns += (double)offsetsSize * (double)totalNumRows / (double)sampleSize;
                continue;
            }
            double prevNonOffsetProb = 1.0;
            boolean reachedSampleEnd = false;
            int intervalStart = -1;
            if (sampleRows[0] == 0) {
                intervalStart = 0;
            } else {
                intervalEnd = sampleRows[0];
                intervalSize = intervalEnd - intervalStart - 1;
                additionalOffsets = offsetsRatio * (double)intervalSize;
                numRuns += ((double)intervalSize - additionalOffsets) * additionalOffsets / (double)intervalSize;
                intervalStart = intervalEnd;
                prevNonOffsetProb = ((double)intervalSize - additionalOffsets) / (double)intervalSize;
            }
            boolean withinSepRun = false;
            boolean seenNonOffset = false;
            boolean startedWithOffset = false;
            boolean endedWithOffset = false;
            int offsetsPtrs = 0;
            for (int ix = 1; ix < sampleSize; ++ix) {
                if (offsetsPtrs < offsetsSize && offsets[offsetsPtrs] == intervalStart) {
                    startedWithOffset = true;
                    ++offsetsPtrs;
                    endedWithOffset = true;
                } else {
                    seenNonOffset = true;
                    endedWithOffset = false;
                }
                while (intervalStart + 1 == sampleRows[ix]) {
                    intervalStart = sampleRows[ix];
                    if (seenNonOffset) {
                        if (offsetsPtrs < offsetsSize && offsets[offsetsPtrs] == intervalStart) {
                            withinSepRun = true;
                            ++offsetsPtrs;
                            endedWithOffset = true;
                        } else {
                            numRuns += (double)withinSepRun;
                            withinSepRun = false;
                            endedWithOffset = false;
                        }
                    } else if (offsetsPtrs < offsetsSize && offsets[offsetsPtrs] == intervalStart) {
                        ++offsetsPtrs;
                        endedWithOffset = true;
                    } else {
                        seenNonOffset = true;
                        endedWithOffset = false;
                    }
                    if (++ix != sampleSize) continue;
                    reachedSampleEnd = true;
                    break;
                }
                if (reachedSampleEnd) break;
                intervalEnd = sampleRows[ix];
                intervalSize = intervalEnd - intervalStart - 1;
                additionalOffsets = offsetsRatio * (double)intervalSize;
                numRuns += ((double)intervalSize - additionalOffsets) * additionalOffsets / (double)intervalSize;
                nonOffsetProb = ((double)intervalSize - additionalOffsets) / (double)intervalSize;
                if (seenNonOffset) {
                    if (startedWithOffset) {
                        numRuns += prevNonOffsetProb;
                    }
                    if (endedWithOffset) {
                        numRuns += nonOffsetProb;
                    }
                } else {
                    numRuns += prevNonOffsetProb * nonOffsetProb;
                }
                prevNonOffsetProb = nonOffsetProb;
                intervalStart = intervalEnd;
                endedWithOffset = false;
                startedWithOffset = false;
                seenNonOffset = false;
                withinSepRun = false;
            }
            if (intervalStart != totalNumRows - 1) {
                intervalEnd = totalNumRows;
                intervalSize = intervalEnd - intervalStart - 1;
                additionalOffsets = offsetsRatio * (double)intervalSize;
                numRuns += ((double)intervalSize - additionalOffsets) * additionalOffsets / (double)intervalSize;
                nonOffsetProb = ((double)intervalSize - additionalOffsets) / (double)intervalSize;
            } else {
                nonOffsetProb = 1.0;
            }
            boolean bl = endedWithOffset = intervalStart == offsets[offsetsSize - 1];
            if (seenNonOffset) {
                if (startedWithOffset) {
                    numRuns += prevNonOffsetProb;
                }
                if (!endedWithOffset) continue;
                numRuns += nonOffsetProb;
                continue;
            }
            if (!endedWithOffset) continue;
            numRuns += prevNonOffsetProb * nonOffsetProb;
        }
        return (int)Math.min(Math.round(numRuns), Integer.MAX_VALUE);
    }

    private static int[] getSortedUniformSample(int range, int smplSize, long seed) {
        return UtilFunctions.getSortedSampleIndexes(range, smplSize, seed);
    }
}

