/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDense
extends ReaderColumnSelection {
    protected MatrixBlock _data;
    private DblArray reusableReturn;
    private double[] reusableArr;

    public ReaderColumnSelectionDense(MatrixBlock data, int[] colIndices, CompressionSettings compSettings) {
        super(colIndices, compSettings.transposeInput ? data.getNumColumns() : data.getNumRows(), compSettings);
        this._data = data;
        this.reusableArr = new double[colIndices.length];
        this.reusableReturn = new DblArray(this.reusableArr);
    }

    @Override
    protected DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this.reusableArr[i] = this._compSettings.transposeInput ? this._data.quickGetValue(this._colIndexes[i], this._lastRow) : this._data.quickGetValue(this._lastRow, this._colIndexes[i]);
        }
        return this.reusableReturn;
    }
}

