/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.data.SparseRowScalar;
import org.apache.sysds.runtime.data.SparseRowVector;

public class SparseBlockMCSR
extends SparseBlock {
    private static final long serialVersionUID = -4743624499258436199L;
    private SparseRow[] _rows = null;

    public SparseBlockMCSR(SparseBlock sblock) {
        if (sblock instanceof SparseBlockMCSR) {
            SparseRow[] orows = ((SparseBlockMCSR)sblock)._rows;
            this._rows = new SparseRow[orows.length];
            for (int i = 0; i < this._rows.length; ++i) {
                this._rows[i] = new SparseRowVector(orows[i]);
            }
        } else {
            this._rows = new SparseRow[sblock.numRows()];
            for (int i = 0; i < this._rows.length; ++i) {
                if (sblock.isEmpty(i)) continue;
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                this._rows[i] = new SparseRowVector(alen);
                ((SparseRowVector)this._rows[i]).setSize(alen);
                System.arraycopy(sblock.indexes(i), apos, this._rows[i].indexes(), 0, alen);
                System.arraycopy(sblock.values(i), apos, this._rows[i].values(), 0, alen);
            }
        }
    }

    public SparseBlockMCSR(SparseRow[] rows, boolean deep) {
        if (deep) {
            this._rows = new SparseRow[rows.length];
            for (int i = 0; i < this._rows.length; ++i) {
                this._rows[i] = rows[i].size() == 1 ? new SparseRowScalar(rows[i].indexes()[0], rows[i].values()[0]) : new SparseRowVector(rows[i]);
            }
        } else {
            this._rows = rows;
        }
    }

    public SparseBlockMCSR(int rlen, int clen) {
        this._rows = new SparseRow[rlen];
    }

    public static long estimateMemory(long nrows, long ncols, double sparsity) {
        double cnnz = Math.max(4.0, Math.ceil(sparsity * (double)ncols));
        double rlen = Math.min((double)nrows, Math.ceil(sparsity * (double)nrows * (double)ncols));
        double size = 16.0;
        size += 24.0 + (double)nrows * 8.0;
        return (long)Math.min(size += rlen * (76.0 + cnnz * 12.0), 9.223372036854776E18);
    }

    @Override
    public void allocate(int r) {
        if (!this.isAllocated(r)) {
            this._rows[r] = new SparseRowVector();
        }
    }

    @Override
    public void allocate(int r, int nnz) {
        if (!this.isAllocated(r)) {
            this._rows[r] = nnz == 1 ? new SparseRowScalar() : new SparseRowVector(nnz);
        }
    }

    @Override
    public void allocate(int r, int ennz, int maxnnz) {
        if (!this.isAllocated(r)) {
            this._rows[r] = ennz == 1 ? new SparseRowScalar() : new SparseRowVector(ennz, maxnnz);
        }
    }

    @Override
    public void compact(int r) {
        if (this.isAllocated(r) && this._rows[r] instanceof SparseRowVector && this._rows[r].size() > 4 && (double)this._rows[r].size() * 2.0 < (double)((SparseRowVector)this._rows[r]).capacity()) {
            ((SparseRowVector)this._rows[r]).compact();
        }
    }

    @Override
    public int numRows() {
        return this._rows.length;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public boolean isAllocated(int r) {
        return this._rows[r] != null;
    }

    @Override
    public boolean checkValidity(int rlen, int clen, long nnz, boolean strict) {
        int i;
        if (rlen < 0 || clen < 0) {
            throw new RuntimeException("Invalid block dimensions: (" + rlen + ", " + clen + ").");
        }
        if (this.size() < nnz) {
            throw new RuntimeException("Incorrect size: " + this.size() + " (expected: " + nnz + ").");
        }
        for (i = 0; i < rlen; ++i) {
            if (this.isEmpty(i)) continue;
            int apos = this.pos(i);
            int alen = this.size(i);
            int[] aix = this.indexes(i);
            double[] avals = this.values(i);
            for (int k = apos + 1; k < apos + alen; ++k) {
                if (aix[k - 1] >= aix[k]) {
                    throw new RuntimeException("Wrong sparse row ordering, at row=" + i + ", pos=" + k + " with column indexes " + aix[k - 1] + ">=" + aix[k]);
                }
                if (avals[k] != 0.0) continue;
                throw new RuntimeException("The values are expected to be non zeros but zero at row: " + i + ", col pos: " + k);
            }
        }
        for (i = 0; i < rlen; ++i) {
            if (this.isEmpty(i) || !((double)this.values(i).length > (double)nnz * 2.0)) continue;
            throw new RuntimeException("The capacity is larger than nnz times a resize factor(=2). Actual length = " + this.values(i).length + ", should not exceed " + (double)nnz * 2.0);
        }
        return true;
    }

    @Override
    public void reset() {
        for (SparseRow row : this._rows) {
            if (row == null) continue;
            row.reset(row.size(), Integer.MAX_VALUE);
        }
    }

    @Override
    public void reset(int ennz, int maxnnz) {
        for (SparseRow row : this._rows) {
            if (row == null) continue;
            row.reset(ennz, maxnnz);
        }
    }

    @Override
    public void reset(int r, int ennz, int maxnnz) {
        if (this.isAllocated(r)) {
            this._rows[r].reset(ennz, maxnnz);
        }
    }

    @Override
    public long size() {
        long nnz = 0L;
        for (SparseRow row : this._rows) {
            if (row == null) continue;
            nnz += (long)row.size();
        }
        return nnz;
    }

    @Override
    public int size(int r) {
        return this.isAllocated(r) ? this._rows[r].size() : 0;
    }

    @Override
    public long size(int rl, int ru) {
        int ret = 0;
        for (int i = rl; i < ru; ++i) {
            ret += this.isAllocated(i) ? this._rows[i].size() : 0;
        }
        return ret;
    }

    @Override
    public long size(int rl, int ru, int cl, int cu) {
        long nnz = 0L;
        for (int i = rl; i < ru; ++i) {
            if (this.isEmpty(i)) continue;
            int start = this.posFIndexGTE(i, cl);
            int end = this.posFIndexGTE(i, cu);
            nnz += start != -1 ? (long)(end - start) : 0L;
        }
        return nnz;
    }

    @Override
    public boolean isEmpty(int r) {
        return !this.isAllocated(r) || this._rows[r].isEmpty();
    }

    @Override
    public int[] indexes(int r) {
        return this._rows[r].indexes();
    }

    @Override
    public double[] values(int r) {
        return this._rows[r].values();
    }

    @Override
    public int pos(int r) {
        return 0;
    }

    @Override
    public boolean set(int r, int c, double v) {
        if (!this.isAllocated(r)) {
            this._rows[r] = new SparseRowScalar();
        } else if (this._rows[r] instanceof SparseRowScalar && !this._rows[r].isEmpty()) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        return this._rows[r].set(c, v);
    }

    @Override
    public void set(int r, SparseRow row, boolean deep) {
        if (this.isAllocated(r) && this._rows[r] instanceof SparseRowVector && ((SparseRowVector)this._rows[r]).capacity() >= row.size() && deep) {
            ((SparseRowVector)this._rows[r]).copy(row);
        } else {
            this._rows[r] = deep && row != null ? new SparseRowVector(row) : row;
        }
    }

    @Override
    public boolean add(int r, int c, double v) {
        if (!this.isAllocated(r)) {
            this._rows[r] = new SparseRowScalar();
        } else if (this._rows[r] instanceof SparseRowScalar && !this._rows[r].isEmpty()) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        return this._rows[r].add(c, v);
    }

    @Override
    public void append(int r, int c, double v) {
        if (!this.isAllocated(r)) {
            this._rows[r] = new SparseRowScalar();
        } else if (this._rows[r] instanceof SparseRowScalar && !this._rows[r].isEmpty()) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        this._rows[r].append(c, v);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int vix, int vlen) {
        if (!this.isAllocated(r)) {
            this._rows[r] = new SparseRowVector();
        } else if (this._rows[r] instanceof SparseRowScalar) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        ((SparseRowVector)this._rows[r]).setIndexRange(cl, cu - 1, v, vix, vlen);
    }

    @Override
    public void setIndexRange(int r, int cl, int cu, double[] v, int[] vix, int vpos, int vlen) {
        if (!this.isAllocated(r)) {
            this._rows[r] = new SparseRowVector();
        } else if (this._rows[r] instanceof SparseRowScalar) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        ((SparseRowVector)this._rows[r]).setIndexRange(cl, cu - 1, v, vix, vpos, vlen);
    }

    @Override
    public void deleteIndexRange(int r, int cl, int cu) {
        if (this._rows[r] instanceof SparseRowScalar) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        ((SparseRowVector)this._rows[r]).deleteIndexRange(cl, cu - 1);
    }

    @Override
    public void sort() {
        for (SparseRow row : this._rows) {
            if (row == null || row.isEmpty()) continue;
            row.sort();
        }
    }

    @Override
    public void sort(int r) {
        this._rows[r].sort();
    }

    @Override
    public double get(int r, int c) {
        if (!this.isAllocated(r)) {
            return 0.0;
        }
        return this._rows[r].get(c);
    }

    @Override
    public SparseRow get(int r) {
        return this._rows[r];
    }

    @Override
    public int posFIndexLTE(int r, int c) {
        if (this._rows[r] instanceof SparseRowScalar) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        return ((SparseRowVector)this._rows[r]).searchIndexesFirstLTE(c);
    }

    @Override
    public int posFIndexGTE(int r, int c) {
        if (this._rows[r] instanceof SparseRowScalar) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        return ((SparseRowVector)this._rows[r]).searchIndexesFirstGTE(c);
    }

    @Override
    public int posFIndexGT(int r, int c) {
        if (this._rows[r] instanceof SparseRowScalar) {
            this._rows[r] = new SparseRowVector(this._rows[r]);
        }
        return ((SparseRowVector)this._rows[r]).searchIndexesFirstGT(c);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseBlockMCSR: rlen=");
        sb.append(this.numRows());
        sb.append(", nnz=");
        sb.append(this.size());
        sb.append("\n");
        for (int i = 0; i < this.numRows(); ++i) {
            sb.append("row +");
            sb.append(i);
            sb.append(": ");
            sb.append(this._rows[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public SparseRow[] getRows() {
        return this._rows;
    }
}

