/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

public class MemoryEstimates {
    public static long byteArrayCost(int length) {
        long size = 0L;
        size += 8L;
        size += 20L;
        if (length <= 4) {
            size += 4L;
        } else {
            size += (long)length;
            int diff = (length - 4) % 8;
            if (diff > 0) {
                size += (long)(8 - diff);
            }
        }
        return size;
    }

    public static long charArrayCost(int length) {
        long size = 0L;
        size += 8L;
        size += 20L;
        if (length <= 2) {
            size += 4L;
        } else {
            size += (long)(length * 2);
            int diff = (length * 2 - 4) % 8;
            if (diff > 0) {
                size += (long)(8 - diff);
            }
        }
        return size;
    }

    public static long intArrayCost(int length) {
        long size = 0L;
        size += 8L;
        size += 20L;
        if (length <= 1) {
            size += 4L;
        } else {
            size += (long)(length * 4);
            if (length % 2 == 0) {
                size += 4L;
            }
        }
        return size;
    }

    public static long doubleArrayCost(long length) {
        long size = 0L;
        size += 8L;
        size += 20L;
        size += 4L;
        return size += 8L * length;
    }
}

