/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.concurrent.RejectedExecutionException;
import org.spark_project.jetty.http.HttpGenerator;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpHeaderValue;
import org.spark_project.jetty.http.HttpMethod;
import org.spark_project.jetty.http.HttpParser;
import org.spark_project.jetty.http.HttpVersion;
import org.spark_project.jetty.io.AbstractConnection;
import org.spark_project.jetty.io.ByteBufferPool;
import org.spark_project.jetty.io.Connection;
import org.spark_project.jetty.io.EndPoint;
import org.spark_project.jetty.io.EofException;
import org.spark_project.jetty.server.Connector;
import org.spark_project.jetty.server.HttpChannel;
import org.spark_project.jetty.server.HttpConfiguration;
import org.spark_project.jetty.server.HttpInput;
import org.spark_project.jetty.server.HttpInputOverHTTP;
import org.spark_project.jetty.server.HttpTransport;
import org.spark_project.jetty.server.Server;
import org.spark_project.jetty.util.BufferUtil;
import org.spark_project.jetty.util.Callback;
import org.spark_project.jetty.util.IteratingCallback;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class HttpConnection
extends AbstractConnection
implements Runnable,
HttpTransport,
Connection.UpgradeFrom {
    public static final String UPGRADE_CONNECTION_ATTRIBUTE = "org.spark_project.jetty.server.HttpConnection.UPGRADE";
    private static final boolean REQUEST_BUFFER_DIRECT = false;
    private static final boolean HEADER_BUFFER_DIRECT = false;
    private static final boolean CHUNK_BUFFER_DIRECT = false;
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private final HttpConfiguration _config;
    private final Connector _connector;
    private final ByteBufferPool _bufferPool;
    private final HttpGenerator _generator;
    private final HttpChannelOverHttp _channel;
    private final HttpParser _parser;
    private volatile ByteBuffer _requestBuffer = null;
    private volatile ByteBuffer _chunk = null;
    private final SendCallback _sendCallback = new SendCallback();

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static HttpConnection setCurrentConnection(HttpConnection connection) {
        HttpConnection last = __currentConnection.get();
        __currentConnection.set(connection);
        return last;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    public HttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
        super(endPoint, connector.getExecutor(), true);
        this._config = config;
        this._connector = connector;
        this._bufferPool = this._connector.getByteBufferPool();
        this._generator = this.newHttpGenerator();
        HttpInput<ByteBuffer> input = this.newHttpInput();
        this._channel = this.newHttpChannel(input);
        this._parser = this.newHttpParser();
        if (LOG.isDebugEnabled()) {
            LOG.debug("New HTTP Connection {}", this);
        }
    }

    protected HttpGenerator newHttpGenerator() {
        return new HttpGenerator(this._config.getSendServerVersion(), this._config.getSendXPoweredBy());
    }

    protected HttpInput<ByteBuffer> newHttpInput() {
        return new HttpInputOverHTTP(this);
    }

    protected HttpChannelOverHttp newHttpChannel(HttpInput<ByteBuffer> httpInput) {
        return new HttpChannelOverHttp(this._connector, this._config, this.getEndPoint(), this, httpInput);
    }

    protected HttpParser newHttpParser() {
        return new HttpParser(this.newRequestHandler(), this.getHttpConfiguration().getRequestHeaderSize());
    }

    protected HttpParser.RequestHandler<ByteBuffer> newRequestHandler() {
        return this._channel;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    public HttpParser getParser() {
        return this._parser;
    }

    @Override
    public int getMessagesIn() {
        return this.getHttpChannel().getRequests();
    }

    @Override
    public int getMessagesOut() {
        return this.getHttpChannel().getRequests();
    }

    @Override
    public ByteBuffer onUpgradeFrom() {
        if (BufferUtil.hasContent(this._requestBuffer)) {
            ByteBuffer buffer = this._requestBuffer;
            this._requestBuffer = null;
            return buffer;
        }
        return null;
    }

    void releaseRequestBuffer() {
        if (this._requestBuffer != null && !this._requestBuffer.hasRemaining()) {
            ByteBuffer buffer = this._requestBuffer;
            this._requestBuffer = null;
            this._bufferPool.release(buffer);
        }
    }

    public ByteBuffer getRequestBuffer() {
        if (this._requestBuffer == null) {
            this._requestBuffer = this._bufferPool.acquire(this.getInputBufferSize(), false);
        }
        return this._requestBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable {}", this, this._channel.getState());
        }
        HttpConnection last = HttpConnection.setCurrentConnection(this);
        int filled = Integer.MAX_VALUE;
        boolean suspended = false;
        try {
            while (!suspended && this.getEndPoint().getConnection() == this) {
                if (BufferUtil.isEmpty(this._requestBuffer)) {
                    if (filled <= 0) {
                        break;
                    }
                    if (this.getEndPoint().isInputShutdown()) {
                        filled = -1;
                        this._parser.atEOF();
                    } else {
                        this._requestBuffer = this.getRequestBuffer();
                        filled = this.getEndPoint().fill(this._requestBuffer);
                        if (filled == 0) {
                            filled = this.getEndPoint().fill(this._requestBuffer);
                        }
                        if (filled < 0) {
                            this._parser.atEOF();
                        }
                    }
                }
                if (this._parser.parseNext(this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : this._requestBuffer)) {
                    suspended = !this._channel.handle();
                    continue;
                }
                this.releaseRequestBuffer();
            }
        }
        catch (EofException e) {
            LOG.debug(e);
        }
        catch (Exception e) {
            if (this._parser.isIdle()) {
                LOG.debug(e);
            } else {
                LOG.warn(this.toString(), e);
            }
            this.close();
        }
        finally {
            HttpConnection.setCurrentConnection(last);
            if (!suspended && this.getEndPoint().isOpen() && this.getEndPoint().getConnection() == this) {
                this.fillInterested();
            }
        }
    }

    protected void parseContent() throws IOException {
        ByteBuffer requestBuffer = this.getRequestBuffer();
        while (this._parser.inContentState()) {
            boolean parsed = this._parser.parseNext(requestBuffer == null ? BufferUtil.EMPTY_BUFFER : requestBuffer);
            if (BufferUtil.isEmpty(requestBuffer) && this.getEndPoint().isInputShutdown()) {
                this._parser.atEOF();
                if (!parsed) continue;
                break;
            }
            if (parsed) break;
            int filled = this.getEndPoint().fill(requestBuffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} filled {}", this, filled);
            }
            if (filled > 0) continue;
            if (filled >= 0) break;
            this._parser.atEOF();
        }
    }

    @Override
    public void completed() {
        Connection connection;
        if (this._channel.getResponse().getStatus() == 101 && (connection = (Connection)this._channel.getRequest().getAttribute(UPGRADE_CONNECTION_ATTRIBUTE)) != null) {
            this._channel.getState().upgrade();
            this.getEndPoint().upgrade(connection);
            this._channel.reset();
            this._parser.reset();
            this._generator.reset();
            this.releaseRequestBuffer();
            return;
        }
        if (this._channel.isExpecting100Continue()) {
            this._parser.close();
        } else if (this._parser.inContentState() && this._generator.isPersistent()) {
            if (this._channel.getRequest().getHttpInput().isAsync()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unconsumed async input {}", this);
                }
                this._channel.abort();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("unconsumed input {}", this);
                }
                if (!this._channel.getRequest().getHttpInput().consumeAll()) {
                    this._channel.abort();
                }
            }
        }
        this._channel.reset();
        if (this._generator.isPersistent() && !this._parser.isClosed()) {
            this._parser.reset();
        } else {
            this._parser.close();
        }
        this.releaseRequestBuffer();
        if (this._chunk != null) {
            this._bufferPool.release(this._chunk);
        }
        this._chunk = null;
        this._generator.reset();
        if (HttpConnection.getCurrentConnection() != this) {
            if (this._parser.isStart()) {
                if (BufferUtil.isEmpty(this._requestBuffer)) {
                    this.fillInterested();
                } else if (this.getConnector().isRunning()) {
                    try {
                        this.getExecutor().execute(this);
                    }
                    catch (RejectedExecutionException e) {
                        if (this.getConnector().isRunning()) {
                            LOG.warn(e);
                        } else {
                            LOG.ignore(e);
                        }
                        this.getEndPoint().close();
                    }
                } else {
                    this.getEndPoint().close();
                }
            } else if (this.getEndPoint().isOpen()) {
                this.fillInterested();
            }
        }
    }

    @Override
    protected void onFillInterestedFailed(Throwable cause) {
        this._parser.close();
        super.onFillInterestedFailed(cause);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    @Override
    public void onClose() {
        this._sendCallback.close();
        super.onClose();
    }

    @Override
    public void run() {
        this.onFillable();
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
        if (info != null && this._channel.isExpecting100Continue()) {
            this._generator.setPersistent(false);
        }
        if (this._sendCallback.reset(info, content, lastContent, callback)) {
            this._sendCallback.iterate();
        }
    }

    @Override
    public void send(ByteBuffer content, boolean lastContent, Callback callback) {
        if (!lastContent && BufferUtil.isEmpty(content)) {
            callback.succeeded();
        } else if (this._sendCallback.reset(null, content, lastContent, callback)) {
            this._sendCallback.iterate();
        }
    }

    @Override
    public void abort() {
        this.getEndPoint().close();
    }

    @Override
    public String toString() {
        return String.format("%s[p=%s,g=%s,c=%s]", super.toString(), this._parser, this._generator, this._channel);
    }

    private class SendCallback
    extends IteratingCallback {
        private HttpGenerator.ResponseInfo _info;
        private ByteBuffer _content;
        private boolean _lastContent;
        private Callback _callback;
        private ByteBuffer _header;
        private boolean _shutdownOut;

        private SendCallback() {
            super(true);
        }

        private boolean reset(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean last, Callback callback) {
            if (this.reset()) {
                this._info = info;
                this._content = content;
                this._lastContent = last;
                this._callback = callback;
                this._header = null;
                this._shutdownOut = false;
                return true;
            }
            if (this.isClosed()) {
                callback.failed(new EofException());
            } else {
                callback.failed(new WritePendingException());
            }
            return false;
        }

        @Override
        public IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result2;
            if (this._callback == null) {
                throw new IllegalStateException();
            }
            ByteBuffer chunk = HttpConnection.this._chunk;
            block8: while (true) {
                result2 = HttpConnection.this._generator.generateResponse(this._info, this._header, chunk, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} generate: {} ({},{},{})@{}", new Object[]{this, result2, BufferUtil.toSummaryString(this._header), BufferUtil.toSummaryString(this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result2) {
                    case NEED_HEADER: {
                        this._header = HttpConnection.this._bufferPool.acquire(HttpConnection.this._config.getResponseHeaderSize(), false);
                        continue block8;
                    }
                    case NEED_CHUNK: {
                        chunk = HttpConnection.this._chunk = HttpConnection.this._bufferPool.acquire(12, false);
                        continue block8;
                    }
                    case FLUSH: {
                        if (HttpConnection.this._channel.getRequest().isHead() || HttpConnection.this._generator.isNoContent()) {
                            BufferUtil.clear(chunk);
                            BufferUtil.clear(this._content);
                        }
                        if (BufferUtil.hasContent(this._header)) {
                            if (BufferUtil.hasContent(this._content)) {
                                if (BufferUtil.hasContent(chunk)) {
                                    HttpConnection.this.getEndPoint().write(this, this._header, chunk, this._content);
                                } else {
                                    HttpConnection.this.getEndPoint().write(this, this._header, this._content);
                                }
                            } else {
                                HttpConnection.this.getEndPoint().write(this, this._header);
                            }
                        } else if (BufferUtil.hasContent(chunk)) {
                            if (BufferUtil.hasContent(this._content)) {
                                HttpConnection.this.getEndPoint().write(this, chunk, this._content);
                            } else {
                                HttpConnection.this.getEndPoint().write(this, chunk);
                            }
                        } else if (BufferUtil.hasContent(this._content)) {
                            HttpConnection.this.getEndPoint().write(this, this._content);
                        } else {
                            this.succeeded();
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        this._shutdownOut = true;
                        continue block8;
                    }
                    case DONE: {
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + (Object)((Object)result2));
        }

        private void releaseHeader() {
            ByteBuffer h = this._header;
            this._header = null;
            if (h != null) {
                HttpConnection.this._bufferPool.release(h);
            }
        }

        @Override
        protected void onCompleteSuccess() {
            this.releaseHeader();
            this._callback.succeeded();
            if (this._shutdownOut) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
        }

        @Override
        public void onCompleteFailure(Throwable x) {
            this.releaseHeader();
            HttpConnection.this.failedCallback(this._callback, x);
            if (this._shutdownOut) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
        }

        @Override
        public String toString() {
            return String.format("%s[i=%s,cb=%s]", super.toString(), this._info, this._callback);
        }
    }

    protected class HttpChannelOverHttp
    extends HttpChannel<ByteBuffer> {
        public HttpChannelOverHttp(Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport, HttpInput<ByteBuffer> input) {
            super(connector, config, endPoint, transport, input);
        }

        @Override
        public void earlyEOF() {
            if (this.getRequest().getMethod() == null) {
                HttpConnection.this.close();
            } else {
                super.earlyEOF();
            }
        }

        @Override
        public boolean content(ByteBuffer item) {
            super.content(item);
            return true;
        }

        @Override
        public void badMessage(int status, String reason) {
            HttpConnection.this._generator.setPersistent(false);
            super.badMessage(status, reason);
        }

        @Override
        public boolean headerComplete() {
            boolean persistent2;
            HttpVersion version = this.getHttpVersion();
            switch (version) {
                case HTTP_0_9: {
                    persistent2 = false;
                    break;
                }
                case HTTP_1_0: {
                    persistent2 = this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                    if (!persistent2) {
                        persistent2 = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (!persistent2) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                    break;
                }
                case HTTP_1_1: {
                    boolean bl = persistent2 = !this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
                    if (!persistent2) {
                        persistent2 = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (persistent2) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                    break;
                }
                case HTTP_2: {
                    boolean persistent2 = false;
                    this.badMessage(400, null);
                    return true;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!persistent2) {
                HttpConnection.this._generator.setPersistent(false);
            }
            if (!super.headerComplete()) {
                return false;
            }
            return !this.getHttpConfiguration().isDelayDispatchUntilContent() || HttpConnection.this._parser.getContentLength() <= 0L || this.isExpecting100Continue() || this.isCommitted() || !BufferUtil.isEmpty(HttpConnection.this._requestBuffer);
        }

        @Override
        protected void handleException(Throwable x) {
            HttpConnection.this._generator.setPersistent(false);
            super.handleException(x);
        }

        @Override
        public void abort() {
            super.abort();
            HttpConnection.this._generator.setPersistent(false);
        }

        @Override
        public boolean messageComplete() {
            super.messageComplete();
            return false;
        }
    }
}

