/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.json4j.utils.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wink.json4j.utils.internal.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSONSAXHandler
extends DefaultHandler {
    private static String className = "org.apache.commons.json.utils.xml.transform.impl.JSONSAXHandler";
    private static Logger logger = Logger.getLogger(className, null);
    private OutputStreamWriter osWriter = null;
    private JSONObject current = null;
    private Stack previousObjects = new Stack();
    private JSONObject head = null;
    private boolean compact = false;

    public JSONSAXHandler(OutputStream os) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "JSONHander(OutputStream) <constructor>");
        }
        this.osWriter = new OutputStreamWriter(os, "UTF-8");
        this.compact = true;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "JSONHander(OutputStream) <constructor>");
        }
    }

    public JSONSAXHandler(OutputStream os, boolean verbose) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "JSONHander(OutputStream, boolean) <constructor>");
        }
        this.osWriter = new OutputStreamWriter(os, "UTF-8");
        boolean bl = this.compact = !verbose;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "JSONHander(OutputStream, boolean) <constructor>");
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startElement(String,String,String,org.xml.sax.Attributes)");
        }
        Properties props = new Properties();
        int attrLength = attrs.getLength();
        for (int i = 0; i < attrLength; ++i) {
            props.put(attrs.getQName(i), attrs.getValue(i));
        }
        JSONObject obj = new JSONObject(localName, props);
        if (this.head == null) {
            this.current = this.head = obj;
        } else {
            if (this.current != null) {
                this.previousObjects.push(this.current);
                this.current.addJSONObject(obj);
            }
            this.current = obj;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startElement(String,String,String,org.xml.sax.Attributes)");
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "endElement(String,String,String)");
        }
        this.current = !this.previousObjects.isEmpty() ? (JSONObject)this.previousObjects.pop() : null;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endElement(String,String,String)");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "characters(char[], int, int)");
        }
        String str = new String(ch, start, length);
        if (this.current.getTagText() != null) {
            str = this.current.getTagText() + str;
        }
        this.current.setTagText(str);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "characters(char[], int, int)");
        }
    }

    public void startDocument() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "startDocument()");
        }
        this.startJSON();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startDocument()");
        }
    }

    public void endDocument() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endDocument()");
        }
        this.endJSON();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endDocument()");
        }
    }

    public void flushBuffer() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "flushBuffer()");
        }
        if (this.osWriter != null) {
            this.osWriter.flush();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "flushBuffer()");
        }
    }

    private void startJSON() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "startJSON()");
        }
        this.current = this.head = new JSONObject("", null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "startJSON()");
        }
    }

    private void endJSON() throws SAXException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, "endJSON()");
        }
        try {
            this.head.writeObject(this.osWriter, 0, true, this.compact);
            this.head = null;
            this.current = null;
            this.previousObjects.clear();
        }
        catch (Exception ex) {
            SAXException saxEx = new SAXException(ex);
            saxEx.initCause(ex);
            throw saxEx;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(className, "endJSON()");
        }
    }
}

