/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.estim;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.estim.MMNode;
import org.apache.sysds.hops.estim.SparsityEstimator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class EstimatorMatrixHistogram
extends SparsityEstimator {
    private static final boolean DEFAULT_USE_EXTENDED = true;
    private static final boolean ADVANCED_SKETCH_PROP = false;
    private final boolean _useExtended;

    public EstimatorMatrixHistogram() {
        this(true);
    }

    public EstimatorMatrixHistogram(boolean useExtended) {
        this._useExtended = useExtended;
    }

    @Override
    public DataCharacteristics estim(MMNode root) {
        return this.estim(root, true);
    }

    public DataCharacteristics estim(MMNode root, boolean topLevel) {
        MatrixHistogram h1 = this.getCachedSynopsis(root.getLeft());
        MatrixHistogram h2 = this.getCachedSynopsis(root.getRight());
        double ret = this.estimIntern(h1, h2, root.getOp(), root.getMisc());
        if (topLevel) {
            return MatrixHistogram.deriveOutputCharacteristics(h1, h2, ret, root.getOp(), root.getMisc());
        }
        if (h2 != null && root.getRight() != null) {
            h2.setData(root.getRight().isLeaf() ? root.getRight().getData() : null);
        }
        MatrixHistogram outMap = MatrixHistogram.deriveOutputHistogram(h1, h2, ret, root.getOp(), root.getMisc());
        root.setSynopsis(outMap);
        return root.setDataCharacteristics(new MatrixCharacteristics((long)outMap.getRows(), (long)outMap.getCols(), outMap.getNonZeros()));
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2) {
        return this.estim(m1, m2, SparsityEstimator.OpCode.MM);
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2, SparsityEstimator.OpCode op) {
        if (this.isExactMetadataOp(op)) {
            return this.estimExactMetaData(m1.getDataCharacteristics(), m2.getDataCharacteristics(), op).getSparsity();
        }
        MatrixHistogram h1 = new MatrixHistogram(m1, this._useExtended);
        MatrixHistogram h2 = m1 == m2 ? h1 : new MatrixHistogram(m2, this._useExtended);
        return this.estimIntern(h1, h2, op, null);
    }

    @Override
    public double estim(MatrixBlock m1, SparsityEstimator.OpCode op) {
        if (this.isExactMetadataOp(op)) {
            return this.estimExactMetaData(m1.getDataCharacteristics(), null, op).getSparsity();
        }
        MatrixHistogram h1 = new MatrixHistogram(m1, this._useExtended);
        return this.estimIntern(h1, null, op, null);
    }

    private MatrixHistogram getCachedSynopsis(MMNode node) {
        if (node == null) {
            return null;
        }
        if (node.isLeaf() && node.getSynopsis() == null) {
            node.setSynopsis(new MatrixHistogram(node.getData(), this._useExtended));
        } else if (!node.isLeaf()) {
            this.estim(node, false);
        }
        return (MatrixHistogram)node.getSynopsis();
    }

    public double estimIntern(MatrixHistogram h1, MatrixHistogram h2, SparsityEstimator.OpCode op, long[] misc) {
        double msize = (double)h1.getRows() * (double)h1.getCols();
        switch (op) {
            case MM: {
                return this.estimInternMM(h1, h2);
            }
            case MULT: {
                double scale = IntStream.range(0, h1.getCols()).mapToDouble(j -> (double)h1.cNnz[j] * (double)h2.cNnz[j]).sum() / (double)h1.getNonZeros() / (double)h2.getNonZeros();
                return IntStream.range(0, h1.getRows()).mapToDouble(i -> (double)h1.rNnz[i] * (double)h2.rNnz[i] * scale).sum() / msize;
            }
            case PLUS: {
                double scale = IntStream.range(0, h1.getCols()).mapToDouble(j -> (double)h1.cNnz[j] * (double)h2.cNnz[j]).sum() / (double)h1.getNonZeros() / (double)h2.getNonZeros();
                return IntStream.range(0, h1.getRows()).mapToDouble(i -> (double)h1.rNnz[i] + (double)h2.rNnz[i] - (double)h1.rNnz[i] * (double)h2.rNnz[i] * scale).sum() / msize;
            }
            case EQZERO: {
                return OptimizerUtils.getSparsity(h1.getRows(), h1.getCols(), (long)h1.getRows() * (long)h1.getCols() - h1.getNonZeros());
            }
            case DIAG: {
                return h1.getCols() == 1 ? OptimizerUtils.getSparsity(h1.getRows(), h1.getRows(), h1.getNonZeros()) : OptimizerUtils.getSparsity(h1.getRows(), 1L, Math.min((long)h1.getRows(), h1.getNonZeros()));
            }
            case CBIND: {
                return OptimizerUtils.getSparsity(h1.getRows(), h1.getCols() + h2.getCols(), h1.getNonZeros() + h2.getNonZeros());
            }
            case RBIND: {
                return OptimizerUtils.getSparsity(h1.getRows() + h2.getRows(), h1.getCols(), h1.getNonZeros() + h2.getNonZeros());
            }
            case NEQZERO: 
            case TRANS: 
            case RESHAPE: {
                return OptimizerUtils.getSparsity(h1.getRows(), h1.getCols(), h1.getNonZeros());
            }
        }
        throw new NotImplementedException();
    }

    private double estimInternMM(MatrixHistogram h1, MatrixHistogram h2) {
        long nnz = 0L;
        if (h1.rMaxNnz <= 1 || h2.cMaxNnz <= 1) {
            for (int j = 0; j < h1.getCols(); ++j) {
                nnz += (long)h1.cNnz[j] * (long)h2.rNnz[j];
            }
        } else if (h1.cNnz1e != null || h2.rNnz1e != null) {
            long mnOut = this._useExtended ? (long)(h1.rNonEmpty - h1.rN1) * (long)(h2.cNonEmpty - h2.cN1) : (long)(h1.getRows() - h1.rN1) * (long)(h2.getCols() - h2.cN1);
            double spOutRest = 0.0;
            for (int j = 0; j < h1.getCols(); ++j) {
                int h1c1ej = h1.cNnz1e != null ? h1.cNnz1e[j] : 0;
                int h2r1ej = h2.rNnz1e != null ? h2.rNnz1e[j] : 0;
                nnz += (long)h1c1ej * (long)h2.rNnz[j];
                nnz += (long)(h1.cNnz[j] - h1c1ej) * (long)h2r1ej;
                double lsp = (double)(h1.cNnz[j] - h1c1ej) * (double)(h2.rNnz[j] - h2r1ej) / (double)mnOut;
                spOutRest = spOutRest + lsp - spOutRest * lsp;
            }
            nnz += (long)(spOutRest * (double)mnOut);
        } else {
            long mnOut = this._useExtended ? (long)h1.rNonEmpty * (long)h2.cNonEmpty : (long)h1.getRows() * (long)h2.getCols();
            double spOut = 0.0;
            for (int j = 0; j < h1.getCols(); ++j) {
                double lsp = (double)h1.cNnz[j] * (double)h2.rNnz[j] / (double)mnOut;
                spOut = spOut + lsp - spOut * lsp;
            }
            nnz = (long)(spOut * (double)mnOut);
        }
        if (this._useExtended) {
            nnz = h1.rNdiv2 >= 0 && h2.cNdiv2 >= 0 ? Math.max((long)h1.rNdiv2 * (long)h2.cNdiv2, nnz) : nnz;
        }
        return OptimizerUtils.getSparsity(h1.getRows(), h2.getCols(), nnz);
    }

    public static class MatrixHistogram {
        private final int[] rNnz;
        private int[] rNnz1e;
        private final int[] cNnz;
        private int[] cNnz1e;
        private final int rMaxNnz;
        private final int cMaxNnz;
        private final int rN1;
        private final int cN1;
        private final int rNonEmpty;
        private final int cNonEmpty;
        private final int rNdiv2;
        private final int cNdiv2;
        private boolean fullDiag;
        private MatrixBlock _data;

        public MatrixHistogram(MatrixBlock in, boolean useExcepts) {
            block14: {
                int i;
                this.rNnz1e = null;
                this.cNnz1e = null;
                this._data = null;
                int m = in.getNumRows();
                int n = in.getNumColumns();
                this.rNnz = new int[in.getNumRows()];
                this.cNnz = new int[in.getNumColumns()];
                boolean bl = this.fullDiag = (long)in.getNumRows() == in.getNonZeros() && in.getNumRows() == in.getNumColumns();
                if (in.getLength() == in.getNonZeros()) {
                    Arrays.fill(this.rNnz, n);
                    Arrays.fill(this.cNnz, m);
                } else if (!in.isEmpty()) {
                    int i2;
                    Serializable a;
                    if (in.isInSparseFormat()) {
                        a = in.getSparseBlock();
                        for (i2 = 0; i2 < m; ++i2) {
                            if (((SparseBlock)a).isEmpty(i2)) continue;
                            int apos = ((SparseBlock)a).pos(i2);
                            int alen = ((SparseBlock)a).size(i2);
                            int[] aix = ((SparseBlock)a).indexes(i2);
                            this.rNnz[i2] = alen;
                            LibMatrixAgg.countAgg(((SparseBlock)a).values(i2), this.cNnz, aix, apos, alen);
                            this.fullDiag &= aix[apos] == i2;
                        }
                    } else {
                        a = in.getDenseBlock();
                        for (i2 = 0; i2 < m; ++i2) {
                            this.rNnz[i2] = ((DenseBlock)a).countNonZeros(i2);
                            LibMatrixAgg.countAgg(((DenseBlock)a).values(i2), this.cNnz, ((DenseBlock)a).pos(i2), n);
                            this.fullDiag &= this.rNnz[i2] == 1 && n > i2 && ((DenseBlock)a).get(i2, i2) != 0.0;
                        }
                    }
                }
                int[] rSummary = MatrixHistogram.deriveSummaryStatistics(this.rNnz, this.getCols());
                int[] cSummary = MatrixHistogram.deriveSummaryStatistics(this.cNnz, this.getRows());
                this.rMaxNnz = rSummary[0];
                this.cMaxNnz = cSummary[0];
                this.rN1 = rSummary[1];
                this.cN1 = cSummary[1];
                this.rNonEmpty = rSummary[2];
                this.cNonEmpty = cSummary[2];
                this.rNdiv2 = rSummary[3];
                this.cNdiv2 = cSummary[3];
                if (!useExcepts || in.isEmpty() || this.rMaxNnz <= 1 && this.cMaxNnz <= 1 || in.getLength() == in.getNonZeros()) break block14;
                this.rNnz1e = new int[in.getNumRows()];
                this.cNnz1e = new int[in.getNumColumns()];
                if (in.isInSparseFormat()) {
                    SparseBlock a = in.getSparseBlock();
                    for (i = 0; i < m; ++i) {
                        if (a.isEmpty(i)) continue;
                        int alen = a.size(i);
                        int apos = a.pos(i);
                        int[] aix = a.indexes(i);
                        for (int k = apos; k < apos + alen; ++k) {
                            if (this.cNnz[aix[k]] > 1) continue;
                            int n2 = i;
                            this.rNnz1e[n2] = this.rNnz1e[n2] + 1;
                        }
                        if (alen != 1) continue;
                        int n3 = aix[apos];
                        this.cNnz1e[n3] = this.cNnz1e[n3] + 1;
                    }
                } else {
                    DenseBlock a = in.getDenseBlock();
                    for (i = 0; i < m; ++i) {
                        double[] avals = a.values(i);
                        int aix = a.pos(i);
                        boolean rNnzlte1 = this.rNnz[i] <= 1;
                        for (int j = 0; j < n; ++j) {
                            if (avals[aix + j] == 0.0) continue;
                            if (this.cNnz[j] <= 1) {
                                int n4 = i;
                                this.rNnz1e[n4] = this.rNnz1e[n4] + 1;
                            }
                            if (!rNnzlte1) continue;
                            int n5 = j;
                            this.cNnz1e[n5] = this.cNnz1e[n5] + 1;
                        }
                    }
                }
            }
        }

        public MatrixHistogram(int[] r, int[] r1e, int[] c, int[] c1e, int rmax, int cmax) {
            this.rNnz1e = null;
            this.cNnz1e = null;
            this._data = null;
            this.rNnz = r;
            this.rNnz1e = r1e;
            this.cNnz = c;
            this.cNnz1e = c1e;
            this.rMaxNnz = rmax;
            this.cMaxNnz = cmax;
            this.cN1 = -1;
            this.rN1 = -1;
            this.cNdiv2 = -1;
            this.rNdiv2 = -1;
            this.rNonEmpty = (int)Arrays.stream(this.rNnz).filter(i -> i != 0).count();
            this.cNonEmpty = (int)Arrays.stream(this.cNnz).filter(i -> i != 0).count();
        }

        public int getRows() {
            return this.rNnz.length;
        }

        public int getCols() {
            return this.cNnz.length;
        }

        public int[] getRowCounts() {
            return this.rNnz;
        }

        public int[] getColCounts() {
            return this.cNnz;
        }

        public long getNonZeros() {
            return this.getRows() < this.getCols() ? IntStream.range(0, this.getRows()).mapToLong(i -> this.rNnz[i]).sum() : IntStream.range(0, this.getCols()).mapToLong(i -> this.cNnz[i]).sum();
        }

        public void setData(MatrixBlock mb) {
            this._data = mb;
        }

        public static MatrixHistogram deriveOutputHistogram(MatrixHistogram h1, MatrixHistogram h2, double spOut, SparsityEstimator.OpCode op, long[] misc) {
            switch (op) {
                case MM: {
                    return MatrixHistogram.deriveMMHistogram(h1, h2, spOut);
                }
                case MULT: {
                    return MatrixHistogram.deriveMultHistogram(h1, h2);
                }
                case PLUS: {
                    return MatrixHistogram.derivePlusHistogram(h1, h2);
                }
                case RBIND: {
                    return MatrixHistogram.deriveRbindHistogram(h1, h2);
                }
                case CBIND: {
                    return MatrixHistogram.deriveCbindHistogram(h1, h2);
                }
                case NEQZERO: {
                    return h1;
                }
                case EQZERO: {
                    return MatrixHistogram.deriveEq0Histogram(h1);
                }
                case DIAG: {
                    return MatrixHistogram.deriveDiagHistogram(h1);
                }
                case TRANS: {
                    return MatrixHistogram.deriveTransHistogram(h1);
                }
                case RESHAPE: {
                    return MatrixHistogram.deriveReshapeHistogram(h1, (int)misc[0], (int)misc[1]);
                }
            }
            throw new NotImplementedException();
        }

        public static DataCharacteristics deriveOutputCharacteristics(MatrixHistogram h1, MatrixHistogram h2, double spOut, SparsityEstimator.OpCode op, long[] misc) {
            switch (op) {
                case MM: {
                    return new MatrixCharacteristics((long)h1.getRows(), (long)h2.getCols(), OptimizerUtils.getNnz(h1.getRows(), h2.getCols(), spOut));
                }
                case MULT: 
                case PLUS: 
                case EQZERO: 
                case NEQZERO: {
                    return new MatrixCharacteristics((long)h1.getRows(), (long)h1.getCols(), OptimizerUtils.getNnz(h1.getRows(), h1.getCols(), spOut));
                }
                case RBIND: {
                    return new MatrixCharacteristics((long)(h1.getRows() + h1.getRows()), (long)h1.getCols(), OptimizerUtils.getNnz(h1.getRows() + h2.getRows(), h1.getCols(), spOut));
                }
                case CBIND: {
                    return new MatrixCharacteristics((long)h1.getRows(), (long)(h1.getCols() + h2.getCols()), OptimizerUtils.getNnz(h1.getRows(), h1.getCols() + h2.getCols(), spOut));
                }
                case DIAG: {
                    int ncol = h1.getCols() == 1 ? h1.getRows() : 1;
                    return new MatrixCharacteristics((long)h1.getRows(), (long)ncol, OptimizerUtils.getNnz(h1.getRows(), ncol, spOut));
                }
                case TRANS: {
                    return new MatrixCharacteristics((long)h1.getCols(), (long)h1.getRows(), h1.getNonZeros());
                }
                case RESHAPE: {
                    return new MatrixCharacteristics((long)((int)misc[0]), (long)((int)misc[1]), OptimizerUtils.getNnz((int)misc[0], (int)misc[1], spOut));
                }
            }
            throw new NotImplementedException();
        }

        private static MatrixHistogram deriveMMHistogram(MatrixHistogram h1, MatrixHistogram h2, double spOut) {
            if (h1.fullDiag) {
                return h2;
            }
            if (h2.fullDiag) {
                return h1;
            }
            long nnz1 = h1.getNonZeros();
            long nnz2 = h2.getNonZeros();
            double nnzOut = spOut * (double)h1.getRows() * (double)h2.getCols();
            int rMaxNnz = 0;
            int cMaxNnz = 0;
            int[] rNnz = new int[h1.getRows()];
            Random rn = new Random();
            for (int i = 0; i < h1.getRows(); ++i) {
                rNnz[i] = MatrixHistogram.probRound(nnzOut / (double)nnz1 * (double)h1.rNnz[i], rn);
                rMaxNnz = Math.max(rMaxNnz, rNnz[i]);
            }
            int[] cNnz = new int[h2.getCols()];
            for (int i = 0; i < h2.getCols(); ++i) {
                cNnz[i] = MatrixHistogram.probRound(nnzOut / (double)nnz2 * (double)h2.cNnz[i], rn);
                cMaxNnz = Math.max(cMaxNnz, cNnz[i]);
            }
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cMaxNnz);
        }

        private static MatrixHistogram deriveMultHistogram(MatrixHistogram h1, MatrixHistogram h2) {
            double scaler = IntStream.range(0, h1.getCols()).mapToDouble(j -> (double)h1.cNnz[j] * (double)h2.cNnz[j]).sum() / (double)h1.getNonZeros() / (double)h2.getNonZeros();
            double scalec = IntStream.range(0, h1.getRows()).mapToDouble(j -> (double)h1.rNnz[j] * (double)h2.rNnz[j]).sum() / (double)h1.getNonZeros() / (double)h2.getNonZeros();
            int rMaxNnz = 0;
            int cMaxNnz = 0;
            Random rn = new Random();
            int[] rNnz = new int[h1.getRows()];
            for (int i = 0; i < h1.getRows(); ++i) {
                rNnz[i] = MatrixHistogram.probRound((double)h1.rNnz[i] * (double)h2.rNnz[i] * scaler, rn);
                rMaxNnz = Math.max(rMaxNnz, rNnz[i]);
            }
            int[] cNnz = new int[h1.getCols()];
            for (int i = 0; i < h1.getCols(); ++i) {
                cNnz[i] = MatrixHistogram.probRound((double)h1.cNnz[i] * (double)h2.cNnz[i] * scalec, rn);
                cMaxNnz = Math.max(cMaxNnz, cNnz[i]);
            }
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cMaxNnz);
        }

        private static MatrixHistogram derivePlusHistogram(MatrixHistogram h1, MatrixHistogram h2) {
            double scaler = IntStream.range(0, h1.getCols()).mapToDouble(j -> (double)h1.cNnz[j] * (double)h2.cNnz[j]).sum() / (double)h1.getNonZeros() / (double)h2.getNonZeros();
            double scalec = IntStream.range(0, h1.getRows()).mapToDouble(j -> (double)h1.rNnz[j] * (double)h2.rNnz[j]).sum() / (double)h1.getNonZeros() / (double)h2.getNonZeros();
            int rMaxNnz = 0;
            int cMaxNnz = 0;
            Random rn = new Random();
            int[] rNnz = new int[h1.getRows()];
            for (int i = 0; i < h1.getRows(); ++i) {
                rNnz[i] = MatrixHistogram.probRound((double)(h1.rNnz[i] + h2.rNnz[i]) - (double)h1.rNnz[i] * (double)h2.rNnz[i] * scaler, rn);
                rMaxNnz = Math.max(rMaxNnz, rNnz[i]);
            }
            int[] cNnz = new int[h1.getCols()];
            for (int i = 0; i < h1.getCols(); ++i) {
                cNnz[i] = MatrixHistogram.probRound((double)(h1.cNnz[i] + h2.cNnz[i]) - (double)h1.cNnz[i] * (double)h2.cNnz[i] * scalec, rn);
                cMaxNnz = Math.max(cMaxNnz, cNnz[i]);
            }
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cMaxNnz);
        }

        private static MatrixHistogram deriveRbindHistogram(MatrixHistogram h1, MatrixHistogram h2) {
            int[] rNnz = ArrayUtils.addAll((int[])h1.rNnz, (int[])h2.rNnz);
            int rMaxNnz = Math.max(h1.rMaxNnz, h2.rMaxNnz);
            int[] cNnz = new int[h1.getCols()];
            int cMaxNnz = 0;
            for (int i = 0; i < h1.getCols(); ++i) {
                cNnz[i] = h1.cNnz[i] + h2.cNnz[i];
                cMaxNnz = Math.max(cMaxNnz, cNnz[i]);
            }
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cMaxNnz);
        }

        private static MatrixHistogram deriveCbindHistogram(MatrixHistogram h1, MatrixHistogram h2) {
            int[] rNnz = new int[h1.getRows()];
            int rMaxNnz = 0;
            for (int i = 0; i < h1.getRows(); ++i) {
                rNnz[i] = h1.rNnz[i] + h2.rNnz[i];
                rMaxNnz = Math.max(rMaxNnz, rNnz[i]);
            }
            int[] cNnz = ArrayUtils.addAll((int[])h1.cNnz, (int[])h2.cNnz);
            int cMaxNnz = Math.max(h1.cMaxNnz, h2.cMaxNnz);
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cMaxNnz);
        }

        private static MatrixHistogram deriveEq0Histogram(MatrixHistogram h1) {
            int m = h1.getRows();
            int n = h1.getCols();
            int[] rNnz = new int[m];
            int[] cNnz = new int[n];
            int rMaxNnz = 0;
            int cMaxNnz = 0;
            for (int i = 0; i < m; ++i) {
                rNnz[i] = n - h1.rNnz[i];
                rMaxNnz = Math.max(rMaxNnz, rNnz[i]);
            }
            for (int j = 0; j < n; ++j) {
                cNnz[j] = m - h1.cNnz[j];
                cMaxNnz = Math.max(cMaxNnz, cNnz[j]);
            }
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cMaxNnz);
        }

        private static MatrixHistogram deriveDiagHistogram(MatrixHistogram h1) {
            if (h1.getCols() == 1) {
                return new MatrixHistogram(h1.rNnz, null, h1.rNnz, null, h1.rMaxNnz, h1.rMaxNnz);
            }
            int m = h1.getRows();
            int n = h1.getCols();
            int[] rNnz = new int[m];
            int[] cNnz = new int[1];
            int rMaxNnz = 0;
            Random rand = new Random();
            for (int i = 0; i < m; ++i) {
                rNnz[i] = MatrixHistogram.probRound((double)h1.getNonZeros() / (double)n, rand);
                rMaxNnz = Math.max(rMaxNnz, rNnz[i]);
                cNnz[0] = cNnz[0] + rNnz[i];
            }
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cNnz[0]);
        }

        private static MatrixHistogram deriveTransHistogram(MatrixHistogram h1) {
            return new MatrixHistogram(h1.cNnz, h1.cNnz1e, h1.rNnz, h1.rNnz1e, h1.cMaxNnz, h1.rMaxNnz);
        }

        private static MatrixHistogram deriveReshapeHistogram(MatrixHistogram h1, int rows, int cols) {
            int cMaxNnz;
            int rMaxNnz;
            int[] cNnz;
            int[] rNnz;
            block12: {
                int n;
                int m;
                block11: {
                    int j;
                    if (h1.getRows() == rows) {
                        return h1;
                    }
                    if (h1.getCols() % cols != 0 && h1.getRows() % rows != 0) {
                        return null;
                    }
                    m = h1.getRows();
                    n = h1.getCols();
                    rNnz = new int[rows];
                    cNnz = new int[cols];
                    rMaxNnz = 0;
                    cMaxNnz = 0;
                    if (h1.getCols() % cols != 0) break block11;
                    int scale = h1.getCols() / cols;
                    int i = 0;
                    int pos = 0;
                    while (i < m) {
                        for (int j2 = 0; j2 < scale; ++j2) {
                            rNnz[pos + j2] = h1.rNnz[i] / scale;
                        }
                        rMaxNnz = Math.max(rMaxNnz, h1.rNnz[i] / scale);
                        ++i;
                        pos += scale;
                    }
                    for (j = 0; j < n; ++j) {
                        int n2 = j % cols;
                        cNnz[n2] = cNnz[n2] + h1.cNnz[j];
                    }
                    for (j = 0; j < cols; ++j) {
                        cMaxNnz = Math.max(cMaxNnz, cNnz[j]);
                    }
                    break block12;
                }
                if (h1.getRows() % rows != 0) break block12;
                int scale = h1.getRows() / rows;
                int i = 0;
                int pos = 0;
                while (i < n) {
                    for (int j = 0; j < scale; ++j) {
                        cNnz[pos + j] = h1.cNnz[i] / scale;
                    }
                    cMaxNnz = Math.max(cMaxNnz, h1.cNnz[i] / scale);
                    ++i;
                    pos += scale;
                }
                i = 0;
                pos = 0;
                while (i < m) {
                    for (int i2 = 0; i2 < scale; ++i2) {
                        int n3 = pos;
                        rNnz[n3] = rNnz[n3] + h1.rNnz[i + i2];
                    }
                    i += scale;
                    ++pos;
                }
                for (i = 0; i < rows; ++i) {
                    rMaxNnz = Math.max(rMaxNnz, rNnz[i]);
                }
            }
            return new MatrixHistogram(rNnz, null, cNnz, null, rMaxNnz, cMaxNnz);
        }

        private static int probRound(double inNnz, Random rand) {
            double randf;
            double temp = Math.floor(inNnz);
            double f = inNnz - temp;
            return (int)(f > (randf = rand.nextDouble()) ? temp + 1.0 : temp);
        }

        private static int[] deriveSummaryStatistics(int[] counts, int N) {
            int max = Integer.MIN_VALUE;
            int N2 = N / 2;
            int cntN1 = 0;
            int cntNeq0 = 0;
            int cntNdiv2 = 0;
            for (int i = 0; i < counts.length; ++i) {
                int cnti = counts[i];
                max = Math.max(max, cnti);
                cntN1 += cnti == 1 ? 1 : 0;
                cntNeq0 += cnti != 0 ? 1 : 0;
                cntNdiv2 += cnti > N2 ? 1 : 0;
            }
            return new int[]{max, cntN1, cntNeq0, cntNdiv2};
        }
    }
}

