/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetByte;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetChar;

public final class OffsetFactory {
    protected static final Log LOG = LogFactory.getLog((String)OffsetFactory.class.getName());

    public static AOffset create(int[] indexes) {
        return OffsetFactory.create(indexes, 0, indexes.length);
    }

    public static AOffset create(int[] indexes, int apos, int alen) {
        int maxValue = indexes[alen - 1];
        if (maxValue < 0) {
            throw new DMLCompressionException("Invalid sizes given");
        }
        int endLength = alen - apos;
        float avgDist = (float)maxValue / (float)endLength;
        if (avgDist < 256.0f) {
            return new OffsetByte(indexes, apos, alen);
        }
        return new OffsetChar(indexes, apos, alen);
    }

    public static AOffset readIn(DataInput in) throws IOException {
        OFF_TYPE t = OFF_TYPE.values()[in.readByte()];
        switch (t) {
            case BYTE: {
                return OffsetByte.readFields(in);
            }
            case CHAR: {
                return OffsetChar.readFields(in);
            }
        }
        throw new DMLCompressionException("Unknown input");
    }

    public static long estimateInMemorySize(int size, int nRows) {
        if (size < 0 || nRows < 0) {
            throw new DMLCompressionException("Invalid sizes given: " + size + "  " + nRows);
        }
        if (size == 0) {
            return 8L;
        }
        int avgDiff = nRows / size;
        if (avgDiff < 256) {
            return OffsetByte.getInMemorySize(size - 1);
        }
        return OffsetChar.getInMemorySize(size - 1);
    }

    public static enum OFF_TYPE {
        BYTE,
        CHAR;

    }
}

