/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.dp;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.paramserv.ParamservUtils;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.DataPartitionLocalScheme;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ORLocalScheme
extends DataPartitionLocalScheme {
    public static List<MatrixBlock> partition(int k, MatrixBlock mb, List<MatrixBlock> permutations) {
        return IntStream.range(0, k).mapToObj(i -> {
            MatrixBlock permutation = (MatrixBlock)permutations.get(i);
            return permutation.aggregateBinaryOperations(permutation, mb, new MatrixBlock(), InstructionUtils.getMatMultOperator(k));
        }).collect(Collectors.toList());
    }

    private static List<MatrixObject> doPartitioning(int k, MatrixBlock mb, List<MatrixBlock> permutations) {
        return ORLocalScheme.partition(k, mb, permutations).stream().map(ParamservUtils::newMatrixObject).collect(Collectors.toList());
    }

    @Override
    public DataPartitionLocalScheme.Result doPartitioning(int workersNum, MatrixBlock features, MatrixBlock labels) {
        List<MatrixBlock> permutations = IntStream.range(0, workersNum).mapToObj(i -> ParamservUtils.generatePermutation(features.getNumRows(), ParamservUtils.SEED + (long)i)).collect(Collectors.toList());
        List<MatrixObject> pfs = ORLocalScheme.doPartitioning(workersNum, features, permutations);
        List<MatrixObject> pls = ORLocalScheme.doPartitioning(workersNum, labels, permutations);
        return new DataPartitionLocalScheme.Result(this, pfs, pls);
    }
}

