/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.ColumnMetadata;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DecoderPassThrough
extends Decoder {
    private static final long serialVersionUID = -8525203889417422598L;
    private int[] _dcCols = null;
    private int[] _srcCols = null;

    protected DecoderPassThrough(Types.ValueType[] schema, int[] ptCols, int[] dcCols) {
        super(schema, ptCols);
        this._dcCols = dcCols;
    }

    public DecoderPassThrough() {
        super(null, null);
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        out.ensureAllocatedColumns(in.getNumRows());
        this.decode(in, out, 0, in.getNumRows());
        return out;
    }

    @Override
    public void decode(MatrixBlock in, FrameBlock out, int rl, int ru) {
        int clen = Math.min(this._colList.length, out.getNumColumns());
        for (int i = rl; i < ru; ++i) {
            for (int j = 0; j < clen; ++j) {
                int srcColID = this._srcCols[j];
                int tgtColID = this._colList[j];
                double val = in.quickGetValue(i, srcColID - 1);
                out.set(i, tgtColID - 1, UtilFunctions.doubleToObject(this._schema[tgtColID - 1], val));
            }
        }
    }

    @Override
    public Decoder subRangeDecoder(int colStart, int colEnd, int dummycodedOffset) {
        ArrayList<Integer> colList = new ArrayList<Integer>();
        ArrayList dcList = new ArrayList();
        ArrayList<Integer> srcList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this._colList.length; ++i2) {
            int colID = this._colList[i2];
            if (colID < colStart || colID >= colEnd) continue;
            colList.add(colID - (colStart - 1));
            srcList.add(this._srcCols[i2] - dummycodedOffset);
        }
        Arrays.stream(this._dcCols).filter(c -> c >= colStart && c < colEnd).forEach(c -> dcList.add(c));
        if (colList.isEmpty()) {
            return null;
        }
        DecoderPassThrough decoder = new DecoderPassThrough(Arrays.copyOfRange(this._schema, colStart - 1, colEnd - 1), colList.stream().mapToInt(i -> i).toArray(), dcList.stream().mapToInt(i -> i).toArray());
        decoder._srcCols = srcList.stream().mapToInt(i -> i).toArray();
        return decoder;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (this._dcCols.length > 0) {
            this._srcCols = new int[this._colList.length];
            int ix1 = 0;
            int ix2 = 0;
            int off = 0;
            while (ix1 < this._colList.length) {
                if (ix2 >= this._dcCols.length || this._colList[ix1] < this._dcCols[ix2]) {
                    this._srcCols[ix1] = this._colList[ix1] + off;
                    ++ix1;
                    continue;
                }
                ColumnMetadata d = meta.getColumnMetadata()[this._dcCols[ix2] - 1];
                off = (int)((long)off + (d.isDefault() ? -1L : d.getNumDistinct() - 1L));
                ++ix2;
            }
        } else {
            this._srcCols = this._colList;
        }
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        int i;
        super.writeExternal(os);
        os.writeInt(this._srcCols.length);
        for (i = 0; i < this._srcCols.length; ++i) {
            os.writeInt(this._srcCols[i]);
        }
        os.writeInt(this._dcCols.length);
        for (i = 0; i < this._dcCols.length; ++i) {
            os.writeInt(this._dcCols[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int i;
        super.readExternal(in);
        this._srcCols = new int[in.readInt()];
        for (i = 0; i < this._srcCols.length; ++i) {
            this._srcCols[i] = in.readInt();
        }
        this._dcCols = new int[in.readInt()];
        for (i = 0; i < this._dcCols.length; ++i) {
            this._dcCols[i] = in.readInt();
        }
    }
}

