/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.output.Output;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class ELIB
extends Output {
    private FlagSet externalRefFlag;
    private boolean compatibleWith6;
    private HashMap cellIndexMap;
    private static HashMap varNames;
    private HashMap viewMap;

    ELIB() {
    }

    public void write6Compatible() {
        this.compatibleWith6 = true;
    }

    protected boolean writeLib(Library lib) {
        try {
            return this.writeTheLibrary(lib);
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    private boolean writeTheLibrary(Library lib) throws IOException {
        NodeInst ni;
        Iterator nIt;
        Tool tool;
        PrimitiveArc ap;
        Iterator ait;
        PrimitivePort pp;
        Iterator pit;
        PrimitiveNode np;
        Iterator nit;
        Technology tech;
        Cell cell;
        Iterator cit;
        Cell cell2;
        View view;
        PortProto pp2;
        Iterator eit;
        PrimitiveNode np2;
        Iterator nit2;
        ArcProto ap2;
        Iterator ait2;
        Technology tech2;
        Cell cell3;
        int magic = -1597;
        if (this.compatibleWith6) {
            magic = -1593;
        }
        this.writeBigInteger(magic);
        this.writeByte((byte)2);
        this.writeByte((byte)4);
        this.writeByte((byte)1);
        int toolCount = Tool.getNumTools();
        this.writeBigInteger(toolCount);
        int techCount = Technology.getNumTechnologies();
        this.writeBigInteger(techCount);
        FlagSet cellFlag = NodeProto.getFlagSet(1);
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            cell3 = (Cell)it.next();
            cell3.clearBit(cellFlag);
            cell3.setTempObj(null);
        }
        it = lib.getCells();
        while (it.hasNext()) {
            cell3 = (Cell)it.next();
            if (cell3.isBit(cellFlag)) continue;
            Cell firstCellInGroup = null;
            Cell lastCellInGroup = null;
            Iterator git = cell3.getCellGroup().getCells();
            while (git.hasNext()) {
                Cell cellInGroup = (Cell)git.next();
                if (lastCellInGroup == null) {
                    firstCellInGroup = cellInGroup;
                } else {
                    lastCellInGroup.setTempObj(cellInGroup);
                }
                cellInGroup.setBit(cellFlag);
                lastCellInGroup = cellInGroup;
            }
            if (lastCellInGroup == null || firstCellInGroup == null) {
                lastCellInGroup = firstCellInGroup = cell3;
            }
            lastCellInGroup.setTempObj(firstCellInGroup);
        }
        cellFlag.freeFlagSet();
        int nodeIndex = 0;
        int portProtoIndex = 0;
        int nodeProtoIndex = 0;
        int arcIndex = 0;
        int primNodeProtoIndex = 0;
        int primPortProtoIndex = 0;
        int arcProtoIndex = 0;
        Iterator it2 = lib.getCells();
        while (it2.hasNext()) {
            Cell cell4 = (Cell)it2.next();
            cell4.setTempInt(nodeProtoIndex++);
            Iterator pit2 = cell4.getPorts();
            while (pit2.hasNext()) {
                Export pp3 = (Export)pit2.next();
                pp3.setTempInt(portProtoIndex++);
            }
            Iterator ait3 = cell4.getArcs();
            while (ait3.hasNext()) {
                ArcInst ai = (ArcInst)ait3.next();
                ai.setTempInt(arcIndex++);
            }
            Iterator nit3 = cell4.getNodes();
            while (nit3.hasNext()) {
                NodeInst ni2 = (NodeInst)nit3.next();
                ni2.setTempInt(nodeIndex++);
            }
        }
        int cellsHere = nodeProtoIndex;
        FlagSet externalRefFlag = NodeProto.getFlagSet(1);
        externalRefFlag.clearOnAllCells();
        varNames = new HashMap();
        this.findXLibVariables(lib);
        Iterator it3 = Tool.getTools();
        while (it3.hasNext()) {
            Tool tool2 = (Tool)it3.next();
            this.findXLibVariables(tool2);
        }
        it3 = Technology.getTechnologies();
        while (it3.hasNext()) {
            tech2 = (Technology)it3.next();
            this.findXLibVariables(tech2);
            ait2 = tech2.getArcs();
            while (ait2.hasNext()) {
                ap2 = (ArcProto)ait2.next();
                this.findXLibVariables(ap2);
            }
            nit2 = tech2.getNodes();
            while (nit2.hasNext()) {
                np2 = (PrimitiveNode)nit2.next();
                this.findXLibVariables(np2);
                eit = np2.getPorts();
                while (eit.hasNext()) {
                    pp2 = (PrimitivePort)eit.next();
                    this.findXLibVariables(pp2);
                }
            }
        }
        it3 = View.getViews();
        while (it3.hasNext()) {
            View view2 = (View)it3.next();
            this.findXLibVariables(view2);
        }
        it3 = lib.getCells();
        while (it3.hasNext()) {
            Cell cell5 = (Cell)it3.next();
            this.findXLibVariables(cell5);
            Iterator eit2 = cell5.getPorts();
            while (eit2.hasNext()) {
                Export pp4 = (Export)eit2.next();
                this.findXLibVariables(pp4);
            }
            nit2 = cell5.getNodes();
            while (nit2.hasNext()) {
                NodeInst ni3 = (NodeInst)nit2.next();
                this.findXLibVariables(ni3);
                eit = ni3.getExports();
                while (eit.hasNext()) {
                    pp2 = (Export)eit.next();
                    this.findXLibVariables(pp2);
                }
                if (!(ni3.getProto() instanceof Cell)) continue;
                ni3.getProto().setBit(externalRefFlag);
            }
            ait2 = cell5.getArcs();
            while (ait2.hasNext()) {
                ArcInst ai = (ArcInst)ait2.next();
                this.findXLibVariables(ai);
            }
        }
        it3 = Library.getLibraries();
        while (it3.hasNext()) {
            Library olib = (Library)it3.next();
            if (olib == lib) continue;
            Iterator cit2 = olib.getCells();
            while (cit2.hasNext()) {
                Cell cell6 = (Cell)cit2.next();
                if (!cell6.isBit(externalRefFlag)) continue;
                cell6.setTempInt(nodeProtoIndex++);
                eit = cell6.getPorts();
                while (eit.hasNext()) {
                    pp2 = (Export)eit.next();
                    pp2.setTempInt(portProtoIndex++);
                }
            }
        }
        it3 = Technology.getTechnologies();
        while (it3.hasNext()) {
            tech2 = (Technology)it3.next();
            nit2 = tech2.getNodes();
            while (nit2.hasNext()) {
                np2 = (PrimitiveNode)nit2.next();
                np2.setTempInt(-2 - primNodeProtoIndex++);
                eit = np2.getPorts();
                while (eit.hasNext()) {
                    pp2 = (PrimitivePort)eit.next();
                    pp2.setTempInt(-2 - primPortProtoIndex++);
                }
            }
            ait2 = tech2.getArcs();
            while (ait2.hasNext()) {
                ap2 = (ArcProto)ait2.next();
                ap2.setTempInt(-2 - arcProtoIndex++);
            }
        }
        this.writeBigInteger(primNodeProtoIndex);
        this.writeBigInteger(primPortProtoIndex);
        this.writeBigInteger(arcProtoIndex);
        this.writeBigInteger(nodeProtoIndex);
        this.writeBigInteger(nodeIndex);
        this.writeBigInteger(portProtoIndex);
        this.writeBigInteger(arcIndex);
        this.writeBigInteger(0);
        int cellCount = 0;
        if (this.compatibleWith6) {
            this.cellIndexMap = new HashMap();
            Iterator it4 = lib.getCells();
            while (it4.hasNext()) {
                Cell cell7 = (Cell)it4.next();
                String cellName = cell7.getName();
                Integer cellIndex = (Integer)this.cellIndexMap.get(cellName);
                if (cellIndex == null) {
                    cellIndex = new Integer(cellCount++);
                    this.cellIndexMap.put(cellName, cellIndex);
                }
                Iterator nIt2 = cell7.getNodes();
                while (nIt2.hasNext()) {
                    Cell subCell;
                    NodeInst ni4 = (NodeInst)nIt2.next();
                    if (!(ni4.getProto() instanceof Cell) || (subCell = (Cell)ni4.getProto()).getLibrary() == lib || (cellIndex = (Integer)this.cellIndexMap.get(cellName = subCell.getName())) != null) continue;
                    cellIndex = new Integer(cellCount++);
                    this.cellIndexMap.put(cellName, cellIndex);
                }
            }
            this.writeBigInteger(cellCount);
        }
        int curNodeProto = -1;
        if (lib.getCurCell() != null) {
            curNodeProto = lib.getCurCell().getTempInt();
        }
        this.writeBigInteger(curNodeProto);
        this.writeString(Version.getVersion());
        this.viewMap = new HashMap();
        this.viewMap.put(View.UNKNOWN, new Integer(-1));
        this.viewMap.put(View.LAYOUT, new Integer(-2));
        this.viewMap.put(View.SCHEMATIC, new Integer(-3));
        this.viewMap.put(View.ICON, new Integer(-4));
        this.viewMap.put(View.DOCWAVE, new Integer(-5));
        this.viewMap.put(View.LAYOUTSKEL, new Integer(-6));
        this.viewMap.put(View.VHDL, new Integer(-7));
        this.viewMap.put(View.NETLIST, new Integer(-8));
        this.viewMap.put(View.DOC, new Integer(-9));
        this.viewMap.put(View.NETLISTNETLISP, new Integer(-10));
        this.viewMap.put(View.NETLISTALS, new Integer(-11));
        this.viewMap.put(View.NETLISTQUISC, new Integer(-12));
        this.viewMap.put(View.NETLISTRSIM, new Integer(-13));
        this.viewMap.put(View.NETLISTSILOS, new Integer(-14));
        this.viewMap.put(View.VERILOG, new Integer(-15));
        ArrayList<View> viewsToSave = new ArrayList<View>();
        int i = 1;
        Iterator it5 = View.getViews();
        while (it5.hasNext()) {
            view = (View)it5.next();
            Integer found = (Integer)this.viewMap.get(view);
            if (found != null) continue;
            this.viewMap.put(view, new Integer(i++));
            viewsToSave.add(view);
        }
        this.writeBigInteger(viewsToSave.size());
        it5 = viewsToSave.iterator();
        while (it5.hasNext()) {
            view = (View)it5.next();
            this.writeString(view.getFullName());
            this.writeString(view.getAbbreviation());
        }
        it5 = lib.getCells();
        while (it5.hasNext()) {
            cell2 = (Cell)it5.next();
            this.writeBigInteger(cell2.getNumArcs());
            this.writeBigInteger(cell2.getNumNodes());
            this.writeBigInteger(cell2.getNumPorts());
        }
        it5 = Library.getLibraries();
        while (it5.hasNext()) {
            Library olib = (Library)it5.next();
            if (olib == lib) continue;
            cit = olib.getCells();
            while (cit.hasNext()) {
                cell = (Cell)cit.next();
                if (!cell.isBit(externalRefFlag)) continue;
                this.writeBigInteger(-1);
                this.writeBigInteger(-1);
                this.writeBigInteger(cell.getNumPorts());
            }
        }
        it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = (Technology)it5.next();
            this.writeString(tech.getTechName());
            this.writeBigInteger(tech.getNumNodes());
            nit = tech.getNodes();
            while (nit.hasNext()) {
                np = (PrimitiveNode)nit.next();
                this.writeString(np.getName());
                this.writeBigInteger(np.getNumPorts());
                pit = np.getPorts();
                while (pit.hasNext()) {
                    pp = (PrimitivePort)pit.next();
                    this.writeString(pp.getName());
                }
            }
            this.writeBigInteger(tech.getNumArcs());
            ait = tech.getArcs();
            while (ait.hasNext()) {
                ap = (PrimitiveArc)ait.next();
                this.writeString(ap.getName());
            }
        }
        it5 = Tool.getTools();
        while (it5.hasNext()) {
            tool = (Tool)it5.next();
            this.writeString(tool.getName());
        }
        this.writeBigInteger(lib.lowLevelGetUserBits());
        it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = (Technology)it5.next();
            this.writeBigInteger((int)tech.getScale() * 2);
        }
        Iterator cIt = lib.getCells();
        while (cIt.hasNext()) {
            cell2 = (Cell)cIt.next();
            nIt = cell2.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    Iterator it6 = pi.getVariables();
                    while (it6.hasNext()) {
                        Variable var = (Variable)it6.next();
                        if (var.isDontSave()) continue;
                        StringBuffer sb = new StringBuffer();
                        String portName = pi.getPortProto().getName();
                        int len = portName.length();
                        for (int j = 0; j < len; ++j) {
                            char ch = portName.charAt(j);
                            if (ch == '\\' || ch == '_') {
                                sb.append('\\');
                            }
                            sb.append(ch);
                        }
                        String newVarName = "ATTRP_" + sb.toString() + "_" + var.getKey().getName();
                        Undo.setNextChangeQuiet();
                        Variable newVar = ni.newVar(newVarName, var.getObject());
                        if (var.isDisplay()) {
                            newVar.setDisplay(true);
                        }
                        newVar.setCode(var.getCode());
                        newVar.setTextDescriptor(var.getTextDescriptor());
                    }
                }
            }
        }
        this.writeNameSpace();
        Output.createFontAssociationVariable(lib);
        this.writeVariables(lib, 0.0);
        it5 = Tool.getTools();
        while (it5.hasNext()) {
            tool = (Tool)it5.next();
            this.writeVariables(tool, 0.0);
        }
        it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = (Technology)it5.next();
            this.writeVariables(tech, 0.0);
        }
        it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = (Technology)it5.next();
            ait = tech.getArcs();
            while (ait.hasNext()) {
                ap = (PrimitiveArc)ait.next();
                this.writeVariables(ap, 0.0);
            }
        }
        it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = (Technology)it5.next();
            nit = tech.getNodes();
            while (nit.hasNext()) {
                np = (PrimitiveNode)nit.next();
                this.writeVariables(np, 0.0);
            }
        }
        it5 = Technology.getTechnologies();
        while (it5.hasNext()) {
            tech = (Technology)it5.next();
            nit = tech.getNodes();
            while (nit.hasNext()) {
                np = (PrimitiveNode)nit.next();
                pit = np.getPorts();
                while (pit.hasNext()) {
                    pp = (PrimitivePort)pit.next();
                    this.writeVariables(pp, 0.0);
                }
            }
        }
        this.writeBigInteger(View.getNumViews());
        it5 = View.getViews();
        while (it5.hasNext()) {
            view = (View)it5.next();
            Integer viewIndex = (Integer)this.viewMap.get(view);
            this.writeBigInteger(viewIndex);
            this.writeVariables(view, 0.0);
        }
        if (this.compatibleWith6) {
            String[] cellNames = new String[cellCount];
            Iterator it7 = this.cellIndexMap.keySet().iterator();
            while (it7.hasNext()) {
                String cellName = (String)it7.next();
                Integer cellIndex = (Integer)this.cellIndexMap.get(cellName);
                if (cellIndex == null) continue;
                cellNames[cellIndex.intValue()] = cellName;
            }
            for (int j = 0; j < cellCount; ++j) {
                this.writeString(cellNames[j]);
                this.writeBigInteger(0);
            }
        }
        it5 = lib.getCells();
        while (it5.hasNext()) {
            Cell cell8 = (Cell)it5.next();
            this.writeNodeProto(cell8, true);
        }
        it5 = Library.getLibraries();
        while (it5.hasNext()) {
            Library olib = (Library)it5.next();
            if (olib == lib) continue;
            cit = olib.getCells();
            while (cit.hasNext()) {
                cell = (Cell)cit.next();
                if (!cell.isBit(externalRefFlag)) continue;
                this.writeNodeProto(cell, false);
            }
        }
        it5 = lib.getCells();
        while (it5.hasNext()) {
            Cell cell9 = (Cell)it5.next();
            ait = cell9.getArcs();
            while (ait.hasNext()) {
                ArcInst ai = (ArcInst)ait.next();
                this.writeArcInst(ai);
            }
            nit = cell9.getNodes();
            while (nit.hasNext()) {
                ni = (NodeInst)nit.next();
                this.writeNodeInst(ni);
            }
        }
        cIt = lib.getCells();
        while (cIt.hasNext()) {
            Cell cell10 = (Cell)cIt.next();
            nIt = cell10.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                boolean found = true;
                block63: while (found) {
                    found = false;
                    Iterator it8 = ni.getVariables();
                    while (it8.hasNext()) {
                        Variable var = (Variable)it8.next();
                        String varName = var.getKey().getName();
                        if (!varName.startsWith("ATTRP_")) continue;
                        Undo.setNextChangeQuiet();
                        ni.delVar(var.getKey());
                        found = true;
                        continue block63;
                    }
                }
            }
        }
        if (!lib.isHidden()) {
            System.out.println(this.filePath + " written (" + cellsHere + " cells)");
        }
        lib.clearChangedMinor();
        lib.clearChangedMajor();
        lib.setFromDisk();
        externalRefFlag.freeFlagSet();
        return false;
    }

    private void writeNodeProto(Cell cell, boolean thislib) throws IOException {
        if (this.compatibleWith6) {
            Integer cellIndex = (Integer)this.cellIndexMap.get(cell.getName());
            this.writeBigInteger(cellIndex);
        } else {
            this.writeString(cell.getName());
            int nextGrp = -1;
            Object obj = cell.getTempObj();
            if (obj != null && obj instanceof Cell) {
                Cell nextInGroup = (Cell)obj;
                nextGrp = nextInGroup.getTempInt();
            }
            this.writeBigInteger(nextGrp);
            int nextCont = -1;
            this.writeBigInteger(nextCont);
        }
        Integer viewIndex = (Integer)this.viewMap.get(cell.getView());
        if (viewIndex == null) {
            viewIndex = new Integer(0);
        }
        this.writeBigInteger(viewIndex);
        this.writeBigInteger(cell.getVersion());
        this.writeBigInteger((int)ELIBConstants.dateToSeconds(cell.getCreationDate()));
        this.writeBigInteger((int)ELIBConstants.dateToSeconds(cell.getRevisionDate()));
        Technology tech = cell.getTechnology();
        Rectangle2D bounds = cell.getBounds();
        int lowX = (int)(bounds.getMinX() * tech.getScale() * 2.0);
        int highX = (int)(bounds.getMaxX() * tech.getScale() * 2.0);
        int lowY = (int)(bounds.getMinY() * tech.getScale() * 2.0);
        int highY = (int)(bounds.getMaxY() * tech.getScale() * 2.0);
        this.writeBigInteger(lowX);
        this.writeBigInteger(highX);
        this.writeBigInteger(lowY);
        this.writeBigInteger(highY);
        if (!thislib) {
            Library instlib = cell.getLibrary();
            this.writeString(instlib.getLibFile().getPath());
        }
        this.writeBigInteger(cell.getNumPorts());
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (thislib) {
                int i = -1;
                PortInst pi = pp.getOriginalPort();
                if (pi != null) {
                    i = pi.getNodeInst().getTempInt();
                } else {
                    System.out.println("ERROR: cell " + cell.describe() + " export " + pp.getName() + " has no subnode");
                }
                this.writeBigInteger(i);
                i = -1;
                if (pi != null) {
                    i = pi.getPortProto().getTempInt();
                } else {
                    System.out.println("ERROR: cell " + cell.describe() + " export " + pp.getName() + " has no subport");
                }
                this.writeBigInteger(i);
            }
            this.writeString(pp.getName());
            if (!thislib) continue;
            TextDescriptor td = pp.getTextDescriptor();
            this.writeBigInteger(td.lowLevelGet0());
            this.writeBigInteger(td.lowLevelGet1());
            this.writeBigInteger(pp.lowLevelGetUserbits());
            this.writeVariables(pp, 0.0);
        }
        if (thislib) {
            this.writeBigInteger(0);
            this.writeBigInteger(cell.lowLevelGetUserbits());
            this.writeVariables(cell, 0.0);
        }
    }

    private void writeNodeInst(NodeInst ni) throws IOException {
        int highY;
        int lowY;
        int highX;
        int lowX;
        NodeProto np = ni.getProto();
        this.writeBigInteger(np.getTempInt());
        Technology tech = ni.getParent().getTechnology();
        if (np instanceof Cell) {
            lowX = (int)((ni.getTrueCenterX() - ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            highX = (int)((ni.getTrueCenterX() + ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            lowY = (int)((ni.getTrueCenterY() - ni.getYSize() / 2.0) * tech.getScale() * 2.0);
            highY = (int)((ni.getTrueCenterY() + ni.getYSize() / 2.0) * tech.getScale() * 2.0);
        } else {
            lowX = (int)((ni.getAnchorCenterX() - ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            highX = (int)((ni.getAnchorCenterX() + ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            lowY = (int)((ni.getAnchorCenterY() - ni.getYSize() / 2.0) * tech.getScale() * 2.0);
            highY = (int)((ni.getAnchorCenterY() + ni.getYSize() / 2.0) * tech.getScale() * 2.0);
        }
        this.writeBigInteger(lowX);
        this.writeBigInteger(lowY);
        this.writeBigInteger(highX);
        this.writeBigInteger(highY);
        if (np instanceof Cell && !this.compatibleWith6) {
            int anchorX = (int)(ni.getAnchorCenterX() * tech.getScale() * 2.0);
            int anchorY = (int)(ni.getAnchorCenterY() * tech.getScale() * 2.0);
            this.writeBigInteger(anchorX);
            this.writeBigInteger(anchorY);
        }
        int transpose = 0;
        int rotation = ni.getAngle();
        if (this.compatibleWith6) {
            if (ni.isXMirrored()) {
                if (ni.isYMirrored()) {
                    rotation = (rotation + 1800) % 3600;
                } else {
                    rotation = (rotation + 900) % 3600;
                    transpose = 1;
                }
            } else if (ni.isYMirrored()) {
                rotation = (rotation + 2700) % 3600;
                transpose = 1;
            }
        } else {
            if (ni.isXMirrored()) {
                transpose |= 2;
            }
            if (ni.isYMirrored()) {
                transpose |= 4;
            }
        }
        this.writeBigInteger(transpose);
        this.writeBigInteger(rotation);
        TextDescriptor td = ni.getProtoTextDescriptor();
        this.writeBigInteger(td.lowLevelGet0());
        this.writeBigInteger(td.lowLevelGet1());
        int numConnections = ni.getNumConnections();
        this.writeBigInteger(numConnections);
        if (numConnections > 0) {
            ArrayList sortedList = new ArrayList();
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
            Collections.sort(sortedList, new OrderedConnections());
            it = sortedList.iterator();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                ArcInst ai = con.getArc();
                int i = ai.getTempInt() << 1;
                if (ai.getHead() == con) {
                    ++i;
                }
                this.writeBigInteger(i);
                PortInst pi = con.getPortInst();
                int protoIndex = pi.getPortProto().getTempInt();
                this.writeBigInteger(protoIndex);
                this.writeNoVariables();
            }
        }
        int numExports = ni.getNumExports();
        this.writeBigInteger(numExports);
        if (numExports > 0) {
            ArrayList sortedList = new ArrayList();
            Iterator it = ni.getExports();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
            Collections.sort(sortedList, new OrderedExports());
            it = sortedList.iterator();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                this.writeBigInteger(pp.getTempInt());
                this.writeBigInteger(pp.getOriginalPort().getPortProto().getTempInt());
                this.writeNoVariables();
            }
        }
        this.writeBigInteger(ni.lowLevelGetUserbits());
        this.writeVariables(ni, tech.getScale() * 2.0);
    }

    private void writeArcInst(ArcInst ai) throws IOException {
        this.writeBigInteger(ai.getProto().getTempInt());
        Technology tech = ai.getParent().getTechnology();
        this.writeBigInteger((int)(ai.getWidth() * tech.getScale() * 2.0));
        Point2D location = ai.getTail().getLocation();
        this.writeBigInteger((int)(location.getX() * tech.getScale() * 2.0));
        this.writeBigInteger((int)(location.getY() * tech.getScale() * 2.0));
        this.writeBigInteger(ai.getTail().getPortInst().getNodeInst().getTempInt());
        location = ai.getHead().getLocation();
        this.writeBigInteger((int)(location.getX() * tech.getScale() * 2.0));
        this.writeBigInteger((int)(location.getY() * tech.getScale() * 2.0));
        this.writeBigInteger(ai.getHead().getPortInst().getNodeInst().getTempInt());
        int arcAngle = ai.getAngle() / 10;
        ai.lowLevelSetArcAngle(arcAngle);
        int userBits = ai.lowLevelGetUserbits();
        userBits &= 0xFFFAFFFF;
        if (ai.getTail().isNegated()) {
            userBits = ai.isReverseEnds() ? (userBits |= 0x10000) : (userBits |= 0x40000);
        }
        if (ai.getHead().isNegated()) {
            userBits = ai.isReverseEnds() ? (userBits |= 0x40000) : (userBits |= 0x10000);
        }
        this.writeBigInteger(userBits);
        this.writeVariables(ai, 0.0);
    }

    private boolean writeNameSpace() throws IOException {
        Variable.Key key;
        int numVariableNames = ElectricObject.getNumVariableKeys();
        this.writeBigInteger(numVariableNames);
        Variable.Key[] nameList = new Variable.Key[numVariableNames];
        Iterator it = ElectricObject.getVariableKeys();
        while (it.hasNext()) {
            nameList[key.getIndex()] = key = (Variable.Key)it.next();
        }
        for (int i = 0; i < numVariableNames; ++i) {
            key = nameList[i];
            if (key == null) {
                this.writeString("");
                continue;
            }
            this.writeString(key.getName());
        }
        return false;
    }

    private void writeNoVariables() throws IOException {
        this.writeBigInteger(0);
    }

    private int writeVariables(ElectricObject obj, double scale) throws IOException {
        Variable var;
        int count = 0;
        Iterator it = obj.getVariables();
        while (it.hasNext()) {
            var = (Variable)it.next();
            if (var.isDontSave()) continue;
            ++count;
        }
        if (obj instanceof Geometric && ((Geometric)obj).getNameKey() != null) {
            ++count;
        }
        this.writeBigInteger(count);
        it = obj.getVariables();
        while (it.hasNext()) {
            int i;
            var = (Variable)it.next();
            if (var.isDontSave()) continue;
            Variable.Key key = var.getKey();
            short index = (short)key.getIndex();
            this.writeSmallInteger(index);
            Float[] varObj = var.getObject();
            int type = var.lowLevelGetFlags() & 0xE0000160;
            if (varObj instanceof Object[]) {
                Object[] objList = varObj;
                type |= ELIBConstants.getVarType(objList[0]) | 0x80 | objList.length << 9;
            } else {
                if (this.compatibleWith6 && varObj instanceof Double) {
                    varObj = new Float((Double)varObj);
                }
                type |= ELIBConstants.getVarType(varObj);
            }
            if (obj instanceof NodeInst && key == NodeInst.TRACE && varObj instanceof Point2D[]) {
                Point2D[] points = (Point2D[])varObj;
                type = var.lowLevelGetFlags() & 0xE0000160;
                int len = points.length * 2;
                type |= 0x85 | len << 9;
                Float[] newPoints = new Float[len];
                for (i = 0; i < points.length; ++i) {
                    newPoints[i * 2] = new Float(points[i].getX());
                    newPoints[i * 2 + 1] = new Float(points[i].getY());
                }
                varObj = newPoints;
            }
            this.writeBigInteger(type);
            TextDescriptor td = var.getTextDescriptor();
            this.writeBigInteger(td.lowLevelGet0());
            this.writeBigInteger(td.lowLevelGet1());
            if (varObj instanceof Object[]) {
                Object[] objList = varObj;
                int len = objList.length;
                this.writeBigInteger(len);
                for (i = 0; i < len; ++i) {
                    Object oneObj = objList[i];
                    this.putOutVar(oneObj);
                }
                continue;
            }
            this.putOutVar(varObj);
        }
        if (obj instanceof Geometric && ((Geometric)obj).getNameKey() != null) {
            Geometric geom = (Geometric)obj;
            Variable.Key key = geom instanceof NodeInst ? NodeInst.NODE_NAME : ArcInst.ARC_NAME;
            this.writeSmallInteger((short)key.getIndex());
            int type = 4;
            if (geom.isUsernamed()) {
                type |= 0x40;
            }
            this.writeBigInteger(type);
            this.writeBigInteger(geom.getNameTextDescriptor().lowLevelGet0());
            this.writeBigInteger(geom.getNameTextDescriptor().lowLevelGet1());
            this.putOutVar(geom.getName());
        }
        return count;
    }

    private void putOutVar(Object obj) throws IOException {
        if (obj instanceof Integer) {
            this.writeBigInteger((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            this.writeSmallInteger((Short)obj);
            return;
        }
        if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
            return;
        }
        if (obj instanceof String) {
            this.writeString((String)obj);
            return;
        }
        if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Double) {
            this.writeDouble((Double)obj);
            return;
        }
        if (obj instanceof Point2D) {
            this.writeFloat((float)((Point2D)obj).getX());
            this.writeFloat((float)((Point2D)obj).getY());
            return;
        }
        if (obj instanceof Technology) {
            Technology tech = (Technology)obj;
            if (tech == null) {
                this.writeBigInteger(-1);
            } else {
                this.writeBigInteger(tech.getIndex());
            }
            return;
        }
        if (obj instanceof Library) {
            Library lib = (Library)obj;
            if (lib == null) {
                this.writeString("noname");
            } else {
                this.writeString(lib.getName());
            }
            return;
        }
        if (obj instanceof Tool) {
            Tool tool = (Tool)obj;
            if (tool == null) {
                this.writeBigInteger(-1);
            } else {
                this.writeBigInteger(tool.getIndex());
            }
            return;
        }
        if (obj instanceof NodeInst) {
            NodeInst ni = (NodeInst)obj;
            if (ni == null) {
                this.writeBigInteger(-1);
            } else {
                this.writeBigInteger(ni.getTempInt());
            }
            return;
        }
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            if (ai == null) {
                this.writeBigInteger(-1);
            } else {
                this.writeBigInteger(ai.getTempInt());
            }
            return;
        }
        if (obj instanceof NodeProto) {
            NodeProto np = (NodeProto)obj;
            if (np == null) {
                this.writeBigInteger(-1);
            } else {
                this.writeBigInteger(np.getTempInt());
            }
            return;
        }
        if (obj instanceof ArcProto) {
            ArcProto ap = (ArcProto)obj;
            if (ap == null) {
                this.writeBigInteger(-1);
            } else {
                this.writeBigInteger(ap.getTempInt());
            }
            return;
        }
        if (obj instanceof PortProto) {
            PortProto pp = (PortProto)obj;
            if (pp == null) {
                this.writeBigInteger(-1);
            } else {
                this.writeBigInteger(pp.getTempInt());
            }
            return;
        }
        System.out.println("Error: Cannot write objects of type " + obj.getClass());
    }

    private void findXLibVariables(ElectricObject obj) {
        Iterator it = obj.getVariables();
        while (it.hasNext()) {
            Object refObj;
            Variable var = (Variable)it.next();
            if (var.isDontSave() || !((refObj = var.getObject()) instanceof NodeProto) && !(refObj instanceof NodeProto[])) continue;
            if (refObj instanceof NodeProto[]) {
                Object[] npArray = (Object[])refObj;
                int len = npArray.length;
                for (int j = 0; j < len; ++j) {
                    NodeProto np = (NodeProto)npArray[j];
                    if (!(np instanceof Cell)) continue;
                    np.setBit(this.externalRefFlag);
                }
                continue;
            }
            NodeProto np = (NodeProto)refObj;
            if (!(np instanceof Cell)) continue;
            np.setBit(this.externalRefFlag);
        }
    }

    private void writeByte(byte b) throws IOException {
        this.dataOutputStream.write(b);
    }

    private void writeBigInteger(int i) throws IOException {
        this.dataOutputStream.writeInt(i);
    }

    private void writeFloat(float f) throws IOException {
        this.dataOutputStream.writeFloat(f);
    }

    private void writeDouble(double d) throws IOException {
        this.dataOutputStream.writeDouble(d);
    }

    private void writeSmallInteger(short s) throws IOException {
        this.dataOutputStream.writeShort(s);
    }

    private void writeString(String s) throws IOException {
        int len = s.length();
        this.writeBigInteger(len);
        this.dataOutputStream.write(s.getBytes(), 0, len);
    }

    private static class OrderedExports
    implements Comparator {
        private OrderedExports() {
        }

        public int compare(Object o1, Object o2) {
            Export e1 = (Export)o1;
            Export e2 = (Export)o2;
            int i1 = e1.getOriginalPort().getPortProto().getPortIndex();
            int i2 = e2.getOriginalPort().getPortProto().getPortIndex();
            return i1 - i2;
        }
    }

    private static class OrderedConnections
    implements Comparator {
        private OrderedConnections() {
        }

        public int compare(Object o1, Object o2) {
            Connection c1 = (Connection)o1;
            Connection c2 = (Connection)o2;
            int i1 = c1.getPortInst().getPortProto().getPortIndex();
            int i2 = c2.getPortInst().getPortProto().getPortIndex();
            return i1 - i2;
        }
    }
}

