/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.NetObject;

public class StratHashParts
extends Strategy {
    private int numPartsProcessed;
    private int numEquivProcessed;

    private StratHashParts(NccGlobals globals) {
        super(globals);
    }

    private void preamble(int nbParts) {
        this.startTime("StratHashParts", nbParts + " Parts");
    }

    private void summary(LeafList offspring) {
        this.globals.println(" processed " + this.numPartsProcessed + " Parts from " + this.numEquivProcessed + " leaf Records");
        this.globals.println(this.offspringStats(offspring));
        this.globals.println(offspring.sizeInfoString());
        this.elapsedTime();
    }

    public LeafList doFor(EquivRecord g) {
        if (g.isLeaf()) {
            ++this.numEquivProcessed;
        }
        return super.doFor(g);
    }

    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Part), "StratHashPartAll expects only Parts");
        ++this.numPartsProcessed;
        Part p = (Part)n;
        return p.computeHashCode();
    }

    public static LeafList doYourJob(RecordList l, NccGlobals globals) {
        StratHashParts jhpa = new StratHashParts(globals);
        if (l.size() == 0) {
            return new LeafList();
        }
        jhpa.preamble(l.size());
        LeafList offspring = jhpa.doFor(l);
        jhpa.summary(offspring);
        return offspring;
    }
}

