/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ChangeCellGroup
extends EDialog {
    private static Preferences prefs = Preferences.userNodeForPackage(ChangeCellGroup.class);
    private static final String selectedRadioButton = "ChangeCellGroup-WhichMoveType";
    private Cell cell;
    private Library initialLibrary;
    private List cellGroups;
    private JButton apply;
    private ButtonGroup buttonGroup1;
    private JComboBox cellGroupsComboBox;
    private JLabel cellNameLabel;
    private JPanel mainPanel;
    private JRadioButton moveOwnCellGroup;
    private JRadioButton moveToCellGroup;

    public ChangeCellGroup(Frame parent, boolean modal, Cell cell, Library initialLibrary) {
        super(parent, modal);
        this.setTitle("Change Cell Group");
        this.cell = cell;
        this.initialLibrary = initialLibrary;
        this.cellGroups = new ArrayList();
        this.initComponents();
        this.cellNameLabel.setText("Change Cell Group for Cell: " + cell.describe());
        this.populateCellGroupsComboBox(cell, initialLibrary);
        int selected = prefs.getInt(selectedRadioButton, 0);
        this.cellGroupsComboBox.setEnabled(false);
        switch (selected) {
            case 0: {
                this.moveOwnCellGroup.setSelected(true);
                break;
            }
            case 1: {
                this.moveToCellGroup.setSelected(true);
            }
        }
        this.pack();
    }

    private void populateCellGroupsComboBox(Cell cell, Library lib) {
        this.cellGroups.clear();
        this.cellGroupsComboBox.removeAllItems();
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            Cell.CellGroup cg = c.getCellGroup();
            if (cg == null || cg == cell.getCellGroup() || this.cellGroups.contains(cg)) continue;
            this.cellGroups.add(cg);
            this.cellGroupsComboBox.addItem(cg.getName());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.cellNameLabel = new JLabel();
        this.moveOwnCellGroup = new JRadioButton();
        this.moveToCellGroup = new JRadioButton();
        this.cellGroupsComboBox = new JComboBox();
        this.apply = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ChangeCellGroup.this.closeDialog(evt);
            }
        });
        this.mainPanel.setLayout(new GridBagLayout());
        this.cellNameLabel.setText("cellName");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.mainPanel.add((Component)this.cellNameLabel, gridBagConstraints);
        this.moveOwnCellGroup.setText("Move to it's own cell group");
        this.buttonGroup1.add(this.moveOwnCellGroup);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.moveOwnCellGroup, gridBagConstraints);
        this.moveToCellGroup.setText("Move to Cell Group: ");
        this.buttonGroup1.add(this.moveToCellGroup);
        this.moveToCellGroup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ChangeCellGroup.this.moveToCellGroupItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.moveToCellGroup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.cellGroupsComboBox, gridBagConstraints);
        this.apply.setText("OK");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChangeCellGroup.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.apply, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void moveToCellGroupItemStateChanged(ItemEvent evt) {
        boolean selected = this.moveToCellGroup.isSelected();
        this.cellGroupsComboBox.setEnabled(selected);
    }

    private void applyActionPerformed(ActionEvent evt) {
        Cell.CellGroup newGroup = new Cell.CellGroup();
        boolean doIt = true;
        if (this.moveOwnCellGroup.isSelected()) {
            if (this.cell.getCellGroup() != null && this.cell.getCellGroup().getNumCells() == 1) {
                doIt = false;
            }
        } else if (this.moveToCellGroup.isSelected()) {
            int selected = this.cellGroupsComboBox.getSelectedIndex();
            newGroup = (Cell.CellGroup)this.cellGroups.toArray()[selected];
            if (this.cell.getCellGroup() == newGroup) {
                doIt = false;
            }
        }
        if (doIt) {
            ChangeCellGroupJob job = new ChangeCellGroupJob(this.cell, newGroup);
        }
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        int selected = 0;
        selected = this.moveOwnCellGroup.isSelected() ? 0 : selected;
        selected = this.moveToCellGroup.isSelected() ? 1 : selected;
        prefs.putInt(selectedRadioButton, selected);
        this.setVisible(false);
        this.dispose();
    }

    private static class ChangeCellGroupJob
    extends Job {
        private Cell cell;
        private Cell.CellGroup newGroup;

        ChangeCellGroupJob(Cell cell, Cell.CellGroup newGroup) {
            super("Change Cell Group", User.tool, Job.Type.CHANGE, cell, cell, Job.Priority.USER);
            this.cell = cell;
            this.newGroup = newGroup;
            this.startJob();
        }

        public boolean doIt() {
            this.cell.setCellGroup(this.newGroup);
            WindowFrame.wantToRedoLibraryTree();
            return true;
        }
    }
}

