/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.constraint;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class Layout
extends Constraints {
    private static final Layout layoutConstraint = new Layout();
    private static final boolean DEBUG = false;
    private static int changeClock = 10;
    private static HashSet deletedArcs;
    private HashSet cellModFlag;
    private HashSet cellNoModFlag;

    private Layout() {
    }

    public static Layout getConstraint() {
        return layoutConstraint;
    }

    public void startBatch(Tool tool, boolean undoRedo) {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                cell.rememberBounds();
            }
        }
    }

    public void endBatch() {
        ArrayList changedCells = new ArrayList();
        Iterator it = Undo.ChangeCell.getIterator();
        while (it.hasNext()) {
            changedCells.add(it.next());
        }
        deletedArcs = new HashSet();
        it = changedCells.iterator();
        while (it.hasNext()) {
            Undo.ChangeCell cc = (Undo.ChangeCell)it.next();
            Cell cell = cc.getCell();
            boolean forcedLook = cc.getForcedLook();
            this.computeCell(cell, forcedLook);
        }
        deletedArcs = null;
        Undo.ChangeBatch curBatch = Undo.getCurrentBatch();
        if (curBatch == null) {
            return;
        }
        Iterator it2 = curBatch.getChanges();
        while (it2.hasNext()) {
            Undo.Change c = (Undo.Change)it2.next();
            if (c.getType() == Undo.Type.NODEINSTNEW || c.getType() == Undo.Type.NODEINSTKILL || c.getType() == Undo.Type.NODEINSTMOD) {
                NodeInst ni = (NodeInst)c.getObject();
                ni.setChange(null);
                continue;
            }
            if (c.getType() == Undo.Type.ARCINSTNEW || c.getType() == Undo.Type.ARCINSTKILL || c.getType() == Undo.Type.ARCINSTMOD) {
                ArcInst ai = (ArcInst)c.getObject();
                ai.setChange(null);
                continue;
            }
            if (c.getType() == Undo.Type.EXPORTNEW || c.getType() == Undo.Type.EXPORTKILL || c.getType() == Undo.Type.EXPORTMOD) {
                Export pp = (Export)c.getObject();
                pp.setChange(null);
                continue;
            }
            if (c.getType() != Undo.Type.CELLNEW && c.getType() != Undo.Type.CELLKILL && c.getType() != Undo.Type.CELLMOD) continue;
            Cell cell = (Cell)c.getObject();
            cell.setChange(null);
        }
    }

    public void newObject(ElectricObject obj) {
    }

    public void killExport(Export pp, Collection oldPortInsts) {
    }

    public void newVariable(ElectricObject obj, Variable var) {
    }

    public static void setTempRigid(ArcInst ai, boolean tempRigid) {
        if (tempRigid) {
            if (ai.getChangeClock() == changeClock + 2) {
                return;
            }
            ai.setChangeClock(changeClock + 2);
        } else {
            if (ai.getChangeClock() == changeClock + 3) {
                return;
            }
            ai.setChangeClock(changeClock + 3);
        }
    }

    public static void removeTempRigid(ArcInst ai) {
        if (ai.getChangeClock() != changeClock + 3 && ai.getChangeClock() != changeClock + 2) {
            return;
        }
        ai.setChangeClock(changeClock - 3);
    }

    public void modifyNodeInst(NodeInst ni, double dCX, double dCY, double dSX, double dSY, int dRot) {
        boolean flipY;
        changeClock += 4;
        double oldSX = ni.getXSizeWithMirror();
        double oldSY = ni.getYSizeWithMirror();
        if (Layout.alterNodeInst(ni, dCX, dCY, dSX, dSY, dRot, false)) {
            Undo.ChangeCell.forceHierarchicalAnalysis(ni.getParent());
        }
        deletedArcs = new HashSet();
        boolean flipX = oldSX * ni.getXSizeWithMirror() < 0.0;
        boolean bl = flipY = oldSY * ni.getYSizeWithMirror() < 0.0;
        if (Layout.modNodeArcs(ni, dRot, dSX, dSY, flipX, flipY)) {
            Undo.ChangeCell.forceHierarchicalAnalysis(ni.getParent());
        }
        deletedArcs = null;
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] dCX, double[] dCY, double[] dSX, double[] dSY, int[] dRot) {
        int i;
        changeClock += 4;
        Cell parent = null;
        boolean[] flipX = new boolean[nis.length];
        boolean[] flipY = new boolean[nis.length];
        for (i = 0; i < nis.length; ++i) {
            double oldSX = nis[i].getXSizeWithMirror();
            double oldSY = nis[i].getYSizeWithMirror();
            if (Layout.alterNodeInst(nis[i], dCX[i], dCY[i], dSX[i], dSY[i], dRot[i], false)) {
                parent = nis[i].getParent();
            }
            flipX[i] = oldSX * nis[i].getXSizeWithMirror() < 0.0;
            flipY[i] = oldSY * nis[i].getYSizeWithMirror() < 0.0;
        }
        deletedArcs = new HashSet();
        for (i = 0; i < nis.length; ++i) {
            if (!Layout.modNodeArcs(nis[i], dRot[i], dSX[i], dSY[i], flipX[i], flipY[i])) continue;
            parent = nis[i].getParent();
        }
        if (parent != null) {
            Undo.ChangeCell.forceHierarchicalAnalysis(parent);
        }
        deletedArcs = null;
    }

    private static boolean alterNodeInst(NodeInst ni, double deltaCX, double deltaCY, double deltaSX, double deltaSY, int dAngle, boolean announce) {
        if (ni.getChangeClock() >= changeClock) {
            return false;
        }
        boolean flipX = ni.isXMirrored();
        if ((ni.getXSizeWithMirror() + deltaSX) * ni.getXSizeWithMirror() < 0.0) {
            flipX = !flipX;
        }
        boolean flipY = ni.isYMirrored();
        if ((ni.getYSizeWithMirror() + deltaSY) * ni.getYSizeWithMirror() < 0.0) {
            boolean bl = flipY = !flipY;
        }
        if (flipX ^ flipY) {
            dAngle = (3600 - dAngle) % 3600;
        }
        int oldang = ni.getAngle();
        double oldCX = ni.getAnchorCenterX();
        double oldCY = ni.getAnchorCenterY();
        double oldSX = ni.getXSizeWithMirror();
        double oldSY = ni.getYSizeWithMirror();
        ni.lowLevelModify(deltaCX, deltaCY, deltaSX, deltaSY, dAngle);
        if (ni.getChangeClock() != changeClock) {
            Undo.modifyNodeInst(ni, oldCX, oldCY, oldSX, oldSY, oldang);
        }
        ni.setChangeClock(changeClock);
        return ni.getNumExports() != 0;
    }

    private static boolean modNodeArcs(NodeInst ni, int dangle, double dSX, double dSY, boolean flipX, boolean flipY) {
        boolean examineCell = false;
        Layout.modWithin(ni, dangle, dSX, dSY, flipX, flipY);
        if (Layout.modRigid(ni, dangle, dSX, dSY, flipX, flipY)) {
            examineCell = true;
        }
        if (Layout.modFlex(ni, dangle, dSX, dSY, flipX, flipY)) {
            examineCell = true;
        }
        return examineCell;
    }

    private static void modWithin(NodeInst ni, int dAngle, double dSX, double dSY, boolean flipX, boolean flipY) {
        Undo.Change change = ni.getChange();
        if (change != null && change.getType() == Undo.Type.NODEINSTNEW) {
            return;
        }
        ArrayList<ArcInst> interiorArcs = new ArrayList<ArcInst>();
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (ai.getHead().getPortInst().getNodeInst() != ai.getTail().getPortInst().getNodeInst() || ai.getChangeClock() == changeClock) continue;
            interiorArcs.add(ai);
        }
        it = interiorArcs.iterator();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (deletedArcs.contains(ai)) continue;
            if (ai.getChangeClock() == changeClock) {
                Layout.ensureArcInst(ai, 0);
                continue;
            }
            AffineTransform trans = NodeInst.pureRotate(dAngle, flipX, flipY);
            double ox = change.getA1();
            double oy = change.getA2();
            Layout.adjustMatrix(ni, ai.getHead().getPortInst().getPortProto(), trans);
            Point2D.Double newHead = new Point2D.Double();
            Point2D.Double src = new Point2D.Double(ai.getHead().getLocation().getX() - ox, ai.getHead().getLocation().getY() - oy);
            trans.transform(src, newHead);
            Layout.adjustMatrix(ni, ai.getTail().getPortInst().getPortProto(), trans);
            Point2D.Double newTail = new Point2D.Double();
            ((Point2D)src).setLocation(ai.getTail().getLocation().getX() - ox, ai.getTail().getLocation().getY() - oy);
            trans.transform(src, newTail);
            Layout.doMoveArcInst(ai, newHead, newTail, 0);
        }
    }

    private static boolean modRigid(NodeInst ni, int dAngle, double dSX, double dSY, boolean flipX, boolean flipY) {
        NodeInst ono;
        int thatEndIndex;
        Connection thatEnd;
        int thisEndIndex;
        Connection thisEnd;
        ArcInst ai;
        ArrayList<ArcInst> rigidArcs = new ArrayList<ArcInst>();
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai2 = con.getArc();
            if (ai2.getChangeClock() == changeClock - 1 || ai2.getChangeClock() == changeClock + 1 || ai2.getChangeClock() != changeClock - 2 && !ai2.isRigid() || ai2.getHead().getPortInst().getNodeInst() == ai2.getTail().getPortInst().getNodeInst()) continue;
            rigidArcs.add(ai2);
        }
        if (rigidArcs.size() == 0) {
            return false;
        }
        AffineTransform trans = NodeInst.pureRotate(dAngle, flipX, flipY);
        boolean examineCell = false;
        Iterator it2 = rigidArcs.iterator();
        while (it2.hasNext()) {
            ai = (ArcInst)it2.next();
            if (deletedArcs.contains(ai)) continue;
            ai.clearRigidModified();
            if (ai.getChangeClock() == changeClock) {
                Layout.ensureArcInst(ai, 0);
                continue;
            }
            thisEnd = ai.getHead();
            thisEndIndex = 0;
            thatEnd = ai.getTail();
            thatEndIndex = 1;
            if (thatEnd.getPortInst().getNodeInst() == ni) {
                thisEnd = ai.getTail();
                thisEndIndex = 1;
                thatEnd = ai.getHead();
                thatEndIndex = 0;
            }
            ono = thatEnd.getPortInst().getNodeInst();
            PortProto opt = thatEnd.getPortInst().getPortProto();
            Undo.Change change = ni.getChange();
            double ox = 0.0;
            double oy = 0.0;
            if (change != null && change.getType() != Undo.Type.NODEINSTNEW) {
                ox = change.getA1();
                oy = change.getA2();
                Layout.adjustMatrix(ni, thisEnd.getPortInst().getPortProto(), trans);
            }
            Point2D.Double[] newPts = new Point2D.Double[]{new Point2D.Double(), new Point2D.Double()};
            Point2D.Double src = new Point2D.Double(thisEnd.getLocation().getX() - ox, thisEnd.getLocation().getY() - oy);
            trans.transform(src, newPts[thisEndIndex]);
            ((Point2D)src).setLocation(thatEnd.getLocation().getX() - ox, thatEnd.getLocation().getY() - oy);
            trans.transform(src, newPts[thatEndIndex]);
            boolean locked = false;
            if (ono.getChangeClock() == changeClock) {
                locked = true;
            } else if (ono.isLocked()) {
                locked = true;
            } else if (ono.getProto() instanceof Cell) {
                if (ono.getParent().isInstancesLocked()) {
                    locked = true;
                }
            } else if (User.isDisallowModificationLockedPrims() && ((PrimitiveNode)ono.getProto()).isLockedPrim()) {
                locked = true;
            }
            if (!locked) {
                Poly oldPoly = Layout.oldPortPosition(ono, opt);
                double oldX = oldPoly.getCenterX();
                double oldY = oldPoly.getCenterY();
                Poly oPoly = thatEnd.getPortInst().getPoly();
                double dx = oPoly.getCenterX();
                double dy = oPoly.getCenterY();
                double othX = dx - oldX;
                double othY = dy - oldY;
                ((Point2D)src).setLocation(ono.getAnchorCenterX() - ox, ono.getAnchorCenterY() - oy);
                Point2D.Double ptD = new Point2D.Double();
                trans.transform(src, ptD);
                dx = ((Point2D)ptD).getX();
                dy = ((Point2D)ptD).getY();
                dx = dx - ono.getAnchorCenterX() - othX;
                dy = dy - ono.getAnchorCenterY() - othY;
                int nextAngle = dAngle;
                boolean thisWasTranspose = false;
                if (change != null && change.getType() != Undo.Type.NODEINSTNEW) {
                    thisWasTranspose = change.getA3() < 0.0 ^ change.getA4() < 0.0;
                }
                boolean onoTranspose = ono.isXMirrored() ^ ono.isYMirrored();
                boolean dTrans = flipX ^ flipY;
                boolean oFlipX = ono.isXMirrored();
                if (flipX) {
                    oFlipX = !oFlipX;
                }
                boolean oFlipY = ono.isYMirrored();
                if (flipY) {
                    boolean bl = oFlipY = !oFlipY;
                }
                if (dTrans && onoTranspose != thisWasTranspose) {
                    nextAngle = (3600 - nextAngle) % 3600;
                }
                if (dx != 0.0 || dy != 0.0 || nextAngle != 0 || ono.getChangeClock() != changeClock) {
                    ai.setRigidModified();
                    double changeSX = 0.0;
                    double changeSY = 0.0;
                    if (oFlipX != ono.isXMirrored()) {
                        changeSX = -ono.getXSizeWithMirror() * 2.0;
                    }
                    if (oFlipY != ono.isYMirrored()) {
                        changeSY = -ono.getYSizeWithMirror() * 2.0;
                    }
                    if (Layout.alterNodeInst(ono, dx, dy, changeSX, changeSY, nextAngle, true)) {
                        examineCell = true;
                    }
                }
            }
            Layout.doMoveArcInst(ai, newPts[0], newPts[1], 0);
        }
        it2 = rigidArcs.iterator();
        while (it2.hasNext()) {
            ai = (ArcInst)it2.next();
            if (deletedArcs.contains(ai) || !ai.isRigidModified()) continue;
            thisEnd = ai.getHead();
            thisEndIndex = 0;
            thatEnd = ai.getTail();
            thatEndIndex = 1;
            ono = ai.getTail().getPortInst().getNodeInst() == ni ? ai.getHead().getPortInst().getNodeInst() : ai.getTail().getPortInst().getNodeInst();
            int nextAngle = dAngle;
            if (ono.isXMirrored() ^ ono.isYMirrored()) {
                nextAngle = (3600 - nextAngle) % 3600;
            }
            if (!Layout.modNodeArcs(ono, nextAngle, 0.0, 0.0, flipX, flipY)) continue;
            examineCell = true;
        }
        return examineCell;
    }

    private static boolean modFlex(NodeInst ni, int dAngle, double dSX, double dSY, boolean flipX, boolean flipY) {
        ArrayList<ArcInst> flexArcs = new ArrayList<ArcInst>();
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (ai.getChangeClock() == changeClock - 2 || ai.getChangeClock() == changeClock || ai.getChangeClock() != changeClock - 1 && ai.isRigid() || ai.getHead().getPortInst().getNodeInst() == ai.getTail().getPortInst().getNodeInst()) continue;
            flexArcs.add(ai);
        }
        if (flexArcs.size() == 0) {
            return false;
        }
        int nextAngle = dAngle;
        if (ni.isXMirrored() ^ ni.isYMirrored()) {
            nextAngle = (3600 - dAngle) % 3600;
        }
        AffineTransform trans = NodeInst.pureRotate(nextAngle, flipX, flipY);
        boolean examineCell = false;
        Iterator it2 = flexArcs.iterator();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            if (deletedArcs.contains(ai)) continue;
            if (ai.getChangeClock() >= changeClock + 1) {
                Layout.ensureArcInst(ai, 1);
                continue;
            }
            Connection thisEnd = ai.getHead();
            int thisEndIndex = 0;
            Connection thatEnd = ai.getTail();
            int thatEndIndex = 1;
            if (thatEnd.getPortInst().getNodeInst() == ni) {
                thisEnd = ai.getTail();
                thisEndIndex = 1;
                thatEnd = ai.getHead();
                thatEndIndex = 0;
            }
            if (ai.isSlidable() && ai.stillInPort(thisEnd, thisEnd.getLocation(), true)) continue;
            Undo.Change change = ni.getChange();
            double ox = 0.0;
            double oy = 0.0;
            if (change != null && change.getType() == Undo.Type.NODEINSTMOD) {
                ox = change.getA1();
                oy = change.getA2();
                Layout.adjustMatrix(ni, thisEnd.getPortInst().getPortProto(), trans);
            }
            Point2D[] newPts = new Point2D.Double[2];
            newPts[thisEndIndex] = new Point2D.Double();
            newPts[thatEndIndex] = new Point2D.Double();
            Point2D.Double src = new Point2D.Double(thisEnd.getLocation().getX() - ox, thisEnd.getLocation().getY() - oy);
            trans.transform(src, newPts[thisEndIndex]);
            ((Point2D)newPts[thisEndIndex]).setLocation(DBMath.round(((Point2D)newPts[thisEndIndex]).getX()), DBMath.round(((Point2D)newPts[thisEndIndex]).getY()));
            Poly poly = thisEnd.getPortInst().getPoly();
            if (poly.isInside(newPts[thisEndIndex])) {
                Rectangle2D bbox = poly.getBounds2D();
                if (((Point2D)newPts[thisEndIndex]).getY() >= bbox.getMinY() && ((Point2D)newPts[thisEndIndex]).getY() <= bbox.getMaxY()) {
                    if (((Point2D)newPts[thisEndIndex]).getX() < bbox.getMinX()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(bbox.getMinX(), ((Point2D)newPts[thisEndIndex]).getY());
                    } else if (((Point2D)newPts[thisEndIndex]).getX() > bbox.getMaxX()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(bbox.getMaxX(), ((Point2D)newPts[thisEndIndex]).getY());
                    }
                } else if (((Point2D)newPts[thisEndIndex]).getX() >= bbox.getMinX() && ((Point2D)newPts[thisEndIndex]).getX() <= bbox.getMaxX()) {
                    if (((Point2D)newPts[thisEndIndex]).getY() < bbox.getMinY()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(((Point2D)newPts[thisEndIndex]).getX(), bbox.getMinY());
                    } else if (((Point2D)newPts[thisEndIndex]).getY() > bbox.getMaxY()) {
                        ((Point2D)newPts[thisEndIndex]).setLocation(((Point2D)newPts[thisEndIndex]).getX(), bbox.getMaxY());
                    }
                } else {
                    Point2D pt = poly.closestPoint(newPts[thisEndIndex]);
                    newPts[thisEndIndex].setLocation(pt);
                }
            }
            NodeInst ono = thatEnd.getPortInst().getNodeInst();
            newPts[thatEndIndex].setLocation(thatEnd.getLocation());
            boolean mangle = true;
            if (!ai.isFixedAngle()) {
                mangle = false;
            } else if (ono.isLocked()) {
                mangle = false;
            } else if (ono.getProto() instanceof Cell) {
                if (ono.getParent().isInstancesLocked()) {
                    mangle = false;
                }
            } else if (User.isDisallowModificationLockedPrims() && ((PrimitiveNode)ono.getProto()).isLockedPrim()) {
                mangle = false;
            }
            if (mangle) {
                double dx = ((Point2D)newPts[thisEndIndex]).getX() - thisEnd.getLocation().getX();
                double dy = ((Point2D)newPts[thisEndIndex]).getY() - thisEnd.getLocation().getY();
                double odx = ((Point2D)newPts[thatEndIndex]).getX() - thatEnd.getLocation().getX();
                double ody = ((Point2D)newPts[thatEndIndex]).getY() - thatEnd.getLocation().getY();
                if (DBMath.doublesEqual(thisEnd.getLocation().getX(), thatEnd.getLocation().getX()) && (!DBMath.doublesEqual(thisEnd.getLocation().getY(), thatEnd.getLocation().getY()) || ai.getAngle() == 900 || ai.getAngle() == 2700)) {
                    double xAmount;
                    if (dx == odx) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    ((Point2D)newPts[thatEndIndex]).setLocation(newPts[thatEndIndex].getX() + dx - odx, newPts[thatEndIndex].getY());
                    if (!DBMath.doublesEqual(dx, odx) && ai.isSlidable() && ai.stillInPort(thatEnd, newPts[thatEndIndex], true)) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    if (ono.getChangeClock() == changeClock) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    if (dx != odx && Layout.alterNodeInst(ono, xAmount = DBMath.round(dx - odx), 0.0, 0.0, 0.0, 0, true)) {
                        examineCell = true;
                    }
                    Layout.doMoveArcInst(ai, newPts[0], newPts[1], 1);
                    if (DBMath.doublesEqual(dx, odx) || !Layout.modNodeArcs(ono, 0, 0.0, 0.0, false, false)) continue;
                    examineCell = true;
                    continue;
                }
                if (DBMath.doublesEqual(thisEnd.getLocation().getY(), thatEnd.getLocation().getY())) {
                    if (DBMath.doublesEqual(dy, ody)) {
                        ody = 0.0;
                        dy = 0.0;
                    }
                    ((Point2D)newPts[thatEndIndex]).setLocation(newPts[thatEndIndex].getX(), newPts[thatEndIndex].getY() + dy - ody);
                    if (!DBMath.doublesEqual(dy, ody) && ai.isSlidable() && ai.stillInPort(thatEnd, newPts[thatEndIndex], true)) {
                        ody = 0.0;
                        dy = 0.0;
                    }
                    if (ono.getChangeClock() == changeClock) {
                        odx = 0.0;
                        dx = 0.0;
                    }
                    if (!DBMath.doublesEqual(dy, ody) && Layout.alterNodeInst(ono, 0.0, dy - ody, 0.0, 0.0, 0, true)) {
                        examineCell = true;
                    }
                    Layout.doMoveArcInst(ai, newPts[0], newPts[1], 1);
                    if (DBMath.doublesEqual(dy, ody) || !Layout.modNodeArcs(ono, 0, 0.0, 0.0, false, false)) continue;
                    examineCell = true;
                    continue;
                }
                Layout.nonOrthogFixAng(ai, thisEnd, thisEndIndex, thatEnd, thatEndIndex, ono, newPts);
                dx = newPts[thatEndIndex].getX() - thatEnd.getLocation().getX();
                dy = newPts[thatEndIndex].getY() - thatEnd.getLocation().getY();
                Layout.updateArc(ai, newPts[0], newPts[1], 1);
                if (ono.getChangeClock() == changeClock) {
                    dy = 0.0;
                    dx = 0.0;
                }
                if (dx == 0.0 && dy == 0.0) continue;
                if (Layout.alterNodeInst(ono, dx, dy, 0.0, 0.0, 0, true)) {
                    examineCell = true;
                }
                if (!Layout.modNodeArcs(ono, 0, 0.0, 0.0, false, false)) continue;
                examineCell = true;
                continue;
            }
            Layout.doMoveArcInst(ai, newPts[0], newPts[1], 1);
        }
        return examineCell;
    }

    private static void nonOrthogFixAng(ArcInst ai, Connection thisEnd, int thisEndIndex, Connection thatEnd, int thatEndIndex, NodeInst ono, Point2D[] newPts) {
        double bestDist = Double.MIN_VALUE;
        ArcInst bestAI = null;
        Iterator it = ono.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst oai = con.getArc();
            if (oai == ai || oai.getLength() < bestDist) continue;
            bestDist = oai.getLength();
            bestAI = oai;
        }
        if (bestAI == null) {
            newPts[thatEndIndex].setLocation(newPts[thatEndIndex].getX() + newPts[thisEndIndex].getX() - thisEnd.getLocation().getX(), newPts[thatEndIndex].getY() + newPts[thisEndIndex].getY() - thisEnd.getLocation().getY());
            return;
        }
        Point2D inter = DBMath.intersect(newPts[thisEndIndex], ai.getAngle(), bestAI.getHead().getLocation(), bestAI.getAngle());
        if (inter == null) {
            newPts[thatEndIndex].setLocation(newPts[thatEndIndex].getX() + newPts[thisEndIndex].getX() - thisEnd.getLocation().getX(), newPts[thatEndIndex].getY() + newPts[thisEndIndex].getY() - thisEnd.getLocation().getY());
            return;
        }
        newPts[thatEndIndex].setLocation(inter);
    }

    private static void ensureArcInst(ArcInst ai, int arctyp) {
        Connection head = ai.getHead();
        Point2D headPoint = head.getLocation();
        boolean inside0 = ai.stillInPort(head, headPoint, true);
        Connection tail = ai.getTail();
        Point2D tailPoint = tail.getLocation();
        boolean inside1 = ai.stillInPort(tail, tailPoint, true);
        if (inside0 && inside1) {
            return;
        }
        Poly headPoly = head.getPortInst().getPoly();
        Poly tailPoly = tail.getPortInst().getPoly();
        if (!ai.isFixedAngle()) {
            double fx = headPoly.getCenterX();
            double fy = headPoly.getCenterY();
            double tx = tailPoly.getCenterX();
            double ty = tailPoly.getCenterY();
            Layout.doMoveArcInst(ai, new Point2D.Double(fx, fy), new Point2D.Double(tx, ty), arctyp);
            return;
        }
        Rectangle2D headBounds = headPoly.getBounds2D();
        Rectangle2D tailBounds = tailPoly.getBounds2D();
        double lx0 = headBounds.getMinX();
        double hx0 = headBounds.getMaxX();
        double ly0 = headBounds.getMinY();
        double hy0 = headBounds.getMaxY();
        double lx1 = tailBounds.getMinX();
        double hx1 = tailBounds.getMaxX();
        double ly1 = tailBounds.getMinY();
        double hy1 = tailBounds.getMaxY();
        if (lx0 <= hx1 && lx1 <= hx0) {
            double tx;
            double fx = tx = (Math.max(lx0, lx1) + Math.min(hx0, hx1)) / 2.0;
            double fy = (ly0 + hy0) / 2.0;
            double ty = (ly1 + hy1) / 2.0;
            Point2D fPt = headPoly.closestPoint(new Point2D.Double(fx, fy));
            Point2D tPt = tailPoly.closestPoint(new Point2D.Double(tx, ty));
            Layout.doMoveArcInst(ai, fPt, tPt, arctyp);
            return;
        }
        if (ly0 <= hy1 && ly1 <= hy0) {
            double ty;
            double fy = ty = (Math.max(ly0, ly1) + Math.min(hy0, hy1)) / 2.0;
            double fx = (lx0 + hx0) / 2.0;
            double tx = (lx1 + hx1) / 2.0;
            Point2D fPt = headPoly.closestPoint(new Point2D.Double(fx, fy));
            Point2D tPt = tailPoly.closestPoint(new Point2D.Double(tx, ty));
            Layout.doMoveArcInst(ai, fPt, tPt, arctyp);
            return;
        }
        double fx = headPoly.getCenterX();
        double fy = headPoly.getCenterY();
        double tx = tailPoly.getCenterX();
        double ty = tailPoly.getCenterY();
        Layout.doMoveArcInst(ai, new Point2D.Double(fx, fy), new Point2D.Double(tx, ty), arctyp);
    }

    private static void updateArc(ArcInst ai, Point2D headPt, Point2D tailPt, int arctyp) {
        Point2D oldHeadPt = ai.getHead().getLocation();
        Point2D oldTailPt = ai.getTail().getLocation();
        double oldHeadX = oldHeadPt.getX();
        double oldHeadY = oldHeadPt.getY();
        double oldTailX = oldTailPt.getX();
        double oldTailY = oldTailPt.getY();
        ai.lowLevelModify(0.0, headPt.getX() - oldHeadX, headPt.getY() - oldHeadY, tailPt.getX() - oldTailX, tailPt.getY() - oldTailY);
        if (ai.getChange() == null) {
            Undo.modifyArcInst(ai, oldHeadX, oldHeadY, oldTailX, oldTailY, ai.getWidth());
            ai.setChangeClock(changeClock + arctyp);
        }
    }

    private static void doMoveArcInst(ArcInst ai, Point2D headPt, Point2D tailPt, int arctyp) {
        ArcInst ar2;
        Rectangle2D no2Bounds;
        Point2D.Double no2Pt;
        double oldxB;
        double oldxA;
        double oldyB;
        double oldyA;
        Connection head = ai.getHead();
        Connection tail = ai.getTail();
        if (headPt.equals(head.getLocation()) && tailPt.equals(tail.getLocation()) && arctyp != 0) {
            return;
        }
        if (!ai.isFixedAngle() || ai.isRigid() && ai.getChangeClock() != changeClock - 1 || ai.getChangeClock() == changeClock - 2 || headPt.equals(tailPt) || ai.getAngle() % 1800 == DBMath.figureAngle(tailPt, headPt) % 1800) {
            Layout.updateArc(ai, headPt, tailPt, arctyp);
            return;
        }
        PortInst fpi = head.getPortInst();
        NodeInst fno = fpi.getNodeInst();
        PortProto fpt = fpi.getPortProto();
        PortInst tpi = tail.getPortInst();
        NodeInst tno = tpi.getNodeInst();
        PortProto tpt = tpi.getPortProto();
        ArcProto ap = ai.getProto();
        Cell pnt = ai.getParent();
        double wid = ai.getWidth();
        PrimitiveNode np = ((PrimitiveArc)ap).findOverridablePinProto();
        double psx = np.getDefWidth();
        double psy = np.getDefHeight();
        NodeInst no1 = null;
        NodeInst no2 = null;
        if (DBMath.doublesEqual(head.getLocation().getX(), tail.getLocation().getX())) {
            oldyB = oldyA = (tailPt.getY() + headPt.getY()) / 2.0;
            oldxA = headPt.getX();
            oldxB = tailPt.getX();
            no1 = NodeInst.newInstance(np, new Point2D.Double(oldxB, oldyB), psx, psy, pnt);
            no2 = NodeInst.newInstance(np, new Point2D.Double(oldxA, oldyA), psx, psy, pnt);
        } else {
            oldyA = headPt.getY();
            oldyB = tailPt.getY();
            oldxB = oldxA = (tailPt.getX() + headPt.getX()) / 2.0;
            no1 = NodeInst.newInstance(np, new Point2D.Double(oldxB, oldyB), psx, psy, pnt);
            no2 = NodeInst.newInstance(np, new Point2D.Double(oldxA, oldyA), psx, psy, pnt);
        }
        if (no1 == null || no2 == null) {
            System.out.println("Problem creating jog pins");
            return;
        }
        PortInst no1pi = no1.getOnlyPortInst();
        Rectangle2D no1Bounds = no1pi.getPoly().getBounds2D();
        Point2D.Double no1Pt = new Point2D.Double(no1Bounds.getCenterX(), no1Bounds.getCenterY());
        PortInst no2pi = no2.getOnlyPortInst();
        ArcInst ar1 = ArcInst.newInstance(ap, wid, fpi, no2pi, headPt, no2Pt = new Point2D.Double((no2Bounds = no2pi.getPoly().getBounds2D()).getCenterX(), no2Bounds.getCenterY()), null, 0);
        if (ar1 == null) {
            return;
        }
        ar1.copyStateBits(ai);
        if (ai.getHead().isNegated()) {
            ar1.getHead().setNegated(true);
        }
        if ((ar2 = ArcInst.newInstance(ap, wid, no2pi, no1pi, no2Pt, no1Pt, null, 0)) == null) {
            return;
        }
        ar2.copyStateBits(ai);
        ArcInst ar3 = ArcInst.newInstance(ap, wid, no1pi, tpi, no1Pt, tailPt, null, 0);
        if (ar3 == null) {
            return;
        }
        ar3.copyStateBits(ai);
        if (ai.getTail().isNegated()) {
            ar3.getTail().setNegated(true);
        }
        if (ar1 == null || ar2 == null || ar3 == null) {
            System.out.println("Problem creating jog arcs");
            return;
        }
        ar2.copyVarsFrom(ai);
        ar2.setNameTextDescriptor(ai.getNameTextDescriptor());
        ar1.setChangeClock(changeClock + arctyp);
        ar2.setChangeClock(changeClock + arctyp);
        ar3.setChangeClock(changeClock + arctyp);
        deletedArcs.add(ai);
        ar2.setNameTextDescriptor(ai.getNameTextDescriptor());
        ai.kill();
        String oldName = ai.getName();
        if (oldName != null) {
            ar2.setName(oldName);
        }
    }

    private static void adjustMatrix(NodeInst ni, PortProto pp, AffineTransform trans) {
        double m00 = trans.getScaleX();
        double m01 = trans.getShearX();
        double m11 = trans.getScaleY();
        double m10 = trans.getShearY();
        double m02 = ni.getAnchorCenterX();
        double m12 = ni.getAnchorCenterY();
        Undo.Change change = ni.getChange();
        if (change.getA3() * ni.getXSizeWithMirror() >= 0.0 && change.getA4() * ni.getYSizeWithMirror() >= 0.0 && change.getI1() == ni.getAngle()) {
            Poly oldPoly = Layout.oldPortPosition(ni, pp);
            Point2D.Double ono = new Point2D.Double(oldPoly.getCenterX(), oldPoly.getCenterY());
            Poly curPoly = ni.getShapeOfPort(pp);
            double dx = curPoly.getCenterX();
            double dy = curPoly.getCenterY();
            double ox = change.getA1();
            double oy = change.getA2();
            if (oldPoly.getBounds2D().getWidth() > 0.0) {
                m00 = curPoly.getBounds2D().getWidth() / oldPoly.getBounds2D().getWidth();
            }
            if (oldPoly.getBounds2D().getHeight() > 0.0) {
                m11 = curPoly.getBounds2D().getHeight() / oldPoly.getBounds2D().getHeight();
            }
            m02 = dx - ((Point2D)ono).getX() + ox;
            m12 = dy - ((Point2D)ono).getY() + oy;
        }
        trans.setTransform(m00, m10, m01, m11, m02, m12);
    }

    private static Poly oldPortPosition(NodeInst ni, PortProto pp) {
        AffineTransform subrot = Layout.makeOldRot(ni);
        NodeInst bottomNi = ni;
        PortProto bottomPP = pp;
        while (bottomNi.getProto() instanceof Cell) {
            AffineTransform localtran = Layout.makeOldTrans(bottomNi);
            subrot.concatenate(localtran);
            Undo.Change change = ((Export)bottomPP).getChange();
            if (change != null && change.getType() == Undo.Type.EXPORTMOD) {
                PortInst bottomPi = (PortInst)change.getO1();
                bottomNi = bottomPi.getNodeInst();
                bottomPP = bottomPi.getPortProto();
            } else {
                bottomNi = ((Export)bottomPP).getOriginalPort().getNodeInst();
                bottomPP = ((Export)bottomPP).getOriginalPort().getPortProto();
            }
            localtran = Layout.makeOldRot(bottomNi);
            subrot.concatenate(localtran);
        }
        Undo.Change change = bottomNi.getChange();
        if (change != null && change.getType() == Undo.Type.NODEINSTMOD) {
            double cX = change.getA1();
            double cY = change.getA2();
            double sX = change.getA3();
            double sY = change.getA4();
            int angle = change.getI1();
            NodeInst oldNi = NodeInst.lowLevelAllocate();
            oldNi.lowLevelPopulate(bottomNi.getProto(), new Point2D.Double(cX, cY), sX, sY, angle, bottomNi.getParent());
            bottomNi = oldNi;
        }
        PrimitiveNode np = (PrimitiveNode)bottomNi.getProto();
        Technology tech = np.getTechnology();
        Poly poly = tech.getShapeOfPort(bottomNi, (PrimitivePort)bottomPP);
        poly.transform(subrot);
        return poly;
    }

    private static AffineTransform makeOldRot(NodeInst ni) {
        Undo.Change change = ni.getChange();
        if (change == null || change.getType() != Undo.Type.NODEINSTMOD) {
            return ni.rotateOut();
        }
        double cX = change.getA1();
        double cY = change.getA2();
        double sX = change.getA3();
        double sY = change.getA4();
        int angle = change.getI1();
        NodeInst oldNi = NodeInst.lowLevelAllocate();
        oldNi.lowLevelPopulate(ni.getProto(), new Point2D.Double(cX, cY), sX, sY, angle, ni.getParent());
        return oldNi.rotateOut();
    }

    private static AffineTransform makeOldTrans(NodeInst ni) {
        double cX = ni.getAnchorCenterX();
        double cY = ni.getAnchorCenterY();
        Undo.Change change = ni.getChange();
        if (change != null && change.getType() == Undo.Type.NODEINSTMOD) {
            cX = change.getA1();
            cY = change.getA2();
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(cX, cY);
        return transform;
    }

    private void computeCell(Cell cell, boolean forcedLook) {
        Rectangle2D.Double oldCellBounds = new Rectangle2D.Double();
        ((Rectangle2D)oldCellBounds).setRect(cell.getRememberedBounds());
        Rectangle2D cellBounds = cell.getBounds();
        if (oldCellBounds.equals(cellBounds) && !forcedLook) {
            return;
        }
        changeClock += 4;
        double flx = cellBounds.getMinX();
        double fhx = cellBounds.getMaxX();
        double fly = cellBounds.getMinY();
        double fhy = cellBounds.getMaxY();
        Undo.Change change = cell.getChange();
        if (change != null && change.getType() == Undo.Type.CELLMOD) {
            flx = change.getA1();
            fhx = change.getA2();
            fly = change.getA3();
            fhy = change.getA4();
        }
        if (change == null) {
            Undo.modifyCell(cell, flx, fhx, fly, fhy);
        }
        boolean mixed = false;
        Cell oneParent = null;
        Iterator it = cell.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (oneParent != null && oneParent != ni.getParent()) {
                mixed = true;
            }
            oneParent = ni.getParent();
        }
        if (oneParent == null) {
            return;
        }
        if (!mixed && !forcedLook) {
            NodeInst ni;
            double dlx = cellBounds.getMinX() - flx;
            double dhx = cellBounds.getMaxX() - fhx;
            double dly = cellBounds.getMinY() - fly;
            double dhy = cellBounds.getMaxY() - fhy;
            Iterator it2 = cell.getInstancesOf();
            while (it2.hasNext()) {
                ni = (NodeInst)it2.next();
                double dSX = DBMath.round(cellBounds.getWidth() - ni.getXSize());
                double dSY = DBMath.round(cellBounds.getHeight() - ni.getYSize());
                if (ni.isMirroredAboutYAxis()) {
                    dSX = -dSX;
                }
                if (ni.isMirroredAboutXAxis()) {
                    dSY = -dSY;
                }
                if (!Layout.alterNodeInst(ni, 0.0, 0.0, dSX, dSY, 0, true)) continue;
                forcedLook = true;
            }
            it2 = cell.getInstancesOf();
            while (it2.hasNext()) {
                ni = (NodeInst)it2.next();
                if (!Layout.modNodeArcs(ni, 0, 0.0, 0.0, false, false)) continue;
                forcedLook = true;
            }
            this.computeCell(oneParent, forcedLook);
            return;
        }
        this.cellModFlag = new HashSet();
        this.cellNoModFlag = new HashSet();
        this.cellModFlag.add(cell);
        it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell c = (Cell)cIt.next();
                Iterator iIt = c.getInstancesOf();
                if (iIt.hasNext()) continue;
                this.lookDown(c);
            }
        }
        this.cellModFlag = null;
        this.cellNoModFlag = null;
    }

    private boolean lookDown(Cell start) {
        NodeInst ni;
        NodeInst ni2;
        Iterator it;
        HashSet<NodeInst> markNode = new HashSet<NodeInst>();
        HashSet<NodeInst> touchNode = new HashSet<NodeInst>();
        Iterator it2 = start.getNodes();
        while (it2.hasNext()) {
            NodeInst ni3 = (NodeInst)it2.next();
            if (!(ni3.getProto() instanceof Cell)) continue;
            markNode.add(ni3);
        }
        boolean foundone = true;
        while (foundone) {
            foundone = false;
            it = start.getNodes();
            while (it.hasNext()) {
                ni2 = (NodeInst)it.next();
                if (!markNode.contains(ni2)) continue;
                markNode.remove(ni2);
                Cell subCell = (Cell)ni2.getProto();
                if (this.cellModFlag.contains(subCell)) {
                    this.cellModFlag.add(start);
                }
                if (this.cellModFlag.contains(subCell) || this.cellNoModFlag.contains(subCell)) continue;
                if (this.lookDown(subCell)) {
                    this.cellModFlag.add(start);
                }
                foundone = true;
            }
        }
        if (!this.cellModFlag.contains(start)) {
            this.cellNoModFlag.add(start);
            return false;
        }
        it = start.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            ni2 = (NodeInst)it.next();
            NodeProto np = ni2.getProto();
            markNode.remove(ni2);
            touchNode.remove(ni2);
            if (!(np instanceof Cell) || !this.cellModFlag.contains(subCell = (Cell)np)) continue;
            markNode.add(ni2);
            touchNode.add(ni2);
        }
        boolean forcedLook = false;
        foundone = true;
        while (foundone) {
            foundone = false;
            Iterator it3 = start.getNodes();
            while (it3.hasNext()) {
                double fhy;
                double fly;
                double fhx;
                double flx;
                NodeInst ni4 = (NodeInst)it3.next();
                if (!markNode.contains(ni4)) continue;
                markNode.remove(ni4);
                Cell np = (Cell)ni4.getProto();
                Undo.Change change = np.getChange();
                if (change != null && change.getType() == Undo.Type.CELLMOD) {
                    flx = change.getA1();
                    fhx = change.getA2();
                    fly = change.getA3();
                    fhy = change.getA4();
                } else {
                    Rectangle2D.Double oldCellBounds = new Rectangle2D.Double();
                    flx = oldCellBounds.getMinX();
                    fhx = oldCellBounds.getMaxX();
                    fly = oldCellBounds.getMinY();
                    fhy = oldCellBounds.getMaxY();
                }
                Rectangle2D cellBounds = np.getBounds();
                double dSX = DBMath.round(cellBounds.getWidth() - ni4.getXSize());
                double dSY = DBMath.round(cellBounds.getHeight() - ni4.getYSize());
                if (ni4.isMirroredAboutYAxis()) {
                    dSX = -dSX;
                }
                if (ni4.isMirroredAboutXAxis()) {
                    dSY = -dSY;
                }
                if (Layout.alterNodeInst(ni4, 0.0, 0.0, dSX, dSY, 0, true)) {
                    forcedLook = true;
                }
                foundone = true;
            }
        }
        ArrayList<NodeInst> nodesThatChanged = new ArrayList<NodeInst>();
        Iterator it4 = start.getNodes();
        while (it4.hasNext()) {
            ni = (NodeInst)it4.next();
            if (!touchNode.contains(ni)) continue;
            nodesThatChanged.add(ni);
        }
        foundone = true;
        while (foundone) {
            foundone = false;
            it4 = nodesThatChanged.iterator();
            while (it4.hasNext()) {
                ni = (NodeInst)it4.next();
                if (!touchNode.contains(ni)) continue;
                touchNode.remove(ni);
                if (Layout.modNodeArcs(ni, 0, 0.0, 0.0, false, false)) {
                    forcedLook = true;
                }
                foundone = true;
            }
        }
        Rectangle2D.Double oldCellBounds = new Rectangle2D.Double();
        ((Rectangle2D)oldCellBounds).setRect(start.getRememberedBounds());
        Rectangle2D cellBounds = start.getBounds();
        if (oldCellBounds.equals(cellBounds) && !forcedLook) {
            this.cellModFlag.add(start);
            return false;
        }
        Undo.modifyCell(start, oldCellBounds.getMinX(), oldCellBounds.getMaxX(), oldCellBounds.getMinY(), oldCellBounds.getMaxY());
        return true;
    }
}

