/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StdCellParams {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private double nmosWellHeight;
    private double pmosWellHeight;
    private double gndY;
    private double vddY;
    private double gndWidth;
    private double vddWidth;
    private double trackPitch;
    private double trackWidth;
    private double m1TrackWidth;
    private double m2TrackWidth;
    private double metalSpace;
    private double pmosTrackOffset;
    private double nmosTrackOffset;
    private double enableGateStrengthRatio;
    private boolean separateWellTies;
    private double maxWellTieRadius;
    private String pmosWellTieName = "vnw";
    private String nmosWellTieName = "vsb";
    private double nmosWellTieY;
    private double pmosWellTieY;
    private double minGateWid;
    private double diffContWid;
    private double maxMosWidth;
    private double difWidHint;
    private double viaToMosPitch;
    private double mosToMosPitch;
    private double viaToViaPitch;
    private double gridResolution;
    private double difConIncr;
    private double drcRingSpace;
    private double wellConSelectHeight;
    private double wellConSelectOffset;
    private double sizeErr = 0.1;
    private static final double selectOverhangsDiffCont = 4.5;
    private static final double m1OverhangsDiffCont = 2.0;
    private static final double m1Space = 3.0;
    private ArrayList nmosTracks = new ArrayList();
    private ArrayList pmosTracks = new ArrayList();
    private Library schemLib = null;
    private Library layoutLib = null;
    private boolean doubleStrapGate = false;
    private boolean exhaustivePlace = true;
    private int nbPlacerPerms = 40000;
    private boolean simpleName = false;
    private String vddExportName = "vdd";
    private String gndExportName = "gnd";
    private PortCharacteristic vddExportRole = PortCharacteristic.PWR;
    private PortCharacteristic gndExportRole = PortCharacteristic.GND;
    public static final SelectSrcDrn EVEN = new SelectSrcDrn(){

        public boolean connectThisOne(int mosNdx, int srcDrnNdx) {
            return srcDrnNdx % 2 == 0;
        }
    };
    public static final SelectSrcDrn ODD = new SelectSrcDrn(){

        public boolean connectThisOne(int mosNdx, int srcDrnNdx) {
            return srcDrnNdx % 2 == 1;
        }
    };

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private void init(Library lib) {
        this.layoutLib = lib;
        this.init();
    }

    private void initMoCMOS(Technology tech) {
        this.nmosWellHeight = 70.0;
        this.pmosWellHeight = 70.0;
        this.gndY = -21.0;
        this.vddY = 21.0;
        this.gndWidth = 10.0;
        this.vddWidth = 10.0;
        this.trackPitch = 7.0;
        this.trackWidth = 4.0;
        this.m1TrackWidth = 4.0;
        this.m2TrackWidth = 4.0;
        this.metalSpace = 3.0;
        this.pmosTrackOffset = this.trackPitch / 2.0;
        this.nmosTrackOffset = -this.trackPitch / 2.0;
        this.enableGateStrengthRatio = 0.1;
        this.separateWellTies = false;
        this.maxWellTieRadius = 300.0;
        this.pmosWellTieName = "vnw";
        this.nmosWellTieName = "vsb";
        this.nmosWellTieY = 0.0;
        this.pmosWellTieY = 0.0;
        this.minGateWid = 3.0;
        this.diffContWid = 5.0;
        this.maxMosWidth = 45.0;
        this.difWidHint = 4.0;
        this.viaToMosPitch = 4.0;
        this.mosToMosPitch = 5.0;
        this.viaToViaPitch = 5.0;
        this.gridResolution = 0.5;
        this.difConIncr = 5.0;
        this.drcRingSpace = 3.0;
        this.wellConSelectHeight = 9.0;
        this.wellConSelectOffset = 0.0;
    }

    private void initTSMC90() {
        this.nmosWellHeight = 84.0;
        this.pmosWellHeight = 84.0;
        this.gndY = -24.5;
        this.vddY = 24.5;
        this.gndWidth = 9.0;
        this.vddWidth = 9.0;
        this.trackPitch = 7.0;
        this.trackWidth = 3.4;
        this.m1TrackWidth = 3.4;
        this.m2TrackWidth = 2.8;
        this.metalSpace = 2.4;
        this.pmosTrackOffset = 7.0;
        this.nmosTrackOffset = -77.0;
        this.enableGateStrengthRatio = 0.1;
        this.separateWellTies = false;
        this.maxWellTieRadius = 300.0;
        this.pmosWellTieName = "vnw";
        this.nmosWellTieName = "vsb";
        this.nmosWellTieY = 0.0;
        this.pmosWellTieY = 0.0;
        this.minGateWid = 5.2;
        this.diffContWid = 5.0;
        this.maxMosWidth = 45.0;
        this.difWidHint = 3.4;
        this.viaToMosPitch = 4.0;
        this.mosToMosPitch = 6.0;
        this.viaToViaPitch = 5.2;
        this.gridResolution = 0.1;
        this.difConIncr = 5.2;
        this.drcRingSpace = 0.0;
        this.wellConSelectHeight = 8.4;
        this.wellConSelectOffset = 0.0;
    }

    private void init() {
        TrackBlockages blockages = new TrackBlockages(this.metalSpace);
        blockages.addBlockage(11.0, 4.0);
        blockages.addBlockage(-11.0, 4.0);
        blockages.addBlockage(this.vddY, this.vddWidth);
        blockages.addBlockage(this.gndY, this.gndWidth);
        this.generateTracks(blockages);
        this.nmosWellTieY = this.gndY;
        this.pmosWellTieY = this.vddY;
        if (this.separateWellTies) {
            this.nmosWellTieY = this.getTrackY(-(this.nbNmosTracks() - 1));
            blockages.addBlockage(this.nmosWellTieY, this.trackWidth);
            this.pmosWellTieY = this.getTrackY(this.nbPmosTracks() - 1);
            blockages.addBlockage(this.pmosWellTieY, this.trackWidth);
            this.generateTracks(blockages);
        }
    }

    private void generateTracks(TrackBlockages blockages) {
        double y;
        this.nmosTracks.clear();
        this.pmosTracks.clear();
        for (y = this.pmosTrackOffset; y < this.pmosWellHeight; y += this.trackPitch) {
            if (blockages.isBlocked(y, this.trackWidth)) continue;
            this.pmosTracks.add(new Double(y));
        }
        for (y = this.nmosTrackOffset; y > -this.nmosWellHeight; y -= this.trackPitch) {
            if (blockages.isBlocked(y, this.trackWidth)) continue;
            this.nmosTracks.add(new Double(y));
        }
    }

    private double quantizeMantissa(double mantissa) {
        double loApprox;
        double szRatio = (1.0 + this.sizeErr) / (1.0 - this.sizeErr);
        double logBaseSzRatio = Math.log(mantissa) / Math.log(szRatio);
        double floorN = Math.floor(logBaseSzRatio);
        double ceilN = Math.ceil(logBaseSzRatio);
        double hiApprox = Math.pow(szRatio, ceilN);
        return hiApprox - mantissa < mantissa - (loApprox = Math.pow(szRatio, floorN)) ? hiApprox : loApprox;
    }

    private int calcNbGroups(double maxAvailWid, double totWid, int groupSz) {
        int nbGroups = (int)Math.ceil(totWid / maxAvailWid / (double)groupSz);
        if (groupSz % 2 == 0) {
            return nbGroups;
        }
        if (nbGroups % 2 == 0) {
            return nbGroups;
        }
        if (totWid < maxAvailWid && groupSz == 1) {
            return 1;
        }
        int roundupGroups = nbGroups + 1;
        double wid = totWid / (double)groupSz / (double)roundupGroups;
        if (wid >= this.diffContWid) {
            nbGroups = roundupGroups;
        }
        return nbGroups;
    }

    private void fillDiffAndSelectNotch(PortInst prevPort, PortInst thisPort, FoldedMos mosLeft, FoldedMos mosRight, boolean fillDiffNotch) {
        double mosRightY;
        double diffWid = mosLeft.getPhysWidth();
        Cell f = mosLeft.getSrcDrn(0).getNodeInst().getParent();
        ArcProto diffArc = mosLeft instanceof FoldedPmos ? Tech.pdiff : Tech.ndiff;
        PrimitiveNode diffNode = mosLeft instanceof FoldedPmos ? Tech.pdNode : Tech.ndNode;
        double prevX = LayoutLib.roundCenterX(prevPort);
        double thisX = LayoutLib.roundCenterX(thisPort);
        double dist = thisX - prevX;
        if (dist == 0.0 || dist >= 9.0 + Tech.getSelectSpacingRule()) {
            return;
        }
        double mosY = mosLeft.getMosCenterY();
        if (!DBMath.areEquals(mosY, mosRightY = mosRight.getMosCenterY())) {
            double activePlusSelect = diffWid / 2.0 + Tech.getSelectSurroundDiffInTrans();
            double topY = -activePlusSelect;
            double bottomY = activePlusSelect;
            double sign = 1.0;
            if (mosY > mosRightY) {
                topY += mosY;
                bottomY += mosRightY;
                sign = -1.0;
            } else {
                topY += mosRightY;
                bottomY += mosY;
            }
            double diff = DBMath.round(topY - bottomY);
            if (DBMath.isGreaterThan(diff, 0.0)) {
                double minRe = f.getTechnology().getResolution() * 2.0;
                if (DBMath.hasRemainder(diff, minRe)) {
                    diff += f.getTechnology().getResolution();
                    diff = (double)((int)Math.ceil(diff / minRe)) * minRe;
                }
                diffWid += diff;
                mosY += DBMath.round(sign * diff / 2.0);
            }
        }
        double a = mosLeft.getDiffContWidth();
        double b = mosLeft.getGateWidth();
        Rectangle2D diffNodeBnd = LayoutLib.calculateNodeInst(diffNode, thisX - dist / 2.0, mosY, dist, diffWid);
        if (fillDiffNotch) {
            NodeInst dFill = LayoutLib.newNodeInst(diffNode, diffNodeBnd, 0.0, f);
            double contY = LayoutLib.roundCenterY(thisPort);
            LayoutLib.newArcInst(diffArc, Double.POSITIVE_INFINITY, thisPort, thisX, contY, dFill.getOnlyPortInst(), LayoutLib.roundCenterX(dFill.getOnlyPortInst()), contY);
            if (dist < 7.0) {
                double m1Wid = mosLeft.getDiffContWidth() - 1.0;
                NodeInst mFill = LayoutLib.newNodeInst(Tech.m1Node, thisX - dist / 2.0, contY, dist, m1Wid, 0.0, f);
                LayoutLib.newArcInst(Tech.m1, Double.POSITIVE_INFINITY, thisPort, mFill.getOnlyPortInst());
            }
        }
        double roundedPosY = DBMath.round(diffNodeBnd.getY() - diffNodeBnd.getHeight() / 2.0);
        Rectangle2D.Double selectRec = new Rectangle2D.Double(diffNodeBnd.getX() - dist / 2.0, roundedPosY, diffNodeBnd.getWidth(), diffNodeBnd.getHeight());
        double selectDiff = a - b;
        this.addSelAroundDiff(diffNode, selectRec, selectDiff, f);
    }

    private static FoldedMos getRightMos(Object a) {
        if (a instanceof FoldedMos) {
            return (FoldedMos)a;
        }
        StdCellParams.error(!(a instanceof FoldedMos[]), "not FoldedMos or FoldedMos[]");
        FoldedMos[] moss = (FoldedMos[])a;
        return moss[moss.length - 1];
    }

    private static String trkMsg(Object key, Cell schem) {
        return "Track assignment for export: " + key + " in Cell: " + schem.getName() + ".\n    ";
    }

    public void setDoubleStrapGate(boolean val) {
        this.doubleStrapGate = val;
    }

    public void setExhaustivePlace(boolean val) {
        this.exhaustivePlace = val;
    }

    public void setNbPlacerPerms(int i) {
        this.nbPlacerPerms = i;
    }

    public void setNmosWellHeight(double h) {
        this.nmosWellHeight = h;
        this.init();
    }

    public void setPmosWellHeight(double h) {
        this.pmosWellHeight = h;
        this.init();
    }

    public void setMaxMosWidth(double wid) {
        this.maxMosWidth = wid;
    }

    public void setPmosTrackOffset(double offset) {
        this.pmosTrackOffset = offset;
        this.init();
    }

    public void setNmosTrackOffset(double offset) {
        this.nmosTrackOffset = offset;
        this.init();
    }

    public void setTrackWidth(double width) {
        this.trackWidth = width;
        this.init();
    }

    public void setVddWidth(double width) {
        this.vddWidth = width;
        this.init();
    }

    public void setGndWidth(double width) {
        this.gndWidth = width;
        this.init();
    }

    public void setM1TrackWidth(double width) {
        this.m1TrackWidth = width;
    }

    public double getM1TrackWidth() {
        return this.m1TrackWidth;
    }

    public void setM2TrackWidth(double width) {
        this.m2TrackWidth = width;
    }

    public double getM2TrackWidth() {
        return this.m2TrackWidth;
    }

    public double getDifWidHint() {
        return this.difWidHint;
    }

    public double getDifConIncr() {
        return this.difConIncr;
    }

    public double getDRCRingSpacing() {
        return this.drcRingSpace;
    }

    public double getM1TrackAboveVDD() {
        double trackX = Tech.isTSMC90() ? this.getVddY() + this.getVddWidth() / 2.0 + 2.4 + this.getM1TrackWidth() / 2.0 + 2.8 : this.getVddY() + this.getVddWidth() / 2.0 + 3.0 + 2.0;
        return trackX;
    }

    public double getM1TrackBelowGnd() {
        double gndBot = this.getGndY() - this.getGndWidth() / 2.0;
        double trackX = Tech.isTSMC90() ? gndBot - 2.4 - this.getM1TrackWidth() / 2.0 - 2.8 : gndBot - this.getM1TrackWidth() - 2.0;
        return trackX;
    }

    public double getMinDifContWid() {
        SizeOffset so = Tech.ndm1.getProtoSizeOffset();
        return Tech.ndm1.getMinHeight() - so.getHighYOffset() - so.getLowYOffset();
    }

    public double getWellOverhangDiff() {
        if (Tech.isTSMC90()) {
            return 8.0;
        }
        return 6.0;
    }

    public void setViaToMosPitch(double p) {
        this.viaToMosPitch = p;
    }

    public double getViaToMosPitch() {
        return this.viaToMosPitch;
    }

    public void setMosToMosPitch(double p) {
        this.mosToMosPitch = p;
    }

    public double getMosToMosPitch() {
        return this.mosToMosPitch;
    }

    public double getViaToViaPitch() {
        return this.viaToViaPitch;
    }

    public double getGridResolution() {
        return this.gridResolution;
    }

    public double getFoldPitch(int nbSeries) {
        if (Tech.isTSMC90()) {
            return 8 + (nbSeries - 1) * 5;
        }
        return 8 + (nbSeries - 1) * 5;
    }

    public void enableNCC(String libName) {
        this.schemLib = Library.findLibrary(libName);
        StdCellParams.error(this.schemLib == null, "Please open the PurpleFour Library");
    }

    public void setVddExportName(String vddNm) {
        this.vddExportName = vddNm;
    }

    public String getVddExportName() {
        return this.vddExportName;
    }

    public void setGndExportName(String gndNm) {
        this.gndExportName = gndNm;
    }

    public String getGndExportName() {
        return this.gndExportName;
    }

    public void setVddExportRole(PortCharacteristic vddRole) {
        this.vddExportRole = vddRole;
    }

    public PortCharacteristic getVddExportRole() {
        return this.vddExportRole;
    }

    public void setGndExportRole(PortCharacteristic gndRole) {
        this.gndExportRole = gndRole;
    }

    public PortCharacteristic getGndExportRole() {
        return this.gndExportRole;
    }

    public StdCellParams(Library lib, String tech) {
        if (tech == "tsmc90") {
            this.initTSMC90();
        } else if (tech == "mocmos") {
            this.initMoCMOS(MoCMOS.tech);
        } else {
            StdCellParams.error(true, "Standard Cell Params does not understand technology " + tech);
        }
        this.init(lib);
    }

    public double getNmosWellHeight() {
        return this.nmosWellHeight;
    }

    public double getPmosWellHeight() {
        return this.pmosWellHeight;
    }

    public boolean getDoubleStrapGate() {
        return this.doubleStrapGate;
    }

    public boolean getExhaustivePlace() {
        return this.exhaustivePlace;
    }

    public int getNbPlacerPerms() {
        return this.nbPlacerPerms;
    }

    public double getCellBot() {
        return -this.nmosWellHeight;
    }

    public double getCellTop() {
        return this.pmosWellHeight;
    }

    public double getGndY() {
        return this.gndY;
    }

    public void setGndY(double y) {
        this.gndY = y;
        this.init();
    }

    public double getVddY() {
        return this.vddY;
    }

    public void setVddY(double y) {
        this.vddY = y;
        this.init();
    }

    public double getGndWidth() {
        return this.gndWidth;
    }

    public double getVddWidth() {
        return this.vddWidth;
    }

    public double getTrackY(int i) {
        StdCellParams.error(i == 0, "StdCellParams.getTrackY: 0 is an illegal track index");
        return i > 0 ? ((Double)this.pmosTracks.get(i - 1)).doubleValue() : ((Double)this.nmosTracks.get(-i - 1)).doubleValue();
    }

    public double getPhysTrackY(int i) {
        StdCellParams.error(i == 0, "StdCellParams.getPhysTrackY: 0 is illegal track index");
        return i > 0 ? this.trackPitch / 2.0 + (double)(i - 1) * this.trackPitch : -this.trackPitch / 2.0 + (double)(i + 1) * this.trackPitch;
    }

    public double getTrackPitch() {
        return this.trackPitch;
    }

    public int nbNmosTracks() {
        return this.nmosTracks.size();
    }

    public int nbPmosTracks() {
        return this.pmosTracks.size();
    }

    public boolean getSeparateWellTies() {
        return this.separateWellTies;
    }

    public void setSeparateWellTies(boolean b) {
        this.separateWellTies = b;
        this.init();
    }

    public double getNmosWellTieY() {
        return this.nmosWellTieY;
    }

    public double getPmosWellTieY() {
        return this.pmosWellTieY;
    }

    public double getNmosWellTieWidth() {
        return this.separateWellTies ? this.trackWidth : this.gndWidth;
    }

    public double getPmosWellTieWidth() {
        return this.separateWellTies ? this.trackWidth : this.vddWidth;
    }

    public String getNmosWellTieName() {
        return this.separateWellTies ? "vsb" : this.gndExportName;
    }

    public String getPmosWellTieName() {
        return this.separateWellTies ? "vnw" : this.vddExportName;
    }

    public PortCharacteristic getNmosWellTieRole() {
        return this.separateWellTies ? PortCharacteristic.IN : this.gndExportRole;
    }

    public PortCharacteristic getPmosWellTieRole() {
        return this.separateWellTies ? PortCharacteristic.IN : this.vddExportRole;
    }

    public void setSimpleName(boolean b) {
        this.simpleName = b;
    }

    public boolean getSimpleName() {
        return this.simpleName;
    }

    public double getWellTiePitch() {
        double tieToPwellTop = 0.0 - this.getNmosWellTieY();
        double tieToPwellBot = this.getNmosWellTieY() - -this.nmosWellHeight;
        double tieToPwellTopBot = Math.max(tieToPwellTop, tieToPwellBot);
        double nmosWellTieDistance = Math.sqrt(Math.pow(this.maxWellTieRadius, 2.0) - Math.pow(tieToPwellTopBot, 2.0));
        double tieToNwellTop = this.pmosWellHeight - this.getPmosWellTieY();
        double tieToNwellBot = this.getPmosWellTieY() - 0.0;
        double tieToNwellTopBot = Math.max(tieToNwellTop, tieToNwellBot);
        double pmosWellTieDistance = Math.sqrt(Math.pow(this.maxWellTieRadius, 2.0) - Math.pow(tieToNwellTopBot, 2.0));
        double tiePitch = 2.0 * Math.min(nmosWellTieDistance, pmosWellTieDistance);
        return (int)tiePitch / 2;
    }

    public double getEnableGateStrengthRatio() {
        return this.enableGateStrengthRatio;
    }

    public double roundGateWidth(double w) {
        if (Tech.isTSMC90()) {
            double size = Math.rint(w * 5.0) / 5.0;
            if (size < this.minGateWid) {
                System.out.println("Warning: gate width of " + size + " too small, using " + this.minGateWid);
                return this.minGateWid;
            }
            return size;
        }
        return Math.rint(w * 2.0) / 2.0;
    }

    public double roundSize(double s) {
        if (s == 0.0) {
            return s;
        }
        double q = this.quantizeSize(s);
        double e = (s - q) / s;
        double qe = Math.rint(e * 100000.0) / 100000.0;
        return q;
    }

    public double roundToGrid(double s) {
        return (double)((int)(s / this.gridResolution)) * this.gridResolution;
    }

    public void setSizeQuantizationError(double err) {
        StdCellParams.error(err >= 1.0, "quantization error must be less than 1.0");
        StdCellParams.error(err < 0.0, "quantization error must be positive");
        this.sizeErr = err;
    }

    public double quantizeSize(double desiredSize) {
        double exponent = Math.floor(Math.log(desiredSize) / Math.log(10.0));
        double mantissa = desiredSize / Math.pow(10.0, exponent);
        double quantMant = this.sizeErr != 0.0 ? this.quantizeMantissa(mantissa) : mantissa;
        double roundMant = Math.rint(quantMant * 100.0) / 100.0;
        return Math.pow(10.0, exponent) * roundMant;
    }

    public String parameterizedName(String nm) {
        if (!this.vddExportName.equals("vdd")) {
            nm = nm + "_pwr";
        }
        if (this.simpleName) {
            return nm;
        }
        return nm + "_NH" + this.nmosWellHeight + "_PH" + this.pmosWellHeight + "_MW" + this.maxMosWidth + "_VY" + this.vddY + "_GY" + this.gndY;
    }

    public String sizedName(String nm, double sz) {
        String num = "" + (sz + 1000.0);
        num = num.substring(1);
        return this.parameterizedName(nm) + "_X" + num + "{lay}";
    }

    private NodeInst addNmosWell(double loX, double hiX, double y, Cell cell) {
        NodeInst well = LayoutLib.newNodeInst(Tech.pwell, (loX + hiX) / 2.0, y - this.nmosWellHeight / 2.0, hiX - loX, this.nmosWellHeight, 0.0, cell);
        well.setHardSelect();
        return well;
    }

    private NodeInst addPmosWell(double loX, double hiX, double y, Cell cell) {
        NodeInst well = LayoutLib.newNodeInst(Tech.nwell, (loX + hiX) / 2.0, y + this.pmosWellHeight / 2.0, hiX - loX, this.pmosWellHeight, 0.0, cell);
        well.setHardSelect();
        return well;
    }

    public NodeInst addNmosWell(double loX, double hiX, Cell cell) {
        return this.addNmosWell(loX, hiX, 0.0, cell);
    }

    public NodeInst addPmosWell(double loX, double hiX, Cell cell) {
        return this.addPmosWell(loX, hiX, 0.0, cell);
    }

    public void addWellsForRow(ArrayList row, double minX, double maxX, Cell cell) {
        NodeInst last;
        double rowMaxX;
        NodeInst first = (NodeInst)row.get(row.size() - 1);
        double rowMinX = first.getBounds().getMinX();
        if (rowMinX < minX) {
            this.addPmosWell(minX, rowMinX, first.getAnchorCenterY(), cell);
            this.addNmosWell(minX, rowMinX, first.getAnchorCenterY(), cell);
        }
        if ((rowMaxX = (last = (NodeInst)row.get(row.size() - 1)).getBounds().getMaxX()) < maxX) {
            this.addPmosWell(rowMaxX, maxX, first.getAnchorCenterY(), cell);
            this.addNmosWell(rowMaxX, maxX, first.getAnchorCenterY(), cell);
        }
    }

    public void addPstackEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, this.pmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public void addNstackEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, -this.nmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public void addEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, -this.nmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, this.pmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public double checkMinStrength(double specified, double minAllowable, String gateNm) {
        if (specified < minAllowable) {
            System.out.println("Can't make: " + gateNm + " this small: X=" + specified + ", Using X=" + minAllowable + " instead");
        }
        return Math.max(specified, minAllowable);
    }

    public FoldsAndWidth calcFoldsAndWidth(double spaceAvailWid, double totWid, int groupSz) {
        if (totWid == 0.0) {
            return null;
        }
        double maxAvailWid = Math.min(spaceAvailWid, this.maxMosWidth);
        int nbGroups = this.calcNbGroups(maxAvailWid, totWid, groupSz);
        double gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        if (gateWid > maxAvailWid) {
            nbGroups = this.calcNbGroups(maxAvailWid - 0.5, totWid, groupSz);
            gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        }
        double physWid = Math.max(this.diffContWid, gateWid);
        if (gateWid < this.minGateWid) {
            return null;
        }
        return new FoldsAndWidth(nbGroups * groupSz, gateWid, physWid);
    }

    public void fillDiffAndSelectNotches(FoldedMos[] moss, boolean fillDiffNotch) {
        StdCellParams.error(moss.length == 0, "fillDiffAndSelectNotches: no transistors?");
        FoldedMos mos = moss[0];
        for (int i = 1; i < moss.length; ++i) {
            PortInst thisPort = moss[i].getSrcDrn(0);
            PortInst prevPort = moss[i - 1].getSrcDrn(moss[i - 1].nbSrcDrns() - 1);
            this.fillDiffAndSelectNotch(prevPort, thisPort, mos, moss[i], fillDiffNotch);
        }
    }

    public void wireVddGnd(FoldedMos[] moss, SelectSrcDrn select, Cell p) {
        String exportNm;
        FoldedMos mos = moss[0];
        PortInst leftDiff = mos.getSrcDrn(0);
        Cell f = leftDiff.getNodeInst().getParent();
        double busWid = mos instanceof FoldedPmos ? this.vddWidth : this.gndWidth;
        double busY = mos instanceof FoldedPmos ? this.vddY : this.gndY;
        TrackRouterH net = new TrackRouterH(Tech.m2, busWid, busY, p);
        String string = exportNm = mos instanceof FoldedPmos ? this.vddExportName : this.gndExportName;
        if (f.findPortProto(exportNm) == null) {
            double x = leftDiff.getBounds().getCenterX();
            NodeInst pinProt = LayoutLib.newNodeInst(Tech.m2pin, x, busY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, f);
            PortInst pin = pinProt.getOnlyPortInst();
            Export e = Export.newInstance(f, pin, exportNm);
            PortCharacteristic role = mos instanceof FoldedPmos ? this.vddExportRole : this.gndExportRole;
            e.setCharacteristic(role);
            LayoutLib.newArcInst(Tech.m2, busWid, pin, pin);
            net.connect(pin);
        }
        double diffY = LayoutLib.roundCenterY(leftDiff);
        double notchLoY = Math.min(busY - busWid / 2.0, diffY);
        double notchHiY = Math.max(busY + busWid / 2.0, diffY);
        PortInst lastDiff = null;
        for (int i = 0; i < moss.length; ++i) {
            for (int j = 0; j < moss[i].nbSrcDrns(); ++j) {
                if (!select.connectThisOne(i, j)) continue;
                PortInst thisDiff = moss[i].getSrcDrn(j);
                net.connect(thisDiff);
                if (lastDiff != null) {
                    double rightX;
                    double leftX = LayoutLib.roundCenterX(lastDiff);
                    StdCellParams.error(leftX > (rightX = LayoutLib.roundCenterX(thisDiff)), "wireVddGnd: trans not sorted left to right");
                    double deltaX = rightX - leftX;
                    if (deltaX > 0.0 && deltaX < 7.0) {
                        double dY = Math.ceil(notchHiY - notchLoY);
                        NodeInst patchNode = LayoutLib.newNodeInst(Tech.m1Node, (leftX + rightX) / 2.0, notchLoY + dY / 2.0, deltaX, dY, 0.0, f);
                        PortInst patch = patchNode.getOnlyPortInst();
                        LayoutLib.newArcInst(Tech.m1, Double.POSITIVE_INFINITY, patch, thisDiff);
                    }
                }
                lastDiff = thisDiff;
            }
        }
    }

    public void wireVddGnd(FoldedMos mos, SelectSrcDrn select, Cell p) {
        this.wireVddGnd(new FoldedMos[]{mos}, select, p);
    }

    public boolean nccEnabled() {
        return this.schemLib != null;
    }

    public void doNCC(Cell layout, String schemNm) {
        if (this.schemLib == null) {
            return;
        }
        Cell schem = this.schemLib.findNodeProto(schemNm);
        StdCellParams.error(schem == null, "can't find schematic: " + schemNm);
        NccOptions options = new NccOptions();
        options.howMuchStatus = 0;
        NccResult result = Ncc.compare(schem, null, layout, null, options);
        StdCellParams.error(!result.match(), "layout not topologically identical to schematic!");
    }

    public static double getSize(NodeInst iconInst, VarContext context) {
        Variable var = iconInst.getVar("ATTR_X");
        if (var == null) {
            var = iconInst.getVar("ATTR_S");
        }
        if (var == null) {
            var = iconInst.getVar("ATTR_SP");
        }
        if (var == null) {
            var = iconInst.getVar("ATTR_SN");
        }
        if (var == null) {
            System.out.println("can't find size, using 40");
            return 40.0;
        }
        Object val = context.evalVar(var);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        StdCellParams.error(true, "an Icon's size isn't a numeric value");
        return 0.0;
    }

    public Cell findPart(String partNm, double sz) {
        return this.findPart(this.sizedName(partNm, sz));
    }

    public Cell findPart(String partNm) {
        return this.layoutLib.findNodeProto(partNm);
    }

    public Cell newPart(String partNm, double sz) {
        return this.newPart(this.sizedName(partNm, sz));
    }

    public Cell newPart(String partNm) {
        StdCellParams.error(this.findPart(partNm) != null, "Cell already exists: " + partNm);
        Cell p = Cell.newInstance(this.layoutLib, partNm);
        return p;
    }

    public static double getRightDiffX(FoldedMos m) {
        return LayoutLib.roundCenterX(m.getSrcDrn(m.nbSrcDrns() - 1));
    }

    public static double getRightDiffX(FoldedMos[] moss) {
        return StdCellParams.getRightDiffX(StdCellParams.getRightMos(moss));
    }

    public static double getRightDiffX(Object a, Object b) {
        FoldedMos ra = StdCellParams.getRightMos(a);
        FoldedMos rb = StdCellParams.getRightMos(b);
        return Math.max(StdCellParams.getRightDiffX(ra), StdCellParams.getRightDiffX(rb));
    }

    public static void addEssentialBoundsFromChildren(Cell cell) {
        double loY = Double.MAX_VALUE;
        double loX = Double.MAX_VALUE;
        double hiY = Double.MIN_VALUE;
        double hiX = Double.MIN_VALUE;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Rectangle2D b = ((NodeInst)it.next()).getBounds();
            loX = Math.min(loX, b.getMinX());
            loY = Math.min(loY, b.getMinY());
            hiX = Math.max(hiX, b.getMaxX());
            hiY = Math.max(hiY, b.getMaxY());
        }
        LayoutLib.newNodeInst(Tech.essentialBounds, loX, loY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(Tech.essentialBounds, hiX, hiY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public HashMap getSchemTrackAssign(Cell schem) {
        HashMap<String, Variable> schAsgn = new HashMap<String, Variable>();
        Iterator it = schem.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            Variable val = e.getVar("ATTR_track");
            String key = e.getName();
            if (val == null) continue;
            schAsgn.put(key, val);
        }
        this.validateTrackAssign(schAsgn, schem);
        return schAsgn;
    }

    public void validateTrackAssign(HashMap asgn, Cell s) {
        HashMap trkToExp = new HashMap();
        Iterator it = asgn.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            Object v = asgn.get(k);
            StdCellParams.error(!(k instanceof String), "Track assignment key not String: " + k);
            StdCellParams.error(!(v instanceof Integer), StdCellParams.trkMsg(k, s) + "Value not Integer: " + v);
            int track = (Integer)v;
            StdCellParams.error(track == 0, StdCellParams.trkMsg(k, s) + "Track must be <=-1 or >=1, 0 is illegal");
            Object oldK = trkToExp.get(v);
            if (oldK != null) {
                System.out.println(StdCellParams.trkMsg(k, s) + "Track: " + v + " is shared by export: " + oldK);
            }
            trkToExp.put(v, k);
        }
    }

    public void addSelAroundDiff(NodeProto prot, Rectangle2D diffNodeBnd, double activeGateDiff, Cell cell) {
        StdCellParams.error(prot != Tech.pdNode && prot != Tech.ndNode, "addSelectAroundDiff: only works with MOSIS CMOS diff nodes");
        PrimitiveNode sel = prot == Tech.pdNode ? Tech.pselNode : Tech.nselNode;
        double w = diffNodeBnd.getWidth();
        double h = diffNodeBnd.getHeight();
        h += Tech.selectSurroundDiffAlongGateInTrans() * 2.0;
        if (activeGateDiff > 0.0) {
            h -= activeGateDiff;
        }
        NodeInst node = LayoutLib.newNodeInst(sel, diffNodeBnd.getCenterX(), diffNodeBnd.getCenterY(), w, h, 0.0, cell);
        System.out.println(node.getParent().getName() + " Node " + node + " " + h + " cent " + diffNodeBnd.getCenterY());
    }

    public static SelectFill fillSelect(Cell cell, boolean pSelect, boolean nSelect, boolean includePoly) {
        double selSurroundPoly = Tech.getSelectSurroundOverPoly();
        if (selSurroundPoly < 0.0) {
            return null;
        }
        Rectangle2D pselectBounds = LayoutLib.getBounds(cell, Layer.Function.IMPLANTP);
        Rectangle2D nselectBounds = LayoutLib.getBounds(cell, Layer.Function.IMPLANTN);
        if (includePoly) {
            Rectangle2D polyBounds = LayoutLib.getBounds(cell, Layer.Function.POLY1);
            polyBounds.setRect(polyBounds.getX() - selSurroundPoly, polyBounds.getY() - selSurroundPoly, polyBounds.getWidth() + 2.0 * selSurroundPoly, polyBounds.getHeight() + 2.0 * selSurroundPoly);
            pselectBounds = pselectBounds.createUnion(polyBounds);
            nselectBounds = nselectBounds.createUnion(polyBounds);
        }
        pselectBounds.setRect(pselectBounds.getMinX(), 0.0, pselectBounds.getMaxX() - pselectBounds.getMinX(), pselectBounds.getMaxY());
        nselectBounds.setRect(nselectBounds.getMinX(), nselectBounds.getMinY(), nselectBounds.getMaxX() - nselectBounds.getMinX(), -nselectBounds.getMinY());
        pselectBounds = LayoutLib.roundBounds(pselectBounds);
        nselectBounds = LayoutLib.roundBounds(nselectBounds);
        NodeInst pni = null;
        NodeInst nni = null;
        if (pSelect) {
            pni = LayoutLib.newNodeInst(Tech.pselNode, pselectBounds.getCenterX(), pselectBounds.getCenterY(), pselectBounds.getWidth(), pselectBounds.getHeight(), 0.0, cell);
            pni.setHardSelect();
        }
        if (nSelect) {
            nni = LayoutLib.newNodeInst(Tech.nselNode, nselectBounds.getCenterX(), nselectBounds.getCenterY(), nselectBounds.getWidth(), nselectBounds.getHeight(), 0.0, cell);
            nni.setHardSelect();
        }
        return new SelectFill(nni, pni);
    }

    public boolean addWellCon(SelectFill selFill, PortInst gndPort, PortInst vddPort, Cell cell) {
        double nspace;
        double nselMaxY = Math.abs(selFill.nselNode.getYSize());
        double pselMaxY = Math.abs(selFill.pselNode.getYSize());
        boolean added = false;
        double pspace = this.getNmosWellHeight() - nselMaxY;
        double m1m1_sp = 2.4;
        double psel_sp = 4.8;
        double nsel_sp = 4.8;
        Technology tech = cell.getTechnology();
        if (pspace > this.wellConSelectHeight + m1m1_sp + 2.0 * this.gridResolution) {
            Poly[] polys;
            double pwellX = this.roundToGrid(gndPort.getBounds().getCenterX());
            double pwellY = -this.roundToGrid(nselMaxY + 0.5 * this.wellConSelectHeight + this.wellConSelectOffset) - this.gridResolution;
            SizeOffset so = Tech.pwellNode.getProtoSizeOffset();
            NodeInst ni = LayoutLib.newNodeInst(Tech.pwellNode, pwellX, pwellY, Tech.pwellNode.getDefWidth() - so.getHighXOffset() - so.getLowXOffset(), Tech.pwellNode.getDefHeight() - so.getHighYOffset() - so.getLowYOffset(), 0.0, cell);
            LayoutLib.newArcInst(Tech.m1, this.getM1TrackWidth(), ni.getOnlyPortInst(), gndPort);
            added = true;
            double distFromEdge = this.getNmosWellHeight() - (Math.abs(pwellY) + 0.5 * this.wellConSelectHeight);
            if (distFromEdge < psel_sp && (polys = tech.getShapeOfNode(ni)) != null) {
                Layer.Function function = Layer.Function.IMPLANTP;
                Rectangle2D bounds = null;
                for (int i = 0; i < polys.length; ++i) {
                    if (polys[i] == null || polys[i].getLayer().getFunction() != function) continue;
                    bounds = polys[i].getBox();
                }
                if (bounds != null) {
                    double fillBot = (int)(Math.abs(pwellY) - 0.5 * this.wellConSelectHeight) + 1;
                    double fillH = this.getNmosWellHeight() - fillBot;
                    ni = LayoutLib.newNodeInst(Tech.pselNode, pwellX, -1.0 * this.roundToGrid(fillH / 2.0 + fillBot), bounds.getWidth(), this.roundToGrid(fillH), 0.0, cell);
                    ni.setHardSelect();
                }
            }
        }
        if ((nspace = this.getPmosWellHeight() - pselMaxY) > this.wellConSelectHeight + m1m1_sp + 2.0 * this.gridResolution) {
            Poly[] polys;
            double nwellX = this.roundToGrid(vddPort.getBounds().getCenterX());
            double nwellY = this.roundToGrid(pselMaxY + 0.5 * this.wellConSelectHeight + this.wellConSelectOffset) + this.gridResolution;
            SizeOffset so = Tech.nwellNode.getProtoSizeOffset();
            NodeInst ni = LayoutLib.newNodeInst(Tech.nwellNode, nwellX, nwellY, Tech.nwellNode.getDefWidth() - so.getHighXOffset() - so.getLowXOffset(), Tech.nwellNode.getDefHeight() - so.getHighYOffset() - so.getLowYOffset(), 0.0, cell);
            LayoutLib.newArcInst(Tech.m1, this.getM1TrackWidth(), ni.getOnlyPortInst(), vddPort);
            added = true;
            double distFromEdge = this.getPmosWellHeight() - (Math.abs(nwellY) + 0.5 * this.wellConSelectHeight);
            if (distFromEdge < nsel_sp && (polys = tech.getShapeOfNode(ni)) != null) {
                Layer.Function function = Layer.Function.IMPLANTN;
                Rectangle2D bounds = null;
                for (int i = 0; i < polys.length; ++i) {
                    if (polys[i] == null || polys[i].getLayer().getFunction() != function) continue;
                    bounds = polys[i].getBox();
                }
                if (bounds != null) {
                    double fillBot = (int)(Math.abs(nwellY) - 0.5 * this.wellConSelectHeight) + 1;
                    double fillH = this.getPmosWellHeight() - fillBot;
                    ni = LayoutLib.newNodeInst(Tech.nselNode, nwellX, this.roundToGrid(fillH / 2.0 + fillBot), bounds.getWidth(), this.roundToGrid(fillH), 0.0, cell);
                    ni.setHardSelect();
                }
            }
        }
        return added;
    }

    public static class SelectFill {
        public final NodeInst nselNode;
        public final NodeInst pselNode;

        public SelectFill(NodeInst nselNode, NodeInst pselNode) {
            this.nselNode = nselNode;
            this.pselNode = pselNode;
        }
    }

    public static interface SelectSrcDrn {
        public boolean connectThisOne(int var1, int var2);
    }

    private static class TrackBlockages {
        private ArrayList blockages = new ArrayList();
        private double space;

        TrackBlockages(double space) {
            this.space = space;
        }

        void addBlockage(double center, double width) {
            this.blockages.add(new Blockage(center, width));
        }

        boolean isBlocked(double center, double width) {
            double top = center + width / 2.0 + this.space;
            double bot = center + width / 2.0 - this.space;
            for (int i = 0; i < this.blockages.size(); ++i) {
                Blockage b = (Blockage)this.blockages.get(i);
                if (!(b.bot < top) || !(b.top > bot)) continue;
                return true;
            }
            return false;
        }

        private static class Blockage {
            double bot;
            double top;

            Blockage(double center, double width) {
                this.bot = center - width / 2.0;
                this.top = center + width / 2.0;
            }
        }
    }
}

