/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.cvspm.CVSLibrary;
import com.sun.electric.tool.cvspm.Edit;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ModalCommandDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVS
extends Listener {
    private static CVS tool = new CVS();
    private static Pref cacheCVSEnabled = Pref.makeBooleanPref("CVS Enabled", User.getUserTool().prefs, false);
    private static Pref cacheCVSProgram = Pref.makeStringPref("CVS Program", User.getUserTool().prefs, "cvs");
    private static Pref cacheCVSRepository = Pref.makeStringPref("CVS Repository", User.getUserTool().prefs, "");
    private static Pref cacheCVSLastCommitMessage = Pref.makeStringPref("CVS Last Commit Message", User.getUserTool().prefs, "");

    private CVS() {
        super("CVS");
    }

    @Override
    public void init() {
        this.setOn();
    }

    public static CVS getCVSTool() {
        return tool;
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        if (!CVS.isEnabled()) {
            return;
        }
        if (newSnapshot.tool == tool) {
            return;
        }
        Edit.endBatch(oldSnapshot, newSnapshot, undoRedo);
    }

    public static void checkoutFromRepository() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CVS.runModalCVSCommand("-n checkout -c", "Getting modules in repository...", User.getWorkingDirectory(), out);
        LineNumberReader result = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        ArrayList<String> modules = new ArrayList<String>();
        while (true) {
            String line = null;
            try {
                line = result.readLine();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                return;
            }
            if (line == null) break;
            if ((line = line.trim()).equals("")) continue;
            String[] parts = line.split("\\s");
            modules.add(parts[0]);
        }
        if (modules.size() == 0) {
            System.out.println("No modules in CVS!");
            return;
        }
        Object ret = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Choose Module to Checkout", "Checkout Module...", 3, null, modules.toArray(), modules.toArray()[0]);
        if (ret == null) {
            return;
        }
        String module = (String)ret;
        String directory = OpenFile.chooseDirectory("Choose directory in which to checkout module " + module);
        if (directory == null) {
            return;
        }
        String cmd = "checkout " + module;
        CVS.runModalCVSCommand(cmd, "Checking out '" + module + "' to " + directory, directory, System.out);
        System.out.println("Checked out '" + module + "' to '" + directory + "'");
    }

    public static int runCVSCommand(String cmd, String comment, String workingDir, OutputStream out) {
        String specifyRepository = "";
        if (!CVS.getRepository().equals("")) {
            specifyRepository = " -d" + CVS.getRepository();
        }
        String run = CVS.getCVSProgram() + specifyRepository + " " + cmd;
        System.out.println(comment + ": " + run);
        Exec e = new Exec(run, null, new File(workingDir), out, out);
        e.run();
        return e.getExitVal();
    }

    static int runCVSCommandWithQuotes(String cmd, String comment, String workingDir, OutputStream out) {
        String specifyRepository = "";
        if (!CVS.getRepository().equals("")) {
            specifyRepository = " -d " + CVS.getRepository();
        }
        cmd = CVS.getCVSProgram() + specifyRepository + " " + cmd;
        ArrayList<String> execparts = new ArrayList<String>();
        String[] quoteParts = cmd.split("\"");
        for (int i = 0; i < quoteParts.length; ++i) {
            if (i % 2 == 0) {
                String[] parts = quoteParts[i].trim().split("\\s+");
                for (int j = 0; j < parts.length; ++j) {
                    execparts.add(parts[j]);
                }
                continue;
            }
            execparts.add(quoteParts[i]);
        }
        String[] exec = new String[execparts.size()];
        for (int i = 0; i < exec.length; ++i) {
            exec[i] = (String)execparts.get(i);
        }
        System.out.println(comment + ": " + cmd);
        Exec e = new Exec(exec, null, new File(workingDir), out, out);
        e.run();
        return e.getExitVal();
    }

    public static void runModalCVSCommand(String cmd, String comment, String workingDir, OutputStream out) {
        String run = CVS.getCVSProgram() + " -d" + CVS.getRepository() + " " + cmd;
        Exec e = new Exec(run, null, new File(workingDir), out, out);
        String message = "Running: " + run;
        TopLevel frame = TopLevel.getCurrentJFrame();
        ModalCommandDialog dialog = new ModalCommandDialog(frame, true, e, message, comment);
        dialog.setVisible(true);
    }

    public static void testModal() {
        CVS.runModalCVSCommand("-n history -c -a", "testing command", User.getWorkingDirectory(), System.out);
    }

    public static File getCellFile(Cell cell) {
        if (CVS.isDELIB(cell.getLibrary())) {
            String relativeFile = DELIB.getCellFile(cell);
            URL libFile = cell.getLibrary().getLibFile();
            File file = TextUtils.getFile(libFile);
            if (file == null) {
                return null;
            }
            return new File(file, relativeFile);
        }
        return null;
    }

    public static boolean isDELIB(Library lib) {
        URL libFile = lib.getLibFile();
        if (libFile == null) {
            return false;
        }
        FileType type = OpenFile.getOpenFileType(libFile.getFile(), FileType.JELIB);
        return type == FileType.DELIB;
    }

    public static boolean isFileInCVS(File fd) {
        return CVS.isFileInCVS(fd, false, false);
    }

    public static boolean isFileInCVS(File fd, boolean assertScheduledForAdd, boolean assertScheduledForRemove) {
        if (fd == null) {
            return false;
        }
        File parent = fd.getParentFile();
        File CVSDIR = new File(parent, "CVS");
        if (!CVSDIR.exists()) {
            return false;
        }
        File entries = new File(CVSDIR, "Entries");
        if (!entries.exists()) {
            return false;
        }
        String filename = fd.getName();
        boolean found = false;
        FileReader fr = null;
        try {
            String line;
            fr = new FileReader(entries);
            LineNumberReader reader = new LineNumberReader(fr);
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (line.equals("") || (parts = line.split("/")).length < 2 || !parts[1].equals(filename)) continue;
                if (assertScheduledForAdd) {
                    if (parts.length < 3 || !parts[2].equals("0")) break;
                    found = true;
                    break;
                }
                if (assertScheduledForRemove) {
                    if (parts.length < 3 || !parts[2].startsWith("-")) break;
                    found = true;
                    break;
                }
                found = true;
                break;
            }
            fr.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return found;
    }

    public static boolean isInCVS(Library lib) {
        File libfile = TextUtils.getFile(lib.getLibFile());
        if (libfile == null) {
            return false;
        }
        String libfilestr = libfile.getPath();
        File libFile = new File(libfilestr);
        if (CVS.isDELIB(lib)) {
            File header = new File(libFile, DELIB.getHeaderFile());
            if (!CVS.isFileInCVS(libFile) || !CVS.isFileInCVS(header)) {
                return false;
            }
        } else if (!CVS.isFileInCVS(libFile)) {
            return false;
        }
        return true;
    }

    public static boolean isInCVS(Cell cell) {
        if (!CVS.isDELIB(cell.getLibrary())) {
            return CVS.isInCVS(cell.getLibrary());
        }
        File cellFile = CVS.getCellFile(cell);
        return CVS.isFileInCVS(cellFile);
    }

    public static boolean assertNotModified(Cell cell, String cmd, boolean dialog) {
        if (cell.isModified()) {
            if (dialog) {
                Job.getUserInterface().showErrorMessage("Cell " + cell.getName() + " must be saved to run CVS " + cmd, "CVS " + cmd);
            } else {
                System.out.println("Cell " + cell.getName() + " must be saved to run CVS " + cmd);
            }
            return false;
        }
        return true;
    }

    public static boolean assertInCVS(Library lib, String cmd, boolean dialog) {
        File libFile = new File(lib.getLibFile().getPath());
        if (!CVS.isFileInCVS(libFile)) {
            if (libFile.getPath().matches(".*?com.*?sun.*?electric.*?lib.*?spiceparts.*")) {
                return false;
            }
            String message = "Library " + lib.getName() + " is not part of CVS repository.\n" + "Use 'CVS Add' to add to current repository.";
            if (dialog) {
                Job.getUserInterface().showErrorMessage(message, "CVS " + cmd + " Failed");
            } else {
                System.out.println(message + " CVS " + cmd + " Failed");
            }
            return false;
        }
        return true;
    }

    public static boolean assertInCVS(Cell cell, String cmd, boolean dialog) {
        File cellFile = CVS.getCellFile(cell);
        if (cellFile == null) {
            String message = "Cell " + cell.libDescribe() + " is not part of CVS repository.\n" + "Use 'CVS Add' to add to current repository.";
            if (dialog) {
                Job.getUserInterface().showErrorMessage(message, "CVS " + cmd + " Failed");
            } else {
                System.out.println(message + " CVS " + cmd + " Failed");
            }
            return false;
        }
        return true;
    }

    public static void showError(String message, String title, List<Library> badLibs, List<Cell> badCells) {
        StringBuffer msg = new StringBuffer();
        msg.append(message);
        for (Library lib : badLibs) {
            msg.append("\n  Library " + lib.getName());
        }
        for (Cell cell : badCells) {
            msg.append("\n  Cell " + cell.noLibDescribe());
        }
        Job.getUserInterface().showErrorMessage(msg.toString(), title);
    }

    public static int askForChoice(String message, String title, List<Library> badLibs, List<Cell> badCells, String[] choices, String defaultChoice) {
        StringBuffer msg = new StringBuffer();
        msg.append(message);
        for (Library lib : badLibs) {
            msg.append("\n  Library " + lib.getName());
        }
        for (Cell cell : badCells) {
            msg.append("\n  Cell " + cell.noLibDescribe());
        }
        return Job.getUserInterface().askForChoice(msg.toString(), title, choices, defaultChoice);
    }

    static String getUseDir(List<Library> libs, List<Cell> cells) {
        if (libs != null) {
            for (Library lib : libs) {
                File libFile;
                if (lib.isHidden() || !lib.isFromDisk() || (libFile = TextUtils.getFile(lib.getLibFile())) == null) continue;
                return libFile.getParent();
            }
        }
        if (cells != null) {
            for (Cell cell : cells) {
                File libFile;
                Library lib = cell.getLibrary();
                if (lib.isHidden() || !lib.isFromDisk() || (libFile = TextUtils.getFile(lib.getLibFile())) == null) continue;
                return libFile.getParent();
            }
        }
        return User.getWorkingDirectory();
    }

    static StringBuffer getLibraryFiles(List<Library> libs, String useDir) {
        StringBuffer libsBuf = new StringBuffer();
        if (libs == null) {
            return libsBuf;
        }
        for (Library lib : libs) {
            File libFile = TextUtils.getFile(lib.getLibFile());
            if (libFile == null) continue;
            String file = libFile.getPath();
            if (file.startsWith(useDir)) {
                file = file.substring(useDir.length() + 1, file.length());
            }
            libsBuf.append(file + " ");
        }
        return libsBuf;
    }

    static StringBuffer getHeaderFilesForCommit(List<Library> libs, List<Cell> cells, String useDir) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        StringBuffer buf = new StringBuffer();
        for (Cell cell : cells) {
            File libFile;
            if (libs.contains(cell.getLibrary()) || !CVS.isDELIB(cell.getLibrary()) || (libFile = TextUtils.getFile(cell.getLibrary().getLibFile())) == null) continue;
            String file = libFile.getPath();
            if (file.startsWith(useDir)) {
                file = file.substring(useDir.length() + 1, file.length());
            }
            buf.append(file + File.separator + DELIB.getHeaderFile() + " ");
        }
        return buf;
    }

    static StringBuffer getCellFiles(List<Cell> cells, String useDir) {
        StringBuffer cellsBuf = new StringBuffer();
        if (cells == null) {
            return cellsBuf;
        }
        for (Cell cell : cells) {
            String file = CVS.getCellFile(cell).getPath();
            if (file.startsWith(useDir)) {
                file = file.substring(useDir.length() + 1, file.length());
            }
            cellsBuf.append(file + " ");
        }
        return cellsBuf;
    }

    static Cell getCellFromPath(String path) {
        int delibExt = path.toLowerCase().indexOf(".delib" + File.separator);
        if (delibExt == -1) {
            delibExt = path.toLowerCase().indexOf(".delib/");
        }
        if (delibExt == -1) {
            return null;
        }
        String libpath = path.substring(0, delibExt);
        File libFile = new File(libpath);
        String libName = libFile.getName();
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            return null;
        }
        File file = new File(path);
        String cellFile = file.getName();
        int ext = cellFile.lastIndexOf(46);
        if (ext == -1) {
            return null;
        }
        String cellName = cellFile.substring(0, ext);
        String view = cellFile.substring(ext + 1);
        View realView = View.findView(view);
        if (realView == null) {
            return null;
        }
        Cell cell = lib.findNodeProto(cellName + "{" + view + "}");
        return cell;
    }

    static Library getLibraryFromHeader(String headerPath) {
        int delibExt = headerPath.toLowerCase().indexOf(".delib" + File.separator);
        if (delibExt == -1) {
            delibExt = headerPath.toLowerCase().indexOf(".delib/");
        }
        if (delibExt == -1) {
            return null;
        }
        String libpath = headerPath.substring(0, delibExt);
        File libFile = new File(libpath);
        String filename = headerPath.substring(delibExt + 7);
        if (!filename.equals(DELIB.getHeaderFile())) {
            return null;
        }
        String libName = libFile.getName();
        Library lib = Library.findLibrary(libName);
        return lib;
    }

    public static void fixStaleCellReferences(List<Library> libs) {
        if (libs == null) {
            return;
        }
        for (Library lib : libs) {
            State state = CVSLibrary.getState(lib);
            if (state == State.CONFLICT) {
                Job.getUserInterface().showErrorMessage("Conflicts updating Library " + lib.getName() + ", not reloading library", "CVS Update had Conflicts");
                continue;
            }
            CVS.fixStaleCellReferences(lib);
        }
    }

    public static void fixStaleCellReferences(Library reloadedLib) {
        if (reloadedLib == null) {
            return;
        }
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow wnd;
            Cell cell;
            WindowFrame frame = it.next();
            if (!(frame.getContent() instanceof EditWindow) || (cell = (wnd = (EditWindow)frame.getContent()).getCell()) == null || cell.isLinked()) continue;
            Library newLib = Library.findLibrary(cell.getLibrary().getName());
            if (newLib == null) {
                return;
            }
            Cell newCell = newLib.findNodeProto(cell.noLibDescribe());
            if (newCell == null) {
                return;
            }
            wnd.setCell(newCell, VarContext.globalContext, null);
        }
    }

    private static String getRepository() {
        return CVS.getCVSRepository();
    }

    public static boolean isEnabled() {
        return cacheCVSEnabled.getBoolean();
    }

    public static void setEnabled(boolean b) {
        cacheCVSEnabled.setBoolean(b);
    }

    public static String getCVSProgram() {
        return cacheCVSProgram.getString();
    }

    public static void setCVSProgram(String s) {
        cacheCVSProgram.setString(s);
    }

    public static String getCVSRepository() {
        return cacheCVSRepository.getString();
    }

    public static void setCVSRepository(String s) {
        cacheCVSRepository.setString(s);
    }

    public static String getCVSLastCommitMessage() {
        return cacheCVSLastCommitMessage.getString();
    }

    public static void setCVSLastCommitMessage(String s) {
        cacheCVSLastCommitMessage.setString(s);
    }
}

