/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Mos
extends Part {
    private static final Map<PinTypeSetKey, PinType[]> TYPE_TO_PINTYPE_ARRAY = new HashMap<PinTypeSetKey, PinType[]>();
    private final int[] pin_coeffs;
    private double width;
    private final double length;
    private final boolean hasBody;

    private synchronized PinType[] getPinTypeArray() {
        PinTypeSetKey key = new PinTypeSetKey(this.type(), this.isCapacitor(), this.numSeries(), this.hasBody);
        PinType[] pinTypeArray = TYPE_TO_PINTYPE_ARRAY.get(key);
        if (pinTypeArray == null) {
            pinTypeArray = new PinType[this.pins.length];
            TYPE_TO_PINTYPE_ARRAY.put(key, pinTypeArray);
            DiffType diffType = new DiffType(this.type(), this.numSeries(), this.isCapacitor(), this.hasBody);
            pinTypeArray[this.nbGateDiffPins() - 1] = diffType;
            pinTypeArray[0] = diffType;
            int maxHeight = (this.numSeries() + 1) / 2;
            for (int gateHeight = 1; gateHeight <= maxHeight; ++gateHeight) {
                GateType gateType = new GateType(this.type(), this.numSeries(), gateHeight, this.isCapacitor(), this.hasBody);
                pinTypeArray[this.nbGateDiffPins() - 1 - gateHeight] = gateType;
                pinTypeArray[gateHeight] = gateType;
            }
            if (this.hasBody) {
                pinTypeArray[pinTypeArray.length - 1] = new BodyType(this.type(), this.numSeries(), this.isCapacitor());
            }
        }
        return pinTypeArray;
    }

    public synchronized PinType getPinTypeOfNthPin(int n) {
        return this.getPinTypeArray()[n];
    }

    private Mos(PrimitiveNode.Function np, NccNameProxy.PartNameProxy name, double width, double length, boolean hasBody, Wire[] pins) {
        super(name, np, pins);
        this.width = width;
        this.length = length;
        this.hasBody = hasBody;
        LayoutLib.error(np == null, "null type?");
        int nbGateDiff = pins.length - (hasBody ? 1 : 0);
        this.pin_coeffs = CoeffGen.getCoeffArray(nbGateDiff, hasBody);
        LayoutLib.error(pins.length != this.pin_coeffs.length, "wrong number of pin coeffs");
    }

    private int nbGateDiffPins() {
        return this.hasBody ? this.pins.length - 1 : this.pins.length;
    }

    private int bodyNdx() {
        return this.hasBody ? this.pins.length - 1 : -1;
    }

    private boolean bodyMatches(Mos t) {
        if (this.hasBody != t.hasBody) {
            return false;
        }
        if (!this.hasBody) {
            return true;
        }
        return this.pins[this.bodyNdx()] == t.pins[t.bodyNdx()];
    }

    private boolean matchForward(Mos t) {
        for (int i = 0; i < this.nbGateDiffPins(); ++i) {
            if (this.pins[i] == t.pins[i]) continue;
            return false;
        }
        return true;
    }

    private boolean matchReverse(Mos t) {
        int nbGateDiff = this.nbGateDiffPins();
        int i = 0;
        int j = nbGateDiff - 1;
        while (i < nbGateDiff) {
            if (this.pins[i] != t.pins[j]) {
                return false;
            }
            ++i;
            --j;
        }
        return true;
    }

    private boolean samePinsAs(Mos t) {
        if (this.pins.length != t.pins.length) {
            return false;
        }
        if (this.hasBody != t.hasBody) {
            return false;
        }
        if (!this.bodyMatches(t)) {
            return false;
        }
        return this.matchForward(t) || this.matchReverse(t);
    }

    private void flip() {
        int nbGateDiff = this.nbGateDiffPins();
        int i = 0;
        int j = nbGateDiff - 1;
        while (i < nbGateDiff / 2) {
            Wire w = this.pins[i];
            this.pins[i] = this.pins[j];
            this.pins[j] = w;
            ++i;
            --j;
        }
    }

    private Wire hiDiff() {
        return this.pins[this.nbGateDiffPins() - 1];
    }

    private Wire loDiff() {
        return this.pins[0];
    }

    public Mos(PrimitiveNode.Function np, NccNameProxy.PartNameProxy name, double width, double length, Wire src, Wire gate, Wire drn) {
        this(np, name, width, length, false, new Wire[]{src, gate, drn});
    }

    public Mos(PrimitiveNode.Function np, NccNameProxy.PartNameProxy name, double width, double length, Wire src, Wire gate, Wire drn, Wire body) {
        this(np, name, width, length, true, new Wire[]{src, gate, drn, body});
    }

    public double getLength() {
        return this.length;
    }

    public double getWidth() {
        return this.width;
    }

    public int numSeries() {
        return this.nbGateDiffPins() - 2;
    }

    public int[] getPinCoeffs() {
        return this.pin_coeffs;
    }

    private boolean touchesSomeGate(Wire w) {
        for (int i = 1; i < this.nbGateDiffPins() - 1; ++i) {
            if (w != this.pins[i]) continue;
            return true;
        }
        return false;
    }

    public boolean touchesOnlyOneDiffAndNoGate(Wire w) {
        return w == this.loDiff() ^ w == this.hiDiff() && !this.touchesSomeGate(w);
    }

    public boolean isCapacitor() {
        return this.pins[0] == this.pins[this.nbGateDiffPins() - 1];
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins.length;
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.pin_coeffs[i];
        }
        hc += this.getClass().hashCode();
        return new Integer(hc += this.type().hashCode());
    }

    public boolean parallelMerge(Part p, NccOptions nccOpt) {
        if (!(p instanceof Mos)) {
            return false;
        }
        Mos t = (Mos)p;
        if (this == t) {
            return false;
        }
        if (!this.isLike(t, nccOpt)) {
            return false;
        }
        if (!this.samePinsAs(t)) {
            return false;
        }
        this.width += t.width;
        t.setDeleted();
        return true;
    }

    public int typeCode() {
        int tw = Part.TYPE_FIELD_WIDTH;
        return this.type().ordinal() + ((this.isCapacitor() ? 1 : 0) << tw) + ((this.hasBody ? 1 : 0) << tw + 1) + (this.numSeries() << tw + 2);
    }

    public String typeString() {
        String t = this.type().getShortName();
        String c = this.isCapacitor() ? "_CAP" : "";
        String h = this.nbGateDiffPins() == 3 ? "" : "_" + (this.nbGateDiffPins() - 2) + "stack";
        String s = this.hasBody ? "_withBody" : "";
        return t + c + h + s;
    }

    public String valueDescription() {
        return "W=" + NccUtils.round(this.width, 2) + " L=" + NccUtils.round(this.length, 2);
    }

    public String connectionDescription(int n) {
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < this.pins.length; ++i) {
            if (i == 0) {
                msg.append("S=");
            } else if (i == this.nbGateDiffPins() - 1) {
                msg.append(" D=");
            } else if (this.hasBody && i == this.bodyNdx()) {
                msg.append(" B=");
            } else if (this.nbGateDiffPins() == 3) {
                msg.append(" G=");
            } else {
                msg.append(" G" + i + "=");
            }
            msg.append(this.pins[i].getName());
        }
        return msg.toString();
    }

    public String connectionDescription(Wire w) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s.append(",");
            }
            if (i == 0) {
                s.append("S");
                continue;
            }
            if (i == this.nbGateDiffPins() - 1) {
                s.append("D");
                continue;
            }
            if (this.hasBody && i == this.bodyNdx()) {
                s.append("B");
                continue;
            }
            if (this.nbGateDiffPins() == 3) {
                s.append("G");
                continue;
            }
            s.append("G" + i);
        }
        return s.toString();
    }

    public boolean isLike(Mos t, NccOptions nccOpt) {
        return this.type() == t.type() && NccUtils.sizesMatch(this.length, t.length, nccOpt);
    }

    public static boolean joinOnWire(Wire w, NccOptions nccOpt) {
        if (w.isDeleted()) {
            return false;
        }
        if (w.getPort() != null) {
            return false;
        }
        HashSet<Mos> trans = new HashSet<Mos>();
        Iterator<Part> it = w.getParts();
        while (it.hasNext()) {
            Part p = it.next();
            if (p.isDeleted()) continue;
            if (!(p instanceof Mos)) {
                return false;
            }
            Mos t = (Mos)p;
            if (!t.touchesOnlyOneDiffAndNoGate(w)) {
                return false;
            }
            trans.add(t);
            if (trans.size() <= 2) continue;
            return false;
        }
        if (trans.size() != 2) {
            return false;
        }
        it = trans.iterator();
        Mos ta = (Mos)it.next();
        Mos tb = (Mos)it.next();
        Mos.error(ta.getParent() != tb.getParent(), "mismatched parents?");
        if (!ta.isLike(tb, nccOpt)) {
            return false;
        }
        if (!NccUtils.sizesMatch(ta.width, tb.width, nccOpt)) {
            return false;
        }
        if (!ta.bodyMatches(tb)) {
            return false;
        }
        if (ta.hiDiff() != w) {
            ta.flip();
        }
        if (tb.loDiff() != w) {
            tb.flip();
        }
        Mos.error(ta.hiDiff() != w || tb.loDiff() != w, "joinOnWire: diffusion connections corrupted");
        boolean hasBody = ta.hasBody;
        Wire[] mergedPins = new Wire[ta.nbGateDiffPins() + tb.nbGateDiffPins() - 2 + (hasBody ? 1 : 0)];
        for (int aNdx = 0; aNdx < ta.nbGateDiffPins() - 1; ++aNdx) {
            mergedPins[aNdx] = ta.pins[aNdx];
        }
        for (int bNdx = 1; bNdx < tb.nbGateDiffPins(); ++bNdx) {
            mergedPins[aNdx++] = tb.pins[bNdx];
        }
        if (hasBody) {
            mergedPins[mergedPins.length - 1] = ta.pins[ta.bodyNdx()];
        }
        Mos stack = new Mos(ta.type(), ta.getNameProxy(), ta.getWidth(), ta.getLength(), hasBody, mergedPins);
        Circuit parent = tb.getParent();
        parent.adopt(stack);
        ta.setDeleted();
        tb.setDeleted();
        w.setDeleted();
        return true;
    }

    public Integer computeHashCode() {
        int nbGateDiff = this.nbGateDiffPins();
        int sumLo = 0;
        int sumHi = 0;
        int i = 0;
        int j = nbGateDiff - 1;
        while (i < (nbGateDiff + 1) / 2) {
            sumLo += this.pins[i].getCode() * this.pin_coeffs[i];
            sumHi += this.pins[j].getCode() * this.pin_coeffs[j];
            ++i;
            --j;
        }
        int sum = sumLo * sumHi;
        if (this.hasBody) {
            sum += this.pins[this.bodyNdx()].getCode() * this.pin_coeffs[this.bodyNdx()];
        }
        return new Integer(sum);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CoeffGen {
        private static ArrayList<int[]> coeffArraysNoBody = new ArrayList();
        private static ArrayList<int[]> coeffArraysBody = new ArrayList();

        private CoeffGen() {
        }

        private static void ensureListEntry(ArrayList<int[]> coeffArrays, int numPins) {
            while (coeffArrays.size() - 1 < numPins) {
                coeffArrays.add(null);
            }
        }

        public static int[] getCoeffArray(int nbGateDiff, boolean withBody) {
            ArrayList<int[]> coeffArrays = withBody ? coeffArraysBody : coeffArraysNoBody;
            CoeffGen.ensureListEntry(coeffArrays, nbGateDiff);
            int[] coeffArray = coeffArrays.get(nbGateDiff);
            if (coeffArray == null) {
                coeffArray = new int[nbGateDiff + (withBody ? 1 : 0)];
                int i = 0;
                int j = nbGateDiff - 1;
                while (i < (nbGateDiff + 1) / 2) {
                    int nthPrime = 30 + i + nbGateDiff;
                    coeffArray[i] = coeffArray[j] = Primes.get(nthPrime);
                    ++i;
                    --j;
                }
                if (withBody) {
                    coeffArray[coeffArray.length - 1] = Primes.get(30);
                }
                coeffArrays.set(nbGateDiff, coeffArray);
            }
            return coeffArray;
        }
    }

    private static class PinTypeSetKey {
        private PrimitiveNode.Function type;
        private boolean isCapacitor;
        private int numSeries;
        private boolean hasBody;

        public PinTypeSetKey(PrimitiveNode.Function type, boolean isCapacitor, int numSeries, boolean hasBody) {
            this.type = type;
            this.isCapacitor = isCapacitor;
            this.numSeries = numSeries;
            this.hasBody = hasBody;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PinTypeSetKey)) {
                return false;
            }
            PinTypeSetKey p = (PinTypeSetKey)o;
            return this.type == p.type && this.isCapacitor == p.isCapacitor && this.numSeries == p.numSeries && this.hasBody == p.hasBody;
        }

        public int hashCode() {
            return this.type.hashCode() + (this.isCapacitor ? 1 : 0) + (this.numSeries << 1);
        }
    }

    private static class BodyType
    implements PinType {
        private final int numSeries;
        private final PrimitiveNode.Function np;
        private final boolean cap;

        public String description() {
            String t = this.np.getShortName();
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            return t + c + h + "_withBody body";
        }

        public BodyType(PrimitiveNode.Function np, int numSeries, boolean cap) {
            LayoutLib.error(np == null, "null type?");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            this.np = np;
            this.numSeries = numSeries;
            this.cap = cap;
        }
    }

    private static class DiffType
    implements PinType {
        private final int numSeries;
        private final PrimitiveNode.Function np;
        private final boolean cap;
        private final boolean hasBody;

        public String description() {
            String t = this.np.getShortName();
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            String s = this.hasBody ? "_withBody" : "";
            return t + c + h + s + " diffusion";
        }

        public DiffType(PrimitiveNode.Function np, int numSeries, boolean cap, boolean hasBody) {
            LayoutLib.error(np == null, "null type?");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            this.np = np;
            this.numSeries = numSeries;
            this.cap = cap;
            this.hasBody = hasBody;
        }
    }

    private static class GateType
    implements PinType {
        private final int numSeries;
        private final PrimitiveNode.Function np;
        private final int gateHeight;
        private final boolean cap;
        private final boolean hasBody;

        public String description() {
            String t = this.np.getShortName();
            String c = this.cap ? "_CAP" : "";
            String h = this.numSeries == 1 ? "" : "_" + this.numSeries + "stack";
            String s = this.hasBody ? "_withBody" : "";
            int hiGate = this.numSeries + 1 - this.gateHeight;
            String g = "";
            if (this.numSeries > 2) {
                g = this.gateHeight + (this.gateHeight == hiGate ? "" : "/" + hiGate);
            }
            return t + c + h + s + " gate" + g;
        }

        public GateType(PrimitiveNode.Function np, int numSeries, int gateHeight, boolean cap, boolean hasBody) {
            LayoutLib.error(np == null, "null type?");
            LayoutLib.error(numSeries < 1, "bad numSeries");
            int highestGateInLowerHalfOfStack = (numSeries + 1) / 2;
            LayoutLib.error(gateHeight > highestGateInLowerHalfOfStack, "bad gate Height");
            this.np = np;
            this.numSeries = numSeries;
            this.gateHeight = gateHeight;
            this.cap = cap;
            this.hasBody = hasBody;
        }
    }
}

