/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.tool.logicaleffort.Instance;
import com.sun.electric.tool.logicaleffort.Pin;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Net {
    private String name;
    private ArrayList<Pin> pins;

    protected Net(String name) {
        this.name = name;
        this.pins = new ArrayList();
    }

    protected boolean isDrivenBySizeableGate() {
        for (Pin pin : this.pins) {
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.OUTPUT || inst.getType() != Instance.Type.LEGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean isDrivenByStaticGate() {
        for (Pin pin : this.pins) {
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.OUTPUT || inst.getType() != Instance.Type.STATICGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean isDrivenByGate() {
        for (Pin pin : this.pins) {
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.OUTPUT || inst.getType() != Instance.Type.LEGATE && inst.getType() != Instance.Type.STATICGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean drivesSizableGate() {
        for (Pin pin : this.pins) {
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.INPUT || inst.getType() != Instance.Type.LEGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean drivesStaticGate() {
        for (Pin pin : this.pins) {
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.INPUT || inst.getType() != Instance.Type.STATICGATE) continue;
            return true;
        }
        return false;
    }

    protected boolean drivesLoad() {
        for (Pin pin : this.pins) {
            Instance inst = pin.getInstance();
            if (pin.getDir() != Pin.Dir.INPUT || inst.getType() != Instance.Type.LOAD && inst.getType() != Instance.Type.WIRE) continue;
            return true;
        }
        return false;
    }

    protected void addPin(Pin pin) {
        this.pins.add(pin);
        pin.setNet(this);
    }

    protected ArrayList<Pin> getAllPins() {
        return this.pins;
    }

    protected ArrayList getOutputPins() {
        return Pin.getOutputPins(this.pins);
    }

    protected ArrayList getInputPins() {
        return Pin.getInputPins(this.pins);
    }

    protected ArrayList getInoutPins() {
        return Pin.getInoutPins(this.pins);
    }

    protected String getName() {
        return this.name;
    }
}

