/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellChangeJobs {
    private CellChangeJobs() {
    }

    private static void doArbitraryExtraction(Cell cell, Set<NodeInst> expandedNodes, List<NodeInst> nodes, boolean copyExports, int depth, boolean fromRight) {
        Job.getUserInterface().startProgressDialog("Extracting " + nodes.size() + " cells", null);
        HashMap<NodeInst, Map<PortInst, PortInst>> newNodes = new HashMap<NodeInst, Map<PortInst, PortInst>>();
        int done = 0;
        HashSet<NodeInst> nodesToKill = new HashSet<NodeInst>();
        ArrayList<Export> exportsToCopy = new ArrayList<Export>();
        for (NodeInst ni : nodes) {
            if (!ni.isCellInstance()) continue;
            HashMap<PortInst, PortInst> portMap = new HashMap<PortInst, PortInst>();
            CellChangeJobs.extractOneLevel(cell, expandedNodes, ni, GenMath.MATID, portMap, 1, depth, fromRight);
            newNodes.put(ni, portMap);
            Iterator<Export> it = ni.getExports();
            while (it.hasNext()) {
                exportsToCopy.add(it.next());
            }
            Job.getUserInterface().setProgressValue(++done * 100 / nodes.size());
            nodesToKill.add(ni);
        }
        Job.getUserInterface().setProgressNote("Replacing top-level arcs and exports");
        CellChangeJobs.replaceExtractedArcs(cell, cell, newNodes, GenMath.MATID, fromRight);
        if (copyExports) {
            for (Export pp : exportsToCopy) {
                PortInst oldPi = pp.getOriginalPort();
                Map nodePortMap = (Map)newNodes.get(oldPi.getNodeInst());
                if (nodePortMap == null) continue;
                PortInst newPi = (PortInst)nodePortMap.get(oldPi);
                if (newPi == null) {
                    pp.kill();
                    continue;
                }
                pp.move(newPi);
            }
        }
        cell.killNodes(nodesToKill);
        Job.getUserInterface().stopProgressDialog();
    }

    private static void extractOneLevel(Cell cell, Set<NodeInst> expandedNodes, NodeInst topno, AffineTransform prevTrans, Map<PortInst, PortInst> portMap, int curDepth, int totDepth, boolean fromRight) {
        HashMap<NodeInst, Map<PortInst, PortInst>> newNodes = new HashMap<NodeInst, Map<PortInst, PortInst>>();
        boolean hasEssentialBounds = false;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            NodeProto np = ni.getProto();
            if (np != Generic.tech().essentialBoundsNode) continue;
            hasEssentialBounds = true;
            break;
        }
        Cell subCell = (Cell)topno.getProto();
        AffineTransform localTrans = topno.translateOut(topno.rotateOut());
        localTrans.preConcatenate(prevTrans);
        Iterator<NodeInst> it2 = subCell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = it2.next();
            HashMap<PortInst, PortInst> subPortMap = new HashMap<PortInst, PortInst>();
            newNodes.put(ni, subPortMap);
            NodeProto np = ni.getProto();
            if (np == Generic.tech().cellCenterNode || np == Generic.tech().essentialBoundsNode && hasEssentialBounds) continue;
            boolean extractCell = false;
            if (ni.isCellInstance() && curDepth < totDepth) {
                extractCell = true;
            }
            if (extractCell) {
                CellChangeJobs.extractOneLevel(cell, expandedNodes, ni, localTrans, subPortMap, curDepth + 1, totDepth, fromRight);
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    PortInst fromPi = topno.findPortInstFromProto(e);
                    PortInst toPi = (PortInst)subPortMap.get(e.getOriginalPort());
                    portMap.put(fromPi, toPi);
                }
                continue;
            }
            String name = null;
            if (ni.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ni.getName(), cell, NodeInst.class, false, fromRight);
            }
            Orientation orient = topno.getOrient().concatenate(ni.getOrient());
            Point2D.Double pt = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            AffineTransform instTrans = ni.rotateOut(localTrans);
            instTrans.transform(pt, pt);
            NodeInst newNi = NodeInst.makeInstance(np, pt, ni.getXSize(), ni.getYSize(), cell, orient, name);
            if (newNi == null) continue;
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
            newNi.copyStateBits(ni);
            if (ni.isExpanded()) {
                expandedNodes.add(newNi);
            }
            newNi.copyVarsFrom(ni);
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst oldPi = pIt.next();
                PortInst newPi = newNi.findPortInstFromProto(oldPi.getPortProto());
                subPortMap.put(oldPi, newPi);
            }
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                PortInst fromPi = topno.findPortInstFromProto(e);
                PortInst toPi = newNi.findPortInstFromProto(e.getOriginalPort().getPortProto());
                portMap.put(fromPi, toPi);
            }
        }
        CellChangeJobs.replaceExtractedArcs(cell, subCell, newNodes, localTrans, fromRight);
    }

    private static void replaceExtractedArcs(Cell destCell, Cell cell, Map<NodeInst, Map<PortInst, PortInst>> nodeMaps, AffineTransform trans, boolean fromRight) {
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            PortInst oldHeadPi = ai.getHeadPortInst();
            NodeInst headNi = oldHeadPi.getNodeInst();
            Map<PortInst, PortInst> headMap = nodeMaps.get(headNi);
            PortInst oldTailPi = ai.getTailPortInst();
            NodeInst tailNi = oldTailPi.getNodeInst();
            Map<PortInst, PortInst> tailMap = nodeMaps.get(tailNi);
            if (headMap == null && tailMap == null) continue;
            PortInst newHeadPi = oldHeadPi;
            if (headMap != null && (newHeadPi = headMap.get(oldHeadPi)) == null) {
                System.out.println("Warning: arc " + ai.describe(false) + " in cell " + cell.describe(false) + " is missing head connectivity information");
                continue;
            }
            PortInst newTailPi = oldTailPi;
            if (tailMap != null && (newTailPi = tailMap.get(oldTailPi)) == null) {
                System.out.println("Warning: arc " + ai.describe(false) + " in cell " + cell.describe(false) + " is missing tail connectivity information");
                continue;
            }
            if (newHeadPi == null || newTailPi == null) {
                System.out.println("Warning: cannot reconnect arc in cell " + cell.describe(false) + " from " + oldHeadPi + " to " + oldTailPi);
                continue;
            }
            Point2D.Double headLoc = new Point2D.Double(ai.getHeadLocation().getX(), ai.getHeadLocation().getY());
            trans.transform(headLoc, headLoc);
            Point2D.Double tailLoc = new Point2D.Double(ai.getTailLocation().getX(), ai.getTailLocation().getY());
            trans.transform(tailLoc, tailLoc);
            ArcProto ap = ai.getProto();
            String name = null;
            if (ai.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ai.getName(), cell, ArcInst.class, false, fromRight);
            }
            ImmutableArcInst a = ai.getD();
            ArcInst newAi = ArcInst.newInstance(destCell, ap, name, a.nameDescriptor, newHeadPi, newTailPi, EPoint.snap(headLoc), EPoint.snap(tailLoc), a.getGridExtendOverMin(), a.getAngle(), a.flags);
            if (newAi == null) {
                System.out.println("Error: arc " + ai.describe(false) + " in cell " + cell.describe(false) + " was not extracted");
                continue;
            }
            newAi.copyPropertiesFrom(ai);
        }
    }

    public static void copyExpandedStatus(Map<CellId, Cell> newCells) {
        for (Map.Entry<CellId, Cell> e : newCells.entrySet()) {
            CellId oldCellId = e.getKey();
            Cell newCell = e.getValue();
            Cell oldCell = newCell.getDatabase().getCell(oldCellId);
            if (oldCell == null) continue;
            Iterator<NodeInst> it = oldCell.getNodes();
            while (it.hasNext()) {
                NodeInst newNi;
                NodeInst oldNi = it.next();
                if (!oldNi.isCellInstance() || (newNi = newCell.findNode(oldNi.getName())) == null) continue;
                newNi.setExpanded(oldNi.isExpanded());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IdMapper copyRecursively(List<Cell> fromCells, Library toLib, boolean verbose, boolean move, boolean allRelatedViews, boolean copySubCells, boolean useExisting, Map<CellId, Cell> newCells) {
        IdMapper idMapper = new IdMapper();
        Cell.setAllowCircularLibraryDependences(true);
        try {
            Cell fromCell;
            Cell copiedCell;
            HashMap<String, Map<String, String>> existing = new HashMap<String, Map<String, String>>();
            Iterator<Cell> i$ = fromCells.iterator();
            while (i$.hasNext() && (copiedCell = CellChangeJobs.copyRecursively(fromCell = i$.next(), toLib, verbose, move, "", true, allRelatedViews, allRelatedViews, copySubCells, useExisting, existing, idMapper, newCells)) != null) {
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            Cell.setAllowCircularLibraryDependences(false);
            throw throwable;
        }
        Cell.setAllowCircularLibraryDependences(false);
        return idMapper;
    }

    private static Cell copyRecursively(Cell fromCell, Library toLib, boolean verbose, boolean move, String subDescript, boolean schematicRelatedView, boolean allRelatedViews, boolean allRelatedViewsThisLevel, boolean copySubCells, boolean useExisting, Map<String, Map<String, String>> existing, IdMapper idMapper, Map<CellId, Cell> newCells) {
        Cell newFromCell;
        String newName;
        Iterator<ElectricObject> it;
        boolean found;
        if (copySubCells && !useExisting) {
            System.out.println("Cross-library copy warning: It makes no sense to copy subcells but not use them");
        }
        String toName = fromCell.getName();
        View toView = fromCell.getView();
        Cell copiedCell = CellChangeJobs.inDestLib(fromCell, existing, toLib);
        if (copiedCell != null) {
            return copiedCell;
        }
        if (copySubCells || fromCell.isSchematic()) {
            found = true;
            block0: while (found) {
                found = false;
                it = fromCell.getNodes();
                while (it.hasNext()) {
                    Cell oNp;
                    Cell cell;
                    NodeInst ni = it.next();
                    if (!copySubCells && !ni.isIconOfParent() || !ni.isCellInstance() || (cell = (Cell)ni.getProto()).getLibrary() == toLib || CellChangeJobs.inDestLib(cell, existing, toLib) != null || useExisting && !copySubCells && toLib.findNodeProto(cell.noLibDescribe()) != null) continue;
                    boolean doCopySchematicView = true;
                    if (ni.isIconOfParent()) {
                        doCopySchematicView = false;
                    }
                    if ((oNp = CellChangeJobs.copyRecursively(cell, toLib, verbose, move, "subcell ", doCopySchematicView, allRelatedViews, allRelatedViewsThisLevel, copySubCells, useExisting, existing, idMapper, newCells)) == null) {
                        if (move) {
                            System.out.println("Move of sub" + cell + " failed");
                        } else {
                            System.out.println("Copy of sub" + cell + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block0;
                }
            }
        }
        if (!allRelatedViewsThisLevel) {
            if (toView == View.ICON && schematicRelatedView) {
                found = true;
                while (found) {
                    found = false;
                    assert (fromCell.isLinked());
                    it = fromCell.getCellGroup().getCells();
                    while (it.hasNext()) {
                        Cell np = (Cell)it.next();
                        if (!np.isSchematic() || CellChangeJobs.inDestLib(np, existing, toLib) != null) continue;
                        Cell oNp = CellChangeJobs.copyRecursively(np, toLib, verbose, move, "schematic view ", true, allRelatedViews, false, copySubCells, useExisting, existing, idMapper, newCells);
                        if (oNp == null) {
                            if (move) {
                                System.out.println("Move of schematic view " + np + " failed");
                            } else {
                                System.out.println("Copy of schematic view " + np + " failed");
                            }
                            return null;
                        }
                        found = true;
                        break;
                    }
                    if (fromCell.isLinked()) continue;
                    return CellChangeJobs.inDestLib(fromCell, existing, toLib);
                }
            }
        } else {
            Cell np;
            Iterator<Cell> it2;
            found = true;
            Cell fromCellWalk = fromCell;
            block4: while (found) {
                found = false;
                it2 = fromCellWalk.getCellGroup().getCells();
                while (it2.hasNext()) {
                    np = it2.next();
                    if (!np.isIcon() || CellChangeJobs.inDestLib(np, existing, toLib) != null) continue;
                    Cell oNp = CellChangeJobs.copyRecursively(np, toLib, verbose, move, "alternate view ", true, allRelatedViews, false, copySubCells, useExisting, existing, idMapper, newCells);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + np + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + np + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block4;
                }
            }
            found = true;
            block6: while (found) {
                found = false;
                it2 = fromCellWalk.getCellGroup().getCells();
                while (it2.hasNext()) {
                    np = it2.next();
                    if (np.isIcon() || CellChangeJobs.inDestLib(np, existing, toLib) != null) continue;
                    Cell oNp = CellChangeJobs.copyRecursively(np, toLib, verbose, move, "alternate view ", true, allRelatedViews, false, copySubCells, useExisting, existing, idMapper, newCells);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + np + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + np + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block6;
                }
            }
        }
        if ((copiedCell = CellChangeJobs.inDestLib(fromCell, existing, toLib)) != null) {
            return copiedCell;
        }
        Map<String, String> libToNameMap = existing.get(fromCell.getName());
        if (libToNameMap == null) {
            libToNameMap = new HashMap<String, String>();
            existing.put(fromCell.getName(), libToNameMap);
        }
        if ((newName = libToNameMap.get(fromCell.getLibrary().getName())) == null) {
            for (int i = 0; i < 1000; ++i) {
                newName = toName;
                if (i > 0) {
                    newName = newName + "_" + i;
                }
                if (!libToNameMap.values().contains(newName)) break;
            }
            libToNameMap.put(fromCell.getLibrary().getName(), newName);
        }
        newName = newName + ";" + fromCell.getVersion();
        if (toView.getAbbreviation().length() > 0) {
            newName = newName + toView.getAbbreviationExtension();
        }
        if ((newFromCell = Cell.copyNodeProto(fromCell, toLib, newName, useExisting, existing)) == null) {
            System.out.println("Copy of " + subDescript + fromCell + " failed");
            return null;
        }
        if (verbose) {
            if (fromCell.getLibrary() != toLib) {
                String msg = "";
                msg = move ? msg + "Moved " : msg + "Copied ";
                msg = msg + subDescript + fromCell.libDescribe() + " to " + toLib;
                System.out.println(msg);
            } else {
                System.out.println("Copied " + subDescript + newFromCell);
            }
        }
        if (move) {
            Iterator<Library> it3 = Library.getLibraries();
            while (it3.hasNext()) {
                Library lib = it3.next();
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell np = cIt.next();
                    boolean found2 = true;
                    block11: while (found2) {
                        found2 = false;
                        Iterator<NodeInst> nIt = np.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst ni = nIt.next();
                            if (ni.getProto() != fromCell) continue;
                            NodeInst replacedNi = ni.replace(newFromCell, false, false);
                            if (replacedNi == null) {
                                System.out.println("Error moving " + ni + " in " + np);
                                found2 = false;
                                continue block11;
                            }
                            found2 = true;
                            continue block11;
                        }
                    }
                }
            }
            idMapper.moveCell(fromCell.backup(), newFromCell.getId());
            fromCell.kill();
        }
        if (newCells != null) {
            newCells.put(fromCell.getId(), newFromCell);
        }
        return newFromCell;
    }

    private static Cell inDestLib(Cell cell, Map<String, Map<String, String>> existing, Library destLib) {
        Map<String, String> libToNameMap = existing.get(cell.getName());
        if (libToNameMap == null) {
            return null;
        }
        String newCellName = libToNameMap.get(cell.getLibrary().getName());
        if (newCellName == null) {
            return null;
        }
        Cell copiedCell = destLib.findNodeProto(newCellName + ";" + cell.getVersion() + cell.getView().getAbbreviationExtension());
        return copiedCell;
    }

    public static class DuplicateCell
    extends Job {
        private Cell cell;
        private Library destLib;
        private String newName;
        private boolean entireGroup;
        private Cell dupCell;
        private boolean startNow;
        private Map<CellId, Cell> newCells = new HashMap<CellId, Cell>();

        public DuplicateCell(Cell cell, String newName, Library lib, boolean entireGroup, boolean startN) {
            super("Duplicate " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.destLib = lib;
            this.entireGroup = entireGroup;
            this.startNow = startN;
            if (this.startNow) {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.startJob();
            }
        }

        public boolean doIt() throws JobException {
            String newCellName = this.newName + this.cell.getView().getAbbreviationExtension();
            this.dupCell = Cell.copyNodeProto(this.cell, this.destLib, newCellName, false);
            if (this.dupCell == null) {
                System.out.println("Could not duplicate " + this.cell);
                return false;
            }
            this.newCells.put(this.cell.getId(), this.dupCell);
            if (!this.startNow) {
                this.fieldVariableChanged("newCells");
                this.fieldVariableChanged("dupCell");
            }
            System.out.println("Duplicated cell " + this.cell + ".  New cell is " + this.dupCell + ".");
            ArrayList<Cell> othersInGroup = new ArrayList<Cell>();
            Iterator<Cell> it = this.cell.getCellGroup().getCells();
            while (it.hasNext()) {
                othersInGroup.add(it.next());
            }
            for (Cell otherCell : othersInGroup) {
                if (otherCell == this.cell || !this.entireGroup && (!this.cell.isSchematic() || !otherCell.isIcon())) continue;
                Cell copyCell = Cell.copyNodeProto(otherCell, otherCell.getLibrary(), this.newName + otherCell.getView().getAbbreviationExtension(), false);
                if (copyCell == null) {
                    System.out.println("Could not duplicate cell " + otherCell);
                    break;
                }
                this.newCells.put(otherCell.getId(), copyCell);
                System.out.println("  Also duplicated cell " + otherCell + ".  New cell is " + copyCell + ".");
            }
            for (CellId oldCellId : this.newCells.keySet()) {
                Cell replaceCell;
                Cell newCell = this.newCells.get(oldCellId);
                if (!newCell.isSchematic()) continue;
                ArrayList<NodeInst> replaceThese = new ArrayList<NodeInst>();
                Iterator<NodeInst> it2 = newCell.getNodes();
                while (it2.hasNext()) {
                    NodeInst ni = it2.next();
                    replaceCell = this.newCells.get(ni.getProto().getId());
                    if (replaceCell == null) continue;
                    replaceThese.add(ni);
                }
                for (NodeInst ni : replaceThese) {
                    replaceCell = this.newCells.get(ni.getProto().getId());
                    ni.replace(replaceCell, true, true);
                }
            }
            return true;
        }

        public void terminateOK() {
            WindowContent content;
            CellChangeJobs.copyExpandedStatus(this.newCells);
            WindowFrame curWf = WindowFrame.getCurrentWindowFrame();
            if (curWf != null && (content = curWf.getContent()) != null && content.getCell() == this.cell) {
                curWf.setCellWindow(this.dupCell, null);
                return;
            }
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                WindowContent content2 = wf.getContent();
                if (content2 == null || content2.getCell() != this.cell) continue;
                curWf.setCellWindow(this.dupCell, null);
                return;
            }
        }
    }

    public static class NewCellVersion
    extends Job {
        private Cell cell;
        private Cell newVersion;
        private Map<CellId, Cell> newCells = new HashMap<CellId, Cell>();

        public NewCellVersion(Cell cell) {
            super("Create new Version of " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.newVersion = this.cell.makeNewVersion();
            if (this.newVersion == null) {
                return false;
            }
            this.newCells.put(this.cell.getId(), this.newVersion);
            this.fieldVariableChanged("newVersion");
            return true;
        }

        public void terminateOK() {
            if (this.newVersion == null) {
                return;
            }
            CellChangeJobs.copyExpandedStatus(this.newCells);
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                WindowContent content = wf.getContent();
                if (content == null || content.getCell() != this.cell) continue;
                wf.setCellWindow(this.newVersion, null);
            }
            EditWindow.repaintAll();
            System.out.println("Created new version: " + this.newVersion + ", old version renamed to " + this.cell);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtractCellInstances
    extends Job {
        private Cell cell;
        private List<NodeInst> nodes;
        private boolean copyExports;
        private boolean fromRight;
        private int depth;
        private Set<NodeInst> expandedNodes = new HashSet<NodeInst>();
        private boolean startNow;

        public ExtractCellInstances(Cell cell, List<NodeInst> highlighted, int depth, boolean copyExports, boolean fromRight, boolean startNow) {
            super("Extract Cell Instances", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nodes = highlighted;
            this.copyExports = copyExports;
            this.fromRight = fromRight;
            this.depth = depth;
            this.startNow = startNow;
            if (!startNow) {
                this.startJob();
            } else {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public boolean doIt() throws JobException {
            CellChangeJobs.doArbitraryExtraction(this.cell, this.expandedNodes, this.nodes, this.copyExports, this.depth, this.fromRight);
            if (!this.startNow) {
                this.fieldVariableChanged("expandedNodes");
            }
            return true;
        }

        @Override
        public void terminateOK() {
            for (NodeInst ni : this.expandedNodes) {
                ni.setExpanded(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageCell
    extends Job {
        Cell curCell;
        Set<Geometric> whatToPackage;
        String newCellName;
        private Set<NodeInst> expandedNodes = new HashSet<NodeInst>();
        private IconParameters iconParameters = IconParameters.makeInstance(true);

        public PackageCell(Cell curCell, Set<Geometric> whatToPackage, String newCellName) {
            super("Package Cell", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.whatToPackage = whatToPackage;
            this.newCellName = newCellName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Cell cell = Cell.makeInstance(Library.getCurrent(), this.newCellName);
            if (cell == null) {
                return false;
            }
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            for (Geometric look : this.whatToPackage) {
                NodeInst newNi;
                if (!(look instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)look;
                String name = null;
                Name oldName = ni.getNameKey();
                if (!oldName.isTempname()) {
                    name = oldName.toString();
                }
                if ((newNi = NodeInst.makeInstance(ni.getProto(), new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), ni.getXSize(), ni.getYSize(), cell, ni.getOrient(), name)) == null) {
                    return false;
                }
                newNodes.put(ni, newNi);
                newNi.copyStateBits(ni);
                if (ni.isExpanded()) {
                    this.expandedNodes.add(newNi);
                }
                newNi.copyVarsFrom(ni);
                newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
                Iterator<Export> it = ni.getExports();
                while (it.hasNext()) {
                    Export pp = it.next();
                    PortInst pi = newNi.findPortInstFromProto(pp.getOriginalPort().getPortProto());
                    Export newPp = Export.newInstance(cell, pi, pp.getName(), pp.getCharacteristic(), this.iconParameters);
                    if (newPp == null) continue;
                    newPp.copyTextDescriptorFrom(pp, Export.EXPORT_NAME);
                    newPp.copyVarsFrom(pp);
                }
            }
            for (Geometric look : this.whatToPackage) {
                ArcInst newAi;
                if (!(look instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)look;
                NodeInst niTail = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
                NodeInst niHead = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
                if (niTail == null || niHead == null) continue;
                PortInst piTail = niTail.findPortInstFromProto(ai.getTailPortInst().getPortProto());
                PortInst piHead = niHead.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
                String name = null;
                Name oldName = ai.getNameKey();
                if (!oldName.isTempname()) {
                    name = oldName.toString();
                }
                if ((newAi = ArcInst.makeInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), piHead, piTail, ai.getHeadLocation(), ai.getTailLocation(), name)) == null) {
                    return false;
                }
                newAi.copyPropertiesFrom(ai);
            }
            System.out.println("Cell " + cell.describe(true) + " created");
            return true;
        }

        @Override
        public void terminateOK() {
            for (NodeInst ni : this.expandedNodes) {
                ni.setExpanded(true);
            }
        }
    }

    public static class GraphLibraries
    extends Job {
        private Cell graphCell;

        public GraphLibraries() {
            super("Graph Libraries", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() throws JobException {
            GraphNode trueCgn;
            GraphNode cgn;
            Library lib;
            this.graphCell = Cell.newInstance(Library.getCurrent(), "LibraryStructure");
            this.fieldVariableChanged("graphCell");
            if (this.graphCell == null) {
                return false;
            }
            if (this.graphCell.getNumVersions() > 1) {
                System.out.println("Creating new version of cell: " + this.graphCell.getName());
            } else {
                System.out.println("Creating cell: " + this.graphCell.getName());
            }
            HashMap<Library, GraphNode> graphNodes = new HashMap<Library, GraphNode>();
            HashMap<Library, HashSet<Library>> libraryDependencies = new HashMap<Library, HashSet<Library>>();
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                lib = it.next();
                if (lib.isHidden()) continue;
                cgn = new GraphNode();
                cgn.name = lib.getName();
                cgn.leafLibrary = true;
                cgn.topLibrary = true;
                graphNodes.put(lib, cgn);
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    Iterator<NodeInst> nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        Library subLib;
                        NodeInst ni = nIt.next();
                        if (!ni.isCellInstance() || ni.isIconOfParent() || (subLib = ((Cell)ni.getProto()).getLibrary()) == lib) continue;
                        HashSet<Library> subLibs = (HashSet<Library>)libraryDependencies.get(lib);
                        if (subLibs == null) {
                            subLibs = new HashSet<Library>();
                            libraryDependencies.put(lib, subLibs);
                        }
                        subLibs.add(subLib);
                        cgn.leafLibrary = false;
                    }
                }
            }
            it = Library.getLibraries();
            while (it.hasNext()) {
                Set subLibs;
                lib = it.next();
                cgn = (GraphNode)graphNodes.get(lib);
                if (cgn == null || (subLibs = (Set)libraryDependencies.get(lib)) == null) continue;
                for (Library subLib : subLibs) {
                    GraphNode subCGN = (GraphNode)graphNodes.get(subLib);
                    if (subCGN == null) continue;
                    subCGN.topLibrary = false;
                }
            }
            double radius = 50.0;
            int numCentral = 0;
            int numTop = 0;
            int numLeaf = 0;
            for (Library lib2 : graphNodes.keySet()) {
                GraphNode cgn2 = (GraphNode)graphNodes.get(lib2);
                if (cgn2.topLibrary) {
                    ++numTop;
                    continue;
                }
                if (cgn2.leafLibrary) {
                    ++numLeaf;
                    continue;
                }
                ++numCentral;
            }
            double curAngle = 0.0;
            double curTop = 0.0;
            double curLeaf = 0.0;
            for (Library lib3 : graphNodes.keySet()) {
                GraphNode cgn3 = (GraphNode)graphNodes.get(lib3);
                if (cgn3.topLibrary) {
                    cgn3.x = -radius + radius * 2.0 / (double)numTop * curTop + radius * 2.0 / (double)(numTop + 1);
                    cgn3.y = radius * 1.25;
                    curTop += 1.0;
                    continue;
                }
                if (cgn3.leafLibrary) {
                    cgn3.x = -radius + radius * 2.0 / (double)numLeaf * curLeaf + radius * 2.0 / (double)(numLeaf + 1);
                    cgn3.y = -radius * 1.25;
                    curLeaf += 1.0;
                    continue;
                }
                cgn3.x = Math.cos(curAngle) * radius;
                cgn3.y = Math.sin(curAngle) * radius;
                curAngle += Math.PI * 2 / (double)numCentral;
            }
            NodeInst titleNi = NodeInst.newInstance(Generic.tech().invisiblePinNode, new Point2D.Double(0.0, radius * 1.5), 0.0, 0.0, this.graphCell);
            if (titleNi == null) {
                return false;
            }
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withRelSize(6.0);
            titleNi.newVar(Artwork.ART_MESSAGE, (Object)"Structure of library dependencies", td);
            ArrayList<GraphArc> allArcs = new ArrayList<GraphArc>();
            Iterator<Library> it2 = Library.getLibraries();
            while (it2.hasNext()) {
                Library lib4 = it2.next();
                if (lib4.isHidden()) continue;
                trueCgn = (GraphNode)graphNodes.get(lib4);
                Set subLibs = (Set)libraryDependencies.get(lib4);
                if (subLibs == null) continue;
                for (Library subLib : subLibs) {
                    GraphNode trueSubCgn = (GraphNode)graphNodes.get(subLib);
                    boolean found = false;
                    for (GraphArc ga : allArcs) {
                        if (ga.from != trueSubCgn || ga.to != trueCgn) continue;
                        found = true;
                        ga.doubleHeaded = true;
                        break;
                    }
                    if (found) continue;
                    GraphArc ga = new GraphArc();
                    ga.from = trueCgn;
                    ga.to = trueSubCgn;
                    ga.doubleHeaded = false;
                    allArcs.add(ga);
                }
            }
            for (Library lib4 : graphNodes.keySet()) {
                GraphNode cgn4 = (GraphNode)graphNodes.get(lib4);
                double x = cgn4.x;
                double y = cgn4.y;
                cgn4.pin = NodeInst.newInstance(Generic.tech().invisiblePinNode, new Point2D.Double(x, y), 0.0, 0.0, this.graphCell);
                if (cgn4.pin == null) {
                    return false;
                }
                TextDescriptor ctd = TextDescriptor.getNodeTextDescriptor().withRelSize(2.0);
                if (!cgn4.leafLibrary && !cgn4.topLibrary) {
                    ctd = x > Math.abs(y) ? ctd.withPos(AbstractTextDescriptor.Position.UPRIGHT) : (x < -Math.abs(y) ? ctd.withPos(AbstractTextDescriptor.Position.UPLEFT) : (y > Math.abs(x) ? ctd.withPos(AbstractTextDescriptor.Position.UPRIGHT).withRotation(AbstractTextDescriptor.Rotation.getRotation(90)) : ctd.withPos(AbstractTextDescriptor.Position.UPRIGHT).withRotation(AbstractTextDescriptor.Rotation.getRotation(270))));
                }
                cgn4.pin.setName(cgn4.name);
                cgn4.pin.setTextDescriptor(NodeInst.NODE_NAME, ctd);
            }
            for (GraphArc ga : allArcs) {
                PortInst niBotPi;
                trueCgn = ga.from;
                GraphNode trueSubCgn = ga.to;
                PortInst toppinPi = trueCgn.pin.getOnlyPortInst();
                ArcInst ai = ArcInst.makeInstance(Artwork.tech().solidArc, toppinPi, niBotPi = trueSubCgn.pin.getOnlyPortInst());
                if (ai == null) {
                    return false;
                }
                ai.setRigid(false);
                ai.setFixedAngle(false);
                ai.setSlidable(false);
                int color = 10;
                if (ga.doubleHeaded) {
                    color = 94;
                }
                if (trueCgn.topLibrary) {
                    color = 14;
                } else if (trueSubCgn.leafLibrary) {
                    color = 18;
                }
                ai.newVar(Artwork.ART_COLOR, (Object)new Integer(color));
                String msg = trueCgn.name + "-USES-" + trueSubCgn.name;
                if (ga.doubleHeaded) {
                    msg = trueCgn.name + "-CO-DEPENDS-ON-" + trueSubCgn.name;
                }
                ai.setName(msg);
                TextDescriptor atd = TextDescriptor.getArcTextDescriptor().withDisplay(false);
                ai.setTextDescriptor(ArcInst.ARC_NAME, atd);
            }
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            ui.displayCell(this.graphCell);
        }

        private static class GraphArc {
            GraphNode from;
            GraphNode to;
            boolean doubleHeaded;

            private GraphArc() {
            }
        }

        private static class GraphNode {
            String name;
            boolean topLibrary;
            boolean leafLibrary;
            double x;
            double y;
            NodeInst pin;

            private GraphNode() {
            }
        }
    }

    public static class GraphCells
    extends Job {
        private static final double TEXTHEIGHT = 2.0;
        private Cell top;
        private Cell graphCell;

        public GraphCells(Cell top) {
            super("Graph Cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.top = top;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            GraphNode cgn;
            double xsc;
            NodeInst titleNi;
            GraphNode cgn2;
            this.graphCell = Cell.newInstance(Library.getCurrent(), "CellStructure");
            this.fieldVariableChanged("graphCell");
            if (this.graphCell == null) {
                return false;
            }
            if (this.graphCell.getNumVersions() > 1) {
                System.out.println("Creating new version of cell: " + this.graphCell.getName());
            } else {
                System.out.println("Creating cell: " + this.graphCell.getName());
            }
            HashMap<Cell, GraphNode> graphNodes = new HashMap<Cell, GraphNode>();
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                if (lib.isHidden()) continue;
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    GraphNode cgn3 = new GraphNode();
                    cgn3.name = cell.describe(false);
                    cgn3.depth = -1;
                    graphNodes.put(cell, cgn3);
                }
            }
            int maxDepth = 0;
            if (this.top != null) {
                GraphNode cgn4 = (GraphNode)graphNodes.get(this.top);
                cgn4.depth = 0;
            } else {
                Iterator<Cell> cIt = Library.getCurrent().getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    if (cell.getNumUsagesIn() != 0) continue;
                    GraphNode cgn5 = (GraphNode)graphNodes.get(cell);
                    cgn5.depth = 0;
                }
            }
            double xScale = 0.6666666666666666;
            double yScale = 20.0;
            double yOffset = 2.5;
            double maxWidth = 0.0;
            boolean more = true;
            while (more) {
                more = false;
                Iterator<Library> it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    Library lib = it2.next();
                    if (lib.isHidden()) continue;
                    Iterator<Cell> cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell cell = cIt.next();
                        cgn2 = (GraphNode)graphNodes.get(cell);
                        if (cgn2.depth == -1) continue;
                        Iterator<NodeInst> nIt = cell.getNodes();
                        while (nIt.hasNext()) {
                            Cell trueCell;
                            NodeInst ni = nIt.next();
                            if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                            Cell sub = (Cell)ni.getProto();
                            GraphNode subCgn = (GraphNode)graphNodes.get(sub);
                            if (subCgn.depth <= cgn2.depth) {
                                subCgn.depth = cgn2.depth + 1;
                                if (subCgn.depth > maxDepth) {
                                    maxDepth = subCgn.depth;
                                }
                                more = true;
                            }
                            if ((trueCell = sub.contentsView()) == null) continue;
                            GraphNode trueCgn = (GraphNode)graphNodes.get(trueCell);
                            if (trueCgn.depth > cgn2.depth) continue;
                            trueCgn.depth = cgn2.depth + 1;
                            if (trueCgn.depth > maxDepth) {
                                maxDepth = trueCgn.depth;
                            }
                            more = true;
                        }
                    }
                }
                if (more || this.top != null) continue;
                Iterator<Cell> cIt = Library.getCurrent().getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    GraphNode cgn6 = (GraphNode)graphNodes.get(cell);
                    if (cgn6.depth >= 0) continue;
                    cgn6.depth = 0;
                    more = true;
                }
            }
            double[] xval = new double[++maxDepth];
            double[] yoff = new double[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                yoff[i] = 0.0;
                xval[i] = 0.0;
            }
            for (Cell cell : graphNodes.keySet()) {
                cgn2 = (GraphNode)graphNodes.get(cell);
                if (cgn2.depth == -1) continue;
                cgn2.x = xval[cgn2.depth];
                int n = cgn2.depth;
                xval[n] = xval[n] + (double)cgn2.name.length();
                if (xval[cgn2.depth] > maxWidth) {
                    maxWidth = xval[cgn2.depth];
                }
                cgn2.y = cgn2.depth;
                cgn2.yoff = 0.0;
            }
            for (Cell cell : graphNodes.keySet()) {
                cgn2 = (GraphNode)graphNodes.get(cell);
                if (cgn2.depth == -1 || !(xval[(int)cgn2.y] < maxWidth)) continue;
                double spread = maxWidth / xval[(int)cgn2.y];
                cgn2.x *= spread;
            }
            for (Cell cell : graphNodes.keySet()) {
                cgn2 = (GraphNode)graphNodes.get(cell);
                if (cgn2.depth == -1) continue;
                double x = cgn2.x;
                double y = cgn2.y;
                int n = (int)cgn2.y;
                double d = yoff[n];
                yoff[n] = d + 1.0;
                y = -y * yScale + d % 3.0 * yOffset;
                cgn2.x = x *= xScale;
                cgn2.y = y;
            }
            if (this.top == null) {
                Iterator<Library> it3 = Library.getLibraries();
                while (it3.hasNext()) {
                    Library lib = it3.next();
                    if (lib.isHidden()) continue;
                    Iterator<Cell> cIt = lib.getCells();
                    while (cIt.hasNext()) {
                        Cell trueCell;
                        Cell cell = cIt.next();
                        GraphNode cgn7 = (GraphNode)graphNodes.get(cell);
                        if (cgn7.depth != -1 || cell.getNumUsagesIn() != 0 && !cell.isIcon() && cell.getView() != View.LAYOUTSKEL || (trueCell = this.graphMainView(cell)) == null) continue;
                        GraphNode trueCgn = (GraphNode)graphNodes.get(trueCell);
                        if (trueCgn.depth == -1) continue;
                        cgn7.botPin = null;
                        cgn7.topPin = null;
                        cgn7.pin = null;
                        cgn7.main = trueCgn;
                        cgn7.yoff += yOffset * 2.0;
                        cgn7.x = trueCgn.x;
                        cgn7.y = trueCgn.y + trueCgn.yoff;
                    }
                }
            }
            if ((titleNi = NodeInst.newInstance(Generic.tech().invisiblePinNode, new Point2D.Double(xsc = maxWidth * xScale / 2.0, yScale), 0.0, 0.0, this.graphCell)) == null) {
                return false;
            }
            String msg = this.top != null ? "Structure below " + this.top : "Structure of library " + Library.getCurrent().getName();
            TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withRelSize(6.0);
            titleNi.newVar(Artwork.ART_MESSAGE, (Object)msg, td);
            for (Cell cell : graphNodes.keySet()) {
                cgn = (GraphNode)graphNodes.get(cell);
                if (cgn.depth == -1) continue;
                double x = cgn.x;
                double y = cgn.y;
                cgn.pin = NodeInst.newInstance(Generic.tech().invisiblePinNode, new Point2D.Double(x, y), 0.0, 0.0, this.graphCell);
                if (cgn.pin == null) {
                    return false;
                }
                cgn.topPin = NodeInst.newInstance(Generic.tech().invisiblePinNode, new Point2D.Double(x, y + 1.0), 0.0, 0.0, this.graphCell);
                if (cgn.topPin == null) {
                    return false;
                }
                cgn.botPin = NodeInst.newInstance(Generic.tech().invisiblePinNode, new Point2D.Double(x, y - 1.0), 0.0, 0.0, this.graphCell);
                if (cgn.botPin == null) {
                    return false;
                }
                PortInst pinPi = cgn.pin.getOnlyPortInst();
                PortInst toppinPi = cgn.botPin.getOnlyPortInst();
                PortInst botPinPi = cgn.topPin.getOnlyPortInst();
                ArcInst link1 = ArcInst.makeInstanceBase(Generic.tech().invisible_arc, 0.0, toppinPi, pinPi);
                ArcInst link2 = ArcInst.makeInstanceBase(Generic.tech().invisible_arc, 0.0, pinPi, botPinPi);
                link1.setRigid(true);
                link2.setRigid(true);
                link1.setHardSelect(true);
                link2.setHardSelect(true);
                cgn.topPin.setHardSelect();
                cgn.botPin.setHardSelect();
                TextDescriptor ctd = TextDescriptor.getNodeTextDescriptor().withRelSize(2.0);
                cgn.pin.newVar(Artwork.ART_MESSAGE, (Object)cgn.name, ctd);
            }
            for (Cell cell : graphNodes.keySet()) {
                cgn = (GraphNode)graphNodes.get(cell);
                if (cgn.depth == -1 || cgn.main == null) continue;
                PortInst firstPi = cgn.pin.getOnlyPortInst();
                ArcInst ai = ArcInst.makeInstanceBase(Artwork.tech().solidArc, 0.0, firstPi, firstPi);
                if (ai == null) {
                    return false;
                }
                ai.setRigid(true);
                ai.setHardSelect(true);
                ai.newVar(Artwork.ART_COLOR, (Object)new Integer(0));
            }
            int clock = 0;
            Iterator<Library> it4 = Library.getLibraries();
            while (it4.hasNext()) {
                Library lib = it4.next();
                if (lib.isHidden()) continue;
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    if (cell == this.graphCell) continue;
                    Cell trueCell = cell.contentsView();
                    if (trueCell == null) {
                        trueCell = cell;
                    }
                    GraphNode trueCgn = (GraphNode)graphNodes.get(trueCell);
                    if (trueCgn.depth == -1) continue;
                    ++clock;
                    Iterator<NodeInst> nIt = trueCell.getNodes();
                    while (nIt.hasNext()) {
                        PortInst niBotPi;
                        NodeInst ni = nIt.next();
                        if (!ni.isCellInstance() || ni.isIconOfParent()) continue;
                        Cell sub = (Cell)ni.getProto();
                        Cell truesubnp = sub.contentsView();
                        if (truesubnp == null) {
                            truesubnp = sub;
                        }
                        GraphNode trueSubCgn = (GraphNode)graphNodes.get(truesubnp);
                        if (trueSubCgn.clock == clock) continue;
                        trueSubCgn.clock = clock;
                        if (trueSubCgn.depth == -1) continue;
                        PortInst toppinPi = trueCgn.botPin.getOnlyPortInst();
                        ArcInst ai = ArcInst.makeInstance(Artwork.tech().solidArc, toppinPi, niBotPi = trueSubCgn.topPin.getOnlyPortInst());
                        if (ai == null) {
                            return false;
                        }
                        ai.setRigid(false);
                        ai.setFixedAngle(false);
                        ai.setSlidable(false);
                        ai.setHardSelect(true);
                        int color = 14;
                        if (trueCgn.y - trueSubCgn.y > yScale + yOffset + yOffset) {
                            color = 10;
                        }
                        ai.newVar(Artwork.ART_COLOR, (Object)new Integer(color));
                    }
                }
            }
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            ui.displayCell(this.graphCell);
        }

        private Cell graphMainView(Cell cell) {
            Cell cellInGroup;
            Cell mainSchem = cell.getCellGroup().getMainSchematics();
            if (mainSchem != null) {
                return mainSchem;
            }
            Iterator<Cell> it = cell.getCellGroup().getCells();
            while (it.hasNext()) {
                cellInGroup = it.next();
                if (cellInGroup.getView() != View.LAYOUT) continue;
                return cellInGroup;
            }
            it = cell.getCellGroup().getCells();
            while (it.hasNext()) {
                cellInGroup = it.next();
                if (cellInGroup.getView() != View.UNKNOWN) continue;
                return cellInGroup;
            }
            return null;
        }

        private static class GraphNode {
            String name;
            int depth;
            int clock;
            double x;
            double y;
            double yoff;
            NodeInst pin;
            NodeInst topPin;
            NodeInst botPin;
            GraphNode main;

            private GraphNode() {
            }
        }
    }

    public static class RenameCellGroup
    extends Job {
        Cell cellInGroup;
        String newName;

        public RenameCellGroup(Cell cellInGroup, String newName) {
            super("Rename Cell Group", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellInGroup = cellInGroup;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            boolean allSameName = true;
            String lastName = null;
            Iterator<Cell> it = this.cellInGroup.getCellGroup().getCells();
            while (it.hasNext()) {
                String cellName = it.next().getName();
                if (lastName != null && !lastName.equals(cellName)) {
                    allSameName = false;
                    break;
                }
                lastName = cellName;
            }
            ArrayList<Cell> cells = new ArrayList<Cell>();
            Iterator<Cell> it2 = this.cellInGroup.getCellGroup().getCells();
            while (it2.hasNext()) {
                cells.add(it2.next());
            }
            String newGroupCell = null;
            for (Cell cell : cells) {
                if (allSameName) {
                    cell.rename(this.newName, this.newName);
                    continue;
                }
                if (newGroupCell == null) {
                    System.out.println("Renaming is not possible because cells in group don't have same root name.");
                    System.out.println("'" + this.newName + "' was added as prefix.");
                    newGroupCell = this.newName + cell.getName();
                }
                cell.rename(this.newName + cell.getName(), newGroupCell);
            }
            return true;
        }
    }

    public static class DeleteCellGroup
    extends Job {
        List<Cell> cells = new ArrayList<Cell>();

        public DeleteCellGroup(Cell.CellGroup group) {
            super("Delete Cell Group", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            Iterator<Cell> it = group.getCells();
            while (it.hasNext()) {
                this.cells.add(it.next());
            }
            this.startJob();
        }

        public boolean doIt() throws JobException {
            for (Cell cell : this.cells) {
                if (!cell.isInUse("delete", false, false)) continue;
                return false;
            }
            for (Cell cell : this.cells) {
                cell.kill();
            }
            return true;
        }
    }

    public static class RenameCell
    extends Job {
        private Cell cell;
        private String newName;
        private String newGroupCell;
        private IdMapper idMapper;

        public RenameCell(Cell cell, String newName, String newGroupCell) {
            super("Rename " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.newGroupCell = newGroupCell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.idMapper = this.cell.rename(this.newName, this.newGroupCell);
            this.fieldVariableChanged("idMapper");
            return true;
        }

        public void terminateOK() {
            User.fixStaleCellReferences(this.idMapper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteManyCells
    extends Job {
        private List<Cell> cellsToDelete;

        public DeleteManyCells(List<Cell> cellsToDelete) {
            super("Delete Multiple Cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellsToDelete = cellsToDelete;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            boolean didDelete = true;
            while (didDelete) {
                didDelete = false;
                for (int i = 0; i < this.cellsToDelete.size(); ++i) {
                    Cell cell = this.cellsToDelete.get(i);
                    if (cell.isInUse(null, true, true)) continue;
                    this.cellsToDelete.remove(i);
                    --i;
                    System.out.println("Deleting " + cell);
                    cell.kill();
                    didDelete = true;
                }
            }
            for (Cell cell : this.cellsToDelete) {
                cell.isInUse("delete", false, true);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            System.out.println("Deleted " + this.cellsToDelete.size() + " cells");
            EditWindow.repaintAll();
        }
    }

    public static class DeleteCell
    extends Job {
        Cell cell;

        public DeleteCell(Cell cell) {
            super("Delete " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.cell.isInUse("delete", false, true)) {
                return false;
            }
            this.cell.kill();
            return true;
        }
    }
}

