/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableLibrary;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library
extends ElectricObject
implements Comparable<Library> {
    public static final Variable.Key FONT_ASSOCIATIONS = Variable.newKey("LIB_font_associations");
    private static final int READFROMDISK = 4;
    public static final int HIDDENLIBRARY = 128;
    private final EDatabase database;
    private ImmutableLibrary d;
    private final List<Library> referencedLibs = new ArrayList<Library>();
    LibraryBackup backup;
    final TreeMap<CellName, Cell> cells = new TreeMap();

    Library(EDatabase database, ImmutableLibrary d) {
        if (database == null) {
            throw new NullPointerException();
        }
        this.database = database;
        this.d = d;
        this.backup = new LibraryBackup(d, true, LibId.NULL_ARRAY);
    }

    public static Library newInstance(String libName, URL libFile) {
        EDatabase database;
        Library existingLibrary;
        String legalName = LibId.legalLibraryName(libName);
        if (legalName == null) {
            return null;
        }
        if (legalName != libName) {
            System.out.println("Warning: library '" + libName + "' renamed to '" + legalName + "'");
        }
        if ((existingLibrary = (database = EDatabase.currentDatabase()).findLibrary(legalName)) != null) {
            System.out.println("Error: library '" + legalName + "' already exists");
            return existingLibrary;
        }
        return Library.newInstance(database, database.getIdManager().newLibId(legalName), libFile);
    }

    private static Library newInstance(EDatabase edb, LibId libId, URL libFile) {
        ImmutableLibrary d = ImmutableLibrary.newInstance(libId, libFile, null);
        Library lib = new Library(edb, d);
        edb.addLib(lib);
        edb.unfreshSnapshot();
        Constraints.getCurrent().newObject(lib);
        return lib;
    }

    private Object writeReplace() {
        return new LibraryKey(this);
    }

    public boolean kill(String reason) {
        if (!this.isLinked()) {
            System.out.println("Library already killed");
            return false;
        }
        Library newCurLib = null;
        if (Library.getCurrent() == this) {
            for (Library lib : this.database.libraries.values()) {
                if (lib == this || lib.isHidden()) continue;
                newCurLib = lib;
                break;
            }
        }
        if (this.database.libraries.get(this.getName()) != this) {
            System.out.println("Cannot delete library " + this);
            Job.getUserInterface().showErrorMessage("Cannot delete " + this.toString(), "Close library");
            return false;
        }
        boolean referenced = false;
        for (Library lib : this.database.libraries.values()) {
            if (lib == this) continue;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                Iterator<NodeInst> nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    Cell subCell;
                    NodeInst ni = nIt.next();
                    if (!ni.isCellInstance() || (subCell = (Cell)ni.getProto()).getLibrary() != this) continue;
                    Job.getUserInterface().showErrorMessage("Library close failed. Cannot " + reason + " " + this.toString() + " because one of its cells (" + subCell.noLibDescribe() + ") is being used (by " + cell.libDescribe() + ")", "Close library");
                    referenced = true;
                    break;
                }
                if (!referenced) continue;
                break;
            }
            if (!referenced) continue;
            break;
        }
        if (referenced) {
            return false;
        }
        this.erase();
        for (Library lib : this.database.libraries.values()) {
            if (lib == this) continue;
            lib.removeReferencedLib(this);
        }
        this.database.removeLib(this.getId());
        if (newCurLib != null) {
            Job.setCurrentLibraryInJob(newCurLib);
        }
        this.database.unfreshSnapshot();
        Constraints.getCurrent().killObject(this);
        return true;
    }

    public void erase() {
        Iterator<Cell> it = this.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            c.kill();
        }
        this.cells.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCell(Cell c) {
        CellName cn = c.getCellName();
        TreeMap<CellName, Cell> treeMap = this.cells;
        synchronized (treeMap) {
            if (this.cells.containsKey(cn)) {
                System.out.println("Tried to re-add a cell to a library: " + c);
                return;
            }
            this.cells.put(cn, c);
            this.updateNewestVersions();
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCell(Cell c) {
        CellName cn = c.getCellName();
        TreeMap<CellName, Cell> treeMap = this.cells;
        synchronized (treeMap) {
            if (this.cells.get(cn) != c) {
                System.out.println("Tried to remove a non-existant Cell from a library: " + c);
                return;
            }
            this.cells.remove(cn);
            c.newestVersion = null;
            this.updateNewestVersions();
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectCells() {
        TreeMap<CellName, Cell> treeMap = this.cells;
        synchronized (treeMap) {
            this.cells.clear();
            for (int cellIndex = 0; cellIndex < this.database.linkedCells.size(); ++cellIndex) {
                Cell cell = this.database.getCell(cellIndex);
                if (cell == null || cell.getLibrary() != this) continue;
                this.cells.put(cell.getCellName(), cell);
            }
            this.updateNewestVersions();
        }
    }

    private void updateNewestVersions() {
        Cell newestVersion = null;
        for (Cell cell : this.cells.values()) {
            if (newestVersion == null || !newestVersion.getName().equals(cell.getName()) || newestVersion.getView() != cell.getView()) {
                newestVersion = cell;
            }
            cell.newestVersion = newestVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LibraryDependency addReferencedLib(Library lib) {
        List<Library> list2 = this.referencedLibs;
        synchronized (list2) {
            if (this.referencedLibs.contains(lib)) {
                return null;
            }
        }
        ArrayList<Library> libDependencies = new ArrayList<Library>();
        if (lib.isReferencedLib(this, libDependencies)) {
            LibraryDependency d = new LibraryDependency();
            d.startLib = lib;
            d.finalRefLib = this;
            Library startLib = lib;
            for (Library refLib : libDependencies) {
                boolean found = false;
                Iterator<Cell> itCell = startLib.getCells();
                while (itCell.hasNext()) {
                    Cell c = itCell.next();
                    Iterator<NodeInst> it = c.getNodes();
                    while (it.hasNext()) {
                        Cell cc;
                        NodeInst ni = it.next();
                        if (!ni.isCellInstance() || (cc = (Cell)ni.getProto()).getLibrary() != refLib) continue;
                        d.dependencies.add(c);
                        d.dependencies.add(cc);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (!found) {
                    System.out.println("ERROR: Library.addReferencedLib dependency trace failed inexplicably");
                }
                startLib = refLib;
            }
            return d;
        }
        List<Library> list3 = this.referencedLibs;
        synchronized (list3) {
            this.referencedLibs.add(lib);
            this.updateBackup(this.d, this.backup.modified, this.backupReferencedLibs(this.backup.referencedLibs));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReferencedLib(Library lib) {
        if (lib == this) {
            return;
        }
        List<Library> list2 = this.referencedLibs;
        synchronized (list2) {
            if (!this.referencedLibs.contains(lib)) {
                return;
            }
        }
        boolean refFound = false;
        Iterator<Cell> itCell = this.getCells();
        while (itCell.hasNext()) {
            Cell c = itCell.next();
            Iterator<NodeInst> it = c.getNodes();
            while (it.hasNext()) {
                Cell cc;
                NodeInst ni = it.next();
                if (!ni.isCellInstance() || (cc = (Cell)ni.getProto()).getLibrary() != lib) continue;
                refFound = true;
                break;
            }
            if (!refFound) continue;
            break;
        }
        if (!refFound) {
            List<Library> list3 = this.referencedLibs;
            synchronized (list3) {
                this.referencedLibs.remove(lib);
                this.updateBackup(this.d, this.backup.modified, this.backupReferencedLibs(this.backup.referencedLibs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean referencesLib(Library lib) {
        List<Library> list2 = this.referencedLibs;
        synchronized (list2) {
            if (this.referencedLibs.contains(lib)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReferencedLib(Library lib, List<Library> libDepedencies) {
        ArrayList<Library> reflibsCopy = new ArrayList<Library>();
        List<Library> list2 = this.referencedLibs;
        synchronized (list2) {
            if (this.referencedLibs.contains(lib)) {
                libDepedencies.add(lib);
                return true;
            }
            reflibsCopy.addAll(this.referencedLibs);
        }
        for (Library reflib : reflibsCopy) {
            if (libDepedencies.contains(reflib)) continue;
            libDepedencies.add(reflib);
            if (reflib.isReferencedLib(lib, libDepedencies)) {
                return true;
            }
            libDepedencies.remove(reflib);
        }
        return false;
    }

    @Override
    public ImmutableLibrary getD() {
        return this.d;
    }

    private boolean setD(ImmutableLibrary newD) {
        this.checkChanging();
        ImmutableLibrary oldD = this.d;
        if (newD == oldD) {
            return false;
        }
        this.d = newD;
        assert (this.isLinked());
        this.updateBackup(this.d, true, this.backup.referencedLibs);
        Constraints.getCurrent().modifyLibrary(this, oldD);
        return true;
    }

    @Override
    public void addVar(Variable var) {
        this.setD(this.getD().withVariable(var));
    }

    @Override
    public void delVar(Variable.Key key) {
        this.setD(this.getD().withoutVariable(key));
    }

    public LibId getId() {
        return this.d.libId;
    }

    public static Library inCurrentThread(LibId libId) {
        return EDatabase.currentDatabase().getLib(libId);
    }

    @Override
    public boolean isLinked() {
        return Library.inCurrentThread(this.getId()) == this;
    }

    @Override
    public EDatabase getDatabase() {
        return this.database;
    }

    public LibraryBackup backup() {
        return this.backup;
    }

    void recover(LibraryBackup recoverBackup) {
        this.checkUndoing();
        this.backup = recoverBackup;
        this.d = recoverBackup.d;
        this.referencedLibs.clear();
        for (LibId libId : recoverBackup.referencedLibs) {
            this.referencedLibs.add(this.database.getLib(libId));
        }
    }

    void checkFresh(LibraryBackup libBackup) {
        assert (this.d == libBackup.d);
        assert (this.backup == libBackup);
        assert (libBackup.referencedLibs.length == this.referencedLibs.size());
        for (int i = 0; i < libBackup.referencedLibs.length; ++i) {
            assert (libBackup.referencedLibs[i] == this.referencedLibs.get(i).getId());
        }
    }

    private LibId[] backupReferencedLibs(LibId[] oldReferencedLibs) {
        int matchedRefs;
        int numRefs = Math.min(oldReferencedLibs.length, this.referencedLibs.size());
        for (matchedRefs = 0; matchedRefs < numRefs && oldReferencedLibs[matchedRefs] == this.referencedLibs.get(matchedRefs).getId(); ++matchedRefs) {
        }
        if (matchedRefs == oldReferencedLibs.length && matchedRefs == this.referencedLibs.size()) {
            return oldReferencedLibs;
        }
        LibId[] newRefs = new LibId[this.referencedLibs.size()];
        System.arraycopy(oldReferencedLibs, 0, newRefs, 0, matchedRefs);
        for (int i = matchedRefs; i < this.referencedLibs.size(); ++i) {
            newRefs[i] = this.referencedLibs.get(i).getId();
        }
        return newRefs;
    }

    public static void repairAllLibraries() {
        ErrorLogger errorLogger = ErrorLogger.newInstance("Repair Libraries");
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library l = it.next();
            l.checkAndRepair(true, errorLogger);
        }
        System.out.println("Repair Libraries: " + errorLogger.getNumErrors() + " errors, " + errorLogger.getNumWarnings() + " warnings");
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        boolean verbose;
        int errorCount = 0;
        boolean bl = verbose = !this.isHidden();
        if (verbose) {
            System.out.print("Checking " + this);
            if (repair) {
                System.out.print(" for repair");
            }
        }
        Iterator<Cell> it = this.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            errorCount += cell.checkAndRepair(repair, errorLogger);
        }
        if (errorCount != 0) {
            if (repair) {
                if (verbose) {
                    System.out.println("... library repaired");
                }
            } else if (verbose) {
                System.out.println("... library has to be repaired");
            }
        } else if (verbose) {
            System.out.println("... library checked");
        }
        return errorCount;
    }

    @Override
    protected void check() {
        assert (this.getD() == this.backup.d);
        assert (this.backup.referencedLibs.length == this.referencedLibs.size());
        super.check();
        String libName = this.d.libId.libName;
        assert (libName != null);
        assert (libName.length() > 0);
        assert (libName.indexOf(32) == -1 && libName.indexOf(58) == -1) : libName;
        for (int i = 0; i < this.referencedLibs.size(); ++i) {
            Library rLib = this.referencedLibs.get(i);
            assert (rLib.isLinked() && rLib.database == this.database);
            assert (this.backup.referencedLibs[i] == this.referencedLibs.get(i).getId());
        }
        HashSet<Cell.CellGroup> cellGroups = new HashSet<Cell.CellGroup>();
        String protoName = null;
        Cell.CellGroup cellGroup2 = null;
        Cell newestVersion = null;
        for (Map.Entry<CellName, Cell> e : this.cells.entrySet()) {
            CellName cn = e.getKey();
            Cell cell = e.getValue();
            assert (cell.isLinked() && cell.getDatabase() == this.database);
            assert (cell.getCellName() == cn);
            assert (cell.getLibrary() == this);
            if (protoName == null || !cell.getName().equals(protoName)) {
                protoName = cell.getName();
                cellGroup2 = cell.getCellGroup();
                assert (cellGroup2 != null) : cell;
                cellGroups.add(cellGroup2);
                newestVersion = cell;
            }
            if (cell.getView() != newestVersion.getView()) {
                newestVersion = cell;
            }
            assert (cell.getCellGroup() == cellGroup2) : cell;
            assert (cell.newestVersion == newestVersion);
        }
        for (Cell.CellGroup cellGroup2 : cellGroups) {
            cellGroup2.check();
        }
    }

    private void setFlag(int mask, boolean value2) {
        this.setD(this.d.withFlags(value2 ? this.d.flags | mask : this.d.flags & ~mask));
    }

    private boolean isFlag(int mask) {
        return (this.d.flags & mask) != 0;
    }

    public void setChanged() {
        this.checkChanging();
        if (!this.isChanged()) {
            this.updateBackup(this.d, true, this.backup.referencedLibs);
        }
    }

    public void clearChanged() {
        this.clearChanged(Collections.<Cell>emptySet());
    }

    public void clearChanged(Set<Cell> exceptCells) {
        this.checkChanging();
        boolean hasExceptions = false;
        for (Cell cell : this.cells.values()) {
            if (exceptCells.contains(cell)) {
                hasExceptions = true;
                continue;
            }
            cell.clearModified();
        }
        if (this.isChanged() && !hasExceptions) {
            this.updateBackup(this.d, false, this.backup.referencedLibs);
        }
    }

    private void updateBackup(ImmutableLibrary d, boolean modified, LibId[] referencedLibs) {
        this.backup = new LibraryBackup(d, modified, referencedLibs);
        this.database.unfreshSnapshot();
    }

    public boolean isChanged() {
        return this.backup.modified;
    }

    public void setFromDisk() {
        this.setFlag(4, true);
    }

    public void clearFromDisk() {
        this.setFlag(4, false);
    }

    public boolean isFromDisk() {
        return this.isFlag(4);
    }

    public void setHidden() {
        this.setFlag(128, true);
    }

    public void clearHidden() {
        this.setFlag(128, false);
    }

    public boolean isHidden() {
        return this.isFlag(128);
    }

    public static Library getCurrent() {
        return Job.getUserInterface().getCurrentLibrary();
    }

    public int lowLevelGetUserBits() {
        return this.d.flags;
    }

    public void lowLevelSetUserBits(int userBits) {
        this.setD(this.d.withFlags(userBits));
    }

    public static Set<Cell> findReferenceInCell(Library elib) {
        return EDatabase.currentDatabase().findReferenceInCell(elib);
    }

    public static Library findLibrary(String libName) {
        return EDatabase.currentDatabase().findLibrary(libName);
    }

    public static Iterator<Library> getLibraries() {
        return EDatabase.currentDatabase().getLibraries();
    }

    public static int getNumLibraries() {
        return EDatabase.currentDatabase().getNumLibraries();
    }

    public static List<Library> getVisibleLibraries() {
        return EDatabase.currentDatabase().getVisibleLibraries();
    }

    public String getName() {
        return this.d.libId.libName;
    }

    public IdMapper setName(String libName) {
        if (this.d.libId.libName.equals(libName)) {
            return null;
        }
        if (LibId.legalLibraryName(libName) != libName) {
            System.out.println("Error: '" + libName + "' is not a valid name");
            return null;
        }
        Library already = Library.findLibrary(libName);
        if (already != null) {
            System.out.println("Already a library called " + already.getName());
            return null;
        }
        Snapshot oldSnapshot = this.database.backup();
        LibId newLibId = oldSnapshot.idManager.newLibId(libName);
        IdMapper idMapper = IdMapper.renameLibrary(oldSnapshot, this.d.libId, newLibId);
        Snapshot newSnapshot = oldSnapshot.withRenamedIds(idMapper, null, null);
        LibraryBackup[] libBackups = newSnapshot.libBackups.toArray(new LibraryBackup[newSnapshot.libBackups.size()]);
        LibraryBackup libBackup = libBackups[newLibId.libIndex];
        String newLibFile = TextUtils.getFilePath(this.d.libFile) + libName;
        String extension = TextUtils.getExtension(this.d.libFile);
        if (extension.length() > 0) {
            newLibFile = newLibFile + "." + extension;
        }
        URL libFile = TextUtils.makeURLToFile(newLibFile);
        libBackups[newLibId.libIndex] = new LibraryBackup(libBackup.d.withLibFile(libFile), true, libBackup.referencedLibs);
        newSnapshot = newSnapshot.with(null, null, (CellTree[])null, libBackups);
        this.checkChanging();
        boolean isCurrent = Library.getCurrent() == this;
        this.database.lowLevelSetCanUndoing(true);
        this.database.undo(newSnapshot);
        this.database.lowLevelSetCanUndoing(false);
        Constraints.getCurrent().renameIds(idMapper);
        Library newLib = this.database.getLib(newLibId);
        if (isCurrent) {
            Job.setCurrentLibraryInJob(newLib);
        }
        return idMapper;
    }

    public URL getLibFile() {
        return this.d.libFile;
    }

    public void setLibFile(URL libFile) {
        this.setD(this.d.withLibFile(libFile));
    }

    @Override
    public int compareTo(Library that) {
        return TextUtils.STRING_NUMBER_ORDER.compare(this.getName(), that.getName());
    }

    @Override
    public String toString() {
        return "library '" + this.getName() + "'";
    }

    public Cell getCurCell() {
        String key;
        Preferences libPrefs = Pref.getLibraryPreferences(this.getId());
        String cellName = libPrefs.get(key = "CurrentCell", "");
        if (cellName.length() == 0) {
            return null;
        }
        Cell cell = this.findNodeProto(cellName);
        if (cell == null) {
            libPrefs.remove(key);
        }
        return cell;
    }

    public void setCurCell(Cell curCell) {
        Preferences libPrefs = Pref.getLibraryPreferences(this.getId());
        String key = "CurrentCell";
        if (curCell == null) {
            libPrefs.remove(key);
        } else {
            libPrefs.put(key, curCell.noLibDescribe());
        }
    }

    public static Cell findCellInLibraries(String cellName, View view, String libraryName) {
        Cell cell;
        Library lib;
        if (libraryName != null && (lib = Library.findLibrary(libraryName)) != null && (cell = lib.findNodeProto(cellName)) != null && (view == null || cell.getView() == view)) {
            return cell;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib2 = it.next();
            Cell cell2 = lib2.findNodeProto(cellName);
            if (cell2 == null || view != null && cell2.getView() != view) continue;
            return cell2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell findNodeProto(String name) {
        if (name == null) {
            return null;
        }
        CellName n = CellName.parseName(name);
        if (n == null) {
            return null;
        }
        TreeMap<CellName, Cell> treeMap = this.cells;
        synchronized (treeMap) {
            Cell cell = this.cells.get(n);
            if (cell != null) {
                return cell;
            }
            Cell onlyWithName = null;
            for (Cell c : this.cells.values()) {
                if (!n.getName().equals(c.getName())) continue;
                if (onlyWithName == null || onlyWithName.getVersion() < c.getVersion()) {
                    onlyWithName = c;
                }
                if (n.getView() != c.getView() || n.getVersion() > 0 && n.getVersion() != c.getVersion() || n.getVersion() == 0 && c.getNewestVersion() != c) continue;
                return c;
            }
            if (n.getView() == View.UNKNOWN && onlyWithName != null) {
                return onlyWithName;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumCells() {
        TreeMap<CellName, Cell> treeMap = this.cells;
        synchronized (treeMap) {
            return this.cells.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Cell> getCells() {
        TreeMap<CellName, Cell> treeMap = this.cells;
        synchronized (treeMap) {
            ArrayList<Cell> cellsCopy = new ArrayList<Cell>(this.cells.values());
            return cellsCopy.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Cell> getCellsTail(CellName cn) {
        TreeMap<CellName, Cell> treeMap = this.cells;
        synchronized (treeMap) {
            return this.cells.tailMap(cn).values().iterator();
        }
    }

    public Version getVersion() {
        return this.d.version;
    }

    public void setVersion(Version version) {
        this.setD(this.d.withVersion(version));
    }

    public Set<CellId> getDelibCells() {
        return this.d.delibCells;
    }

    public void setDelibCells() {
        HashSet<CellId> delibCells = new HashSet<CellId>();
        Iterator<Cell> it = this.getCells();
        while (it.hasNext()) {
            delibCells.add(it.next().getId());
        }
        this.setD(this.d.withDelibCells(delibCells));
    }

    static class LibraryDependency {
        private List<Cell> dependencies = new ArrayList<Cell>();
        private Library startLib;
        private Library finalRefLib;

        private LibraryDependency() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.startLib + " depends on " + this.finalRefLib + " through the following references:\n");
            Iterator<Cell> it = this.dependencies.iterator();
            while (it.hasNext()) {
                Cell libCell = it.next();
                Cell instance = it.next();
                buf.append("   " + libCell.libDescribe() + " instantiates " + instance.libDescribe() + "\n");
            }
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryKey
    extends EObjectInputStream.Key<Library> {
        public LibraryKey() {
        }

        private LibraryKey(Library lib) {
            super(lib);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Library lib) throws IOException {
            if (lib.getDatabase() != out.getDatabase() || !lib.isLinked()) {
                throw new NotSerializableException(lib + " not linked");
            }
            out.writeObject(lib.getId());
        }

        @Override
        public Library readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            LibId libId = (LibId)in.readObject();
            Library lib = libId.inDatabase(in.getDatabase());
            if (lib == null) {
                throw new InvalidObjectException(libId + " not linked");
            }
            return lib;
        }
    }
}

