/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc.wellcheck;

import com.sun.electric.database.topology.RTNode;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.erc.wellcheck.NetValues;
import com.sun.electric.tool.erc.wellcheck.Utils;
import com.sun.electric.tool.erc.wellcheck.WellCheckAnalysisStrategy;

public class ConnectionCheck
implements WellCheckAnalysisStrategy {
    private ERCWellCheck.StrategyParameter parameter;
    private boolean hasPCon;
    private boolean hasNCon;
    private RTNode pWellRoot;
    private RTNode nWellRoot;

    public ConnectionCheck(ERCWellCheck.StrategyParameter parameter, boolean hasPCon, boolean hasNCon, RTNode pWellRoot, RTNode nWellRoot) {
        this.parameter = parameter;
        this.hasPCon = hasPCon;
        this.hasNCon = hasNCon;
        this.pWellRoot = pWellRoot;
        this.nWellRoot = nWellRoot;
    }

    public void execute() {
        if (this.parameter.getWellPrefs().pWellCheck != 2) {
            this.findUnconnected(this.pWellRoot, this.pWellRoot, ERCWellCheck.WellType.pwell);
        }
        if (this.parameter.getWellPrefs().nWellCheck != 2) {
            this.findUnconnected(this.nWellRoot, this.nWellRoot, ERCWellCheck.WellType.nwell);
        }
        if (this.parameter.getWellPrefs().pWellCheck == 1 && !this.hasPCon) {
            this.parameter.logError("No P-Well contact found in this cell");
        }
        if (this.parameter.getWellPrefs().nWellCheck == 1 && !this.hasNCon) {
            this.parameter.logError("No N-Well contact found in this cell");
        }
    }

    private void findUnconnected(RTNode rtree, RTNode current, ERCWellCheck.WellType type) {
        for (int j = 0; j < current.getTotal(); ++j) {
            Object child;
            if (current.getFlag()) {
                child = (ERCWellCheck.WellBound)current.getChild(j);
                if (((ERCWellCheck.WellBound)child).getNetID() != null) continue;
                Utils.spreadWellSeed(((ERCWellCheck.WellBound)child).getBounds().getCenterX(), ((ERCWellCheck.WellBound)child).getBounds().getCenterY(), new NetValues(), rtree, 0);
                this.parameter.logError("No " + (Object)((Object)type) + "-Well contact in this area", child);
                continue;
            }
            child = (RTNode)current.getChild(j);
            this.findUnconnected(rtree, (RTNode)child, type);
        }
    }
}

