/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.util.concurrent.datastructures.FCQueue;
import com.sun.electric.tool.util.concurrent.datastructures.WorkStealingStructure;
import com.sun.electric.tool.util.concurrent.exceptions.PoolExistsException;
import com.sun.electric.tool.util.concurrent.patterns.PForTask;
import com.sun.electric.tool.util.concurrent.patterns.PJob;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.Scheduler;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.ThreadPool;
import com.sun.electric.tool.util.concurrent.utils.BlockedRange1D;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class SeaOfGatesEngineNew
extends SeaOfGatesEngine {
    private ThreadPool[] pools;

    @Override
    protected void doRouting(List<SeaOfGatesEngine.NeededRoute> allRoutes, SeaOfGatesEngine.RouteBatches[] routeBatches, Job job, Environment env, EditingPreferences ep) {
        try {
            ThreadPool.initialize(Scheduler.SchedulingStrategy.workStealing, 2, ThreadPool.ThreadPoolType.userDefined);
        }
        catch (PoolExistsException e1) {
        }
        catch (Scheduler.UnknownSchedulerException e) {
            // empty catch block
        }
        super.doRouting(allRoutes, routeBatches, job, env, ep);
        try {
            ThreadPool.getThreadPool().shutdown();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    @Override
    protected void doRoutingParallel(int numberOfThreads, List<SeaOfGatesEngine.NeededRoute> allRoutes, SeaOfGatesEngine.RouteBatches[] routeBatches, Environment env, EditingPreferences ep, Job job) {
        if (Job.getDebug()) {
            System.out.println("Do routing parallel with new parallel Infrastructure");
        }
        try {
            if (this.parallelDij) {
                this.pools = ThreadPool.initialize(new FCQueue<PTask>(), numberOfThreads, ThreadPool.ThreadPoolType.userDefined, new FCQueue<PTask>(), numberOfThreads, ThreadPool.ThreadPoolType.userDefined);
            } else {
                ThreadPool.initialize(WorkStealingStructure.createForThreadPool(numberOfThreads), numberOfThreads, ThreadPool.ThreadPoolType.synchronizedPool);
            }
        }
        catch (PoolExistsException e1) {
            // empty catch block
        }
        PJob seaOfGatesJob = this.pools != null ? new PJob(this.pools[0]) : new PJob();
        seaOfGatesJob.execute(false);
        SeaOfGatesEngine.NeededRoute[] routesToDo = new SeaOfGatesEngine.NeededRoute[numberOfThreads];
        int[] routeIndices = new int[numberOfThreads];
        ArrayList<SeaOfGatesEngine.NeededRoute> myList = new ArrayList<SeaOfGatesEngine.NeededRoute>();
        for (SeaOfGatesEngine.NeededRoute nr : allRoutes) {
            myList.add(nr);
        }
        ArrayList<Rectangle2D> blocked = new ArrayList<Rectangle2D>();
        int totalRoutes = allRoutes.size();
        int routesDone = 0;
        while (myList.size() > 0) {
            int i;
            if (job != null && job.checkAbort()) {
                System.out.println("Sea-of-gates routing aborted");
                break;
            }
            int threadAssign = 0;
            blocked.clear();
            for (int i2 = 0; i2 < myList.size(); ++i2) {
                SeaOfGatesEngine.NeededRoute nr = (SeaOfGatesEngine.NeededRoute)myList.get(i2);
                boolean isBlocked = false;
                for (Rectangle2D block : blocked) {
                    if (!block.intersects(nr.routeBounds)) continue;
                    isBlocked = true;
                    break;
                }
                if (isBlocked) continue;
                blocked.add(nr.routeBounds);
                routesToDo[threadAssign] = nr;
                routeIndices[threadAssign] = i2;
                seaOfGatesJob.add(new RouteInTask(seaOfGatesJob, nr, ep, job), threadAssign);
                if (++threadAssign >= numberOfThreads) break;
            }
            if (this.pools != null) {
                this.pools[0].trigger();
            } else {
                ThreadPool.getThreadPool().trigger();
            }
            String routes = "";
            for (i = 0; i < threadAssign; ++i) {
                String routeName = routesToDo[i].routeName;
                if (routeBatches[routesToDo[i].batchNumber].segsInBatch > 1) {
                    routeName = routeName + "(" + routesToDo[i].routeInBatch + "/" + routeBatches[routesToDo[i].batchNumber].segsInBatch + ")";
                }
                if (routes.length() > 0) {
                    routes = routes + ", ";
                }
                routes = routes + routeName;
            }
            System.out.println("Parallel routing " + routes + "...");
            Job.getUserInterface().setProgressNote(routes);
            seaOfGatesJob.join();
            for (i = 0; i < threadAssign; ++i) {
                if (routesToDo[i].winningWF == null || routesToDo[i].winningWF.vertices == null) continue;
                routesToDo[i].createRoute();
            }
            for (i = threadAssign - 1; i >= 0; --i) {
                myList.remove(routeIndices[i]);
            }
            Job.getUserInterface().setProgressValue((routesDone += threadAssign) * 100 / totalRoutes);
        }
        seaOfGatesJob.join();
        try {
            if (this.pools != null) {
                this.pools[0].shutdown();
                this.pools[1].shutdown();
            } else {
                ThreadPool.getThreadPool().shutdown();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    @Override
    protected void findPath(SeaOfGatesEngine.NeededRoute nr, Environment env, EditingPreferences ep, Job job) {
        SeaOfGatesEngine.Wavefront d1 = nr.dir1;
        if (DBMath.areEquals(d1.toX, d1.fromX) && DBMath.areEquals(d1.toY, d1.fromY) && d1.toZ == d1.fromZ) {
            nr.winningWF = d1;
            nr.winningWF.vertices = new ArrayList<SeaOfGatesEngine.SearchVertex>();
            SeaOfGatesEngine.SearchVertex sv = new SeaOfGatesEngine.SearchVertex(d1.toX, d1.toY, d1.toZ, 0, null, 0, nr.winningWF);
            nr.winningWF.vertices.add(sv);
            nr.cleanSearchMemory();
            return;
        }
        PJob dijkstraJob = this.pools.length == 2 ? new PJob(this.pools[1]) : new PJob();
        if (this.parallelDij) {
            dijkstraJob.add(new DijkstraInTask(dijkstraJob, nr.dir1, nr.dir2, ep));
            dijkstraJob.add(new DijkstraInTask(dijkstraJob, nr.dir2, nr.dir1, ep));
            dijkstraJob.execute();
        } else {
            this.doTwoWayDijkstra(nr);
        }
        SeaOfGatesEngine.Wavefront wf = nr.winningWF;
        double verLength = Double.MAX_VALUE;
        if (wf != null) {
            verLength = SeaOfGatesEngine.getVertexLength(wf.vertices);
        }
        if (verLength == Double.MAX_VALUE) {
            if (wf == null) {
                wf = nr.dir1;
            }
            String errorMsg = wf.vertices == null ? "Search too complex (exceeds complexity limit of " + nr.prefs.complexityLimit + " steps)" : "Failed to route from port " + wf.from.getPortProto().getName() + " of node " + wf.from.getNodeInst().describe(false) + " to port " + wf.to.getPortProto().getName() + " of node " + wf.to.getNodeInst().describe(false);
            System.out.println("ERROR: " + errorMsg);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(wf.toX, wf.toY));
            lineList.add(new EPoint(wf.fromX, wf.fromY));
            this.errorLogger.logMessageWithLines(errorMsg, null, lineList, this.cell, 0, true);
        }
        nr.cleanSearchMemory();
    }

    public class ParallelListOfRoutes
    extends PForTask<BlockedRange1D> {
        private SeaOfGatesEngine.RouteBatches[] routeBatches;
        private List<SeaOfGatesEngine.NeededRoute> allRoutes;
        private List<ArcInst> arcsToRoute;
        private EditingPreferences ep;

        public ParallelListOfRoutes(SeaOfGatesEngine.RouteBatches[] routeBatches, List<SeaOfGatesEngine.NeededRoute> allRoutes, List<ArcInst> arcsToRoute, EditingPreferences ep) {
            this.routeBatches = routeBatches;
            this.allRoutes = allRoutes;
            this.arcsToRoute = arcsToRoute;
            this.ep = ep;
        }

        @Override
        public void execute() {
            EditingPreferences.setThreadEditingPreferences(this.ep);
            SeaOfGatesEngineNew.this.doMakeListOfRoutes(((BlockedRange1D)this.range).start(), ((BlockedRange1D)this.range).end(), this.routeBatches, this.allRoutes, this.arcsToRoute);
        }
    }

    class DijkstraInTask
    extends PTask {
        private SeaOfGatesEngine.Wavefront wf;
        private SeaOfGatesEngine.Wavefront otherWf;
        private EditingPreferences ep;

        public DijkstraInTask(PJob job, SeaOfGatesEngine.Wavefront wf, SeaOfGatesEngine.Wavefront otherWf, EditingPreferences ep) {
            super(job);
            this.wf = wf;
            this.otherWf = otherWf;
            this.ep = ep;
        }

        @Override
        public void execute() {
            EditingPreferences.setThreadEditingPreferences(this.ep);
            SeaOfGatesEngine.SearchVertex result2 = null;
            int numSearchVertices = 0;
            while (result2 == null) {
                if (++numSearchVertices > this.wf.nr.prefs.complexityLimit) {
                    result2 = SeaOfGatesEngine.svLimited;
                    continue;
                }
                if (this.wf.abort) {
                    result2 = SeaOfGatesEngine.svAborted;
                    continue;
                }
                result2 = this.wf.advanceWavefront();
            }
            if (result2 != SeaOfGatesEngine.svAborted && result2 != SeaOfGatesEngine.svExhausted && result2 != SeaOfGatesEngine.svLimited) {
                this.wf.vertices = SeaOfGatesEngineNew.this.getOptimizedList(result2);
                this.wf.nr.winningWF = this.wf;
                this.otherWf.abort = true;
            }
        }
    }

    private class RouteInTask
    extends PTask {
        private SeaOfGatesEngine.NeededRoute nr;
        private EditingPreferences ed;
        private Job job;

        public RouteInTask(PJob pJob, SeaOfGatesEngine.NeededRoute nr, EditingPreferences ed, Job job) {
            super(pJob);
            this.nr = nr;
            this.ed = ed;
            this.job = job;
        }

        @Override
        public void execute() {
            EditingPreferences.setThreadEditingPreferences(this.ed);
            if (this.nr == null) {
                return;
            }
            SeaOfGatesEngineNew.this.findPath(this.nr, Environment.getThreadEnvironment(), this.ed, this.job);
        }
    }
}

