/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleExp;

public abstract class ScopeExp
extends Expression {
    Declaration decls;
    Declaration last;
    private Scope scope;
    public ScopeExp outer;
    protected int frameSize;
    static int counter;
    public int id = ++counter;

    public Declaration firstDecl() {
        return this.decls;
    }

    public Scope getVarScope() {
        Scope sc = this.scope;
        if (sc == null) {
            this.scope = sc = new Scope();
        }
        return sc;
    }

    public void popScope(CodeAttr code) {
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            decl.var = null;
        }
        code.popScope();
        this.scope = null;
    }

    public void add(Declaration decl) {
        if (this.last == null) {
            this.decls = decl;
        } else {
            this.last.next = decl;
        }
        this.last = decl;
        decl.context = this;
    }

    public void add(Declaration prev, Declaration decl) {
        if (prev == null) {
            decl.next = this.decls;
            this.decls = decl;
        } else {
            decl.next = prev.next;
            prev.next = decl;
        }
        if (this.last == prev) {
            this.last = decl;
        }
        decl.context = this;
    }

    public void replaceFollowing(Declaration prev, Declaration newDecl) {
        Declaration oldDecl;
        if (prev == null) {
            oldDecl = this.decls;
            this.decls = newDecl;
        } else {
            oldDecl = prev.next;
            prev.next = newDecl;
        }
        newDecl.next = oldDecl.next;
        if (this.last == oldDecl) {
            this.last = newDecl;
        }
        oldDecl.next = null;
        newDecl.context = this;
    }

    public void remove(Declaration decl) {
        Declaration prev = null;
        for (Declaration cur = this.firstDecl(); cur != null; cur = cur.nextDecl()) {
            if (cur == decl) {
                this.remove(prev, decl);
                return;
            }
            prev = cur;
        }
    }

    public void remove(Declaration prev, Declaration decl) {
        if (prev == null) {
            this.decls = decl.next;
        } else {
            prev.next = decl.next;
        }
        if (this.last == decl) {
            this.last = prev;
        }
    }

    public LambdaExp currentLambda() {
        ScopeExp exp = this;
        while (exp != null) {
            if (exp instanceof LambdaExp) {
                return (LambdaExp)exp;
            }
            exp = exp.outer;
        }
        return null;
    }

    public ModuleExp currentModule() {
        ScopeExp exp = this;
        while (exp != null) {
            if (exp instanceof ModuleExp) {
                return (ModuleExp)exp;
            }
            exp = exp.outer;
        }
        return null;
    }

    public Declaration lookup(Object sym) {
        if (sym != null) {
            for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
                if (!sym.equals(decl.symbol)) continue;
                return decl;
            }
        }
        return null;
    }

    public Declaration lookup(Object sym, Language language, int namespace) {
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (!sym.equals(decl.symbol) || !language.hasNamespace(decl, namespace)) continue;
            return decl;
        }
        return null;
    }

    public Declaration getNoDefine(Object name) {
        Declaration decl = this.lookup(name);
        if (decl == null) {
            decl = this.addDeclaration(name);
            decl.flags |= 0x10200;
        }
        return decl;
    }

    public Declaration getDefine(Object name, char severity, Compilation parser) {
        Declaration decl = this.lookup(name);
        if (decl == null) {
            decl = this.addDeclaration(name);
        } else if ((decl.flags & 0x10200) != 0) {
            decl.flags &= 0xFFFEFDFF;
        } else {
            Declaration newDecl = this.addDeclaration(name);
            ScopeExp.duplicateDeclarationError(decl, newDecl, parser);
            decl = newDecl;
        }
        return decl;
    }

    public static void duplicateDeclarationError(Declaration oldDecl, Declaration newDecl, Compilation comp) {
        comp.error('e', newDecl, "duplicate declaration of '", "'");
        comp.error('e', oldDecl, "(this is the previous declaration of '", "')");
    }

    public final Declaration addDeclaration(Object name) {
        Declaration decl = new Declaration(name);
        this.add(decl);
        return decl;
    }

    public final Declaration addDeclaration(Object name, Type type) {
        Declaration decl = new Declaration(name, type);
        this.add(decl);
        return decl;
    }

    public final void addDeclaration(Declaration decl) {
        this.add(decl);
    }

    public int countDecls() {
        int n = 0;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            ++n;
        }
        return n;
    }

    public static int nesting(ScopeExp sc) {
        int n = 0;
        while (sc != null) {
            sc = sc.outer;
            ++n;
        }
        return n;
    }

    protected void setIndexes() {
        int i = 0;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            decl.evalIndex = i++;
        }
        this.frameSize = i;
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkScopeExp(this);
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.id;
    }
}

