/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

class GTKColorChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    private static final float PI_3 = 1.0471976f;
    private ColorTriangle triangle;
    private JLabel lastLabel;
    private JLabel label;
    private JSpinner hueSpinner;
    private JSpinner saturationSpinner;
    private JSpinner valueSpinner;
    private JSpinner redSpinner;
    private JSpinner greenSpinner;
    private JSpinner blueSpinner;
    private JTextField colorNameTF;
    private boolean settingColor;
    private float hue;
    private float saturation;
    private float brightness;
    private static final int FLAGS_CHANGED_ANGLE = 1;
    private static final int FLAGS_DRAGGING = 2;
    private static final int FLAGS_DRAGGING_TRIANGLE = 4;
    private static final int FLAGS_SETTING_COLOR = 8;
    private static final int FLAGS_FOCUSED_WHEEL = 16;
    private static final int FLAGS_FOCUSED_TRIANGLE = 32;

    GTKColorChooserPanel() {
    }

    static void compositeRequestFocus(Component component, boolean bl) {
        if (component instanceof Container) {
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                ((Component)object2).requestFocus();
                return;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null) {
                object2 = ((Container)object).getFocusTraversalPolicy();
                Component component2 = bl ? ((FocusTraversalPolicy)object2).getComponentAfter((Container)object, container) : ((FocusTraversalPolicy)object2).getComponentBefore((Container)object, container);
                if (component2 != null) {
                    component2.requestFocus();
                    return;
                }
            }
        }
        component.requestFocus();
    }

    @Override
    public String getDisplayName() {
        return (String)UIManager.get("GTKColorChooserPanel.nameText");
    }

    @Override
    public int getMnemonic() {
        String string = (String)UIManager.get("GTKColorChooserPanel.mnemonic");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        String string = (String)UIManager.get("GTKColorChooserPanel.displayedMnemonicIndex");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.removeAll();
    }

    @Override
    protected void buildChooser() {
        this.triangle = new ColorTriangle();
        this.triangle.setName("GTKColorChooserPanel.triangle");
        this.label = new OpaqueLabel();
        this.label.setName("GTKColorChooserPanel.colorWell");
        this.label.setOpaque(true);
        this.label.setMinimumSize(new Dimension(67, 32));
        this.label.setPreferredSize(new Dimension(67, 32));
        this.label.setMaximumSize(new Dimension(67, 32));
        this.lastLabel = new OpaqueLabel();
        this.lastLabel.setName("GTKColorChooserPanel.lastColorWell");
        this.lastLabel.setOpaque(true);
        this.lastLabel.setMinimumSize(new Dimension(67, 32));
        this.lastLabel.setPreferredSize(new Dimension(67, 32));
        this.lastLabel.setMaximumSize(new Dimension(67, 32));
        this.hueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 360, 1));
        this.configureSpinner(this.hueSpinner, "GTKColorChooserPanel.hueSpinner");
        this.saturationSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.saturationSpinner, "GTKColorChooserPanel.saturationSpinner");
        this.valueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.valueSpinner, "GTKColorChooserPanel.valueSpinner");
        this.redSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.redSpinner, "GTKColorChooserPanel.redSpinner");
        this.greenSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.greenSpinner, "GTKColorChooserPanel.greenSpinner");
        this.blueSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));
        this.configureSpinner(this.blueSpinner, "GTKColorChooserPanel.blueSpinner");
        this.colorNameTF = new JTextField(8);
        this.setLayout(new GridBagLayout());
        this.add(this, "GTKColorChooserPanel.hue", this.hueSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.red", this.redSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.saturation", this.saturationSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.green", this.greenSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.value", this.valueSpinner, -1, -1);
        this.add(this, "GTKColorChooserPanel.blue", this.blueSpinner, -1, -1);
        this.add((Component)new JSeparator(0), new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 21, 2, new Insets(14, 0, 0, 0), 0, 0));
        this.add(this, "GTKColorChooserPanel.colorName", this.colorNameTF, 0, 4);
        this.add((Component)this.triangle, new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 21, 0, new Insets(14, 20, 2, 9), 0, 0));
        Box box = Box.createHorizontalBox();
        box.add(this.lastLabel);
        box.add(this.label);
        this.add((Component)box, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JSeparator(0), new GridBagConstraints(0, 6, 5, 1, 1.0, 0.0, 21, 2, new Insets(12, 0, 0, 0), 0, 0));
    }

    private void configureSpinner(JSpinner jSpinner, String string) {
        jSpinner.addChangeListener(this);
        jSpinner.setName(string);
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            jFormattedTextField.setFocusLostBehavior(1);
        }
    }

    private void add(Container container, String string, JComponent jComponent, int n, int n2) {
        Object object;
        JLabel jLabel = new JLabel(UIManager.getString((Object)(string + "Text"), this.getLocale()));
        String string2 = (String)UIManager.get(string + "Mnemonic", this.getLocale());
        if (string2 != null) {
            try {
                jLabel.setDisplayedMnemonic(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object = (String)UIManager.get(string + "MnemonicIndex", this.getLocale());
            if (object != null) {
                try {
                    jLabel.setDisplayedMnemonicIndex(Integer.parseInt((String)object));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        jLabel.setLabelFor(jComponent);
        if (n < 0) {
            n = container.getComponentCount() % 4;
        }
        if (n2 < 0) {
            n2 = container.getComponentCount() / 4;
        }
        object = new GridBagConstraints(n + 1, n2, 1, 1, 0.0, 0.0, 24, 0, new Insets(4, 0, 0, 4), 0, 0);
        if (n2 == 0) {
            ((GridBagConstraints)object).insets.top = 14;
        }
        container.add((Component)jLabel, object);
        ++((GridBagConstraints)object).gridx;
        container.add((Component)jComponent, object);
    }

    @Override
    public void updateChooser() {
        if (!this.settingColor) {
            this.lastLabel.setBackground(this.getColorFromModel());
            this.setColor(this.getColorFromModel(), true, true, false);
        }
    }

    private void setRed(int n) {
        this.setRGB(n << 16 | this.getColor().getGreen() << 8 | this.getColor().getBlue());
    }

    private void setGreen(int n) {
        this.setRGB(this.getColor().getRed() << 16 | n << 8 | this.getColor().getBlue());
    }

    private void setBlue(int n) {
        this.setRGB(this.getColor().getRed() << 16 | this.getColor().getGreen() << 8 | n);
    }

    private void setHue(float f, boolean bl) {
        this.setHSB(f, this.saturation, this.brightness);
        if (bl) {
            this.settingColor = true;
            this.hueSpinner.setValue((int)(f * 360.0f));
            this.settingColor = false;
        }
    }

    private float getHue() {
        return this.hue;
    }

    private void setSaturation(float f) {
        this.setHSB(this.hue, f, this.brightness);
    }

    private float getSaturation() {
        return this.saturation;
    }

    private void setBrightness(float f) {
        this.setHSB(this.hue, this.saturation, f);
    }

    private float getBrightness() {
        return this.brightness;
    }

    private void setSaturationAndBrightness(float f, float f2, boolean bl) {
        this.setHSB(this.hue, f, f2);
        if (bl) {
            this.settingColor = true;
            this.saturationSpinner.setValue((int)(f * 255.0f));
            this.valueSpinner.setValue((int)(f2 * 255.0f));
            this.settingColor = false;
        }
    }

    private void setRGB(int n) {
        Color color = new Color(n);
        this.setColor(color, false, true, true);
        this.settingColor = true;
        this.hueSpinner.setValue((int)(this.hue * 360.0f));
        this.saturationSpinner.setValue((int)(this.saturation * 255.0f));
        this.valueSpinner.setValue((int)(this.brightness * 255.0f));
        this.settingColor = false;
    }

    private void setHSB(float f, float f2, float f3) {
        Color color = Color.getHSBColor(f, f2, f3);
        this.hue = f;
        this.saturation = f2;
        this.brightness = f3;
        this.setColor(color, false, false, true);
        this.settingColor = true;
        this.redSpinner.setValue(color.getRed());
        this.greenSpinner.setValue(color.getGreen());
        this.blueSpinner.setValue(color.getBlue());
        this.settingColor = false;
    }

    private void setColor(Color color, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (color == null) {
            color = Color.BLACK;
        }
        this.settingColor = true;
        if (bl2) {
            object = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.hue = (float)object[0];
            this.saturation = (float)object[1];
            this.brightness = (float)object[2];
        }
        if (bl3 && (object = this.getColorSelectionModel()) != null) {
            object.setSelectedColor(color);
        }
        this.triangle.setColor(this.hue, this.saturation, this.brightness);
        this.label.setBackground(color);
        object = Integer.toHexString(color.getRGB() & 0xFFFFFF | 0x1000000);
        this.colorNameTF.setText("#" + ((String)object).substring(1));
        if (bl) {
            this.redSpinner.setValue(color.getRed());
            this.greenSpinner.setValue(color.getGreen());
            this.blueSpinner.setValue(color.getBlue());
            this.hueSpinner.setValue((int)(this.hue * 360.0f));
            this.saturationSpinner.setValue((int)(this.saturation * 255.0f));
            this.valueSpinner.setValue((int)(this.brightness * 255.0f));
        }
        this.settingColor = false;
    }

    public Color getColor() {
        return this.label.getBackground();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.settingColor) {
            return;
        }
        Color color = this.getColor();
        if (changeEvent.getSource() == this.hueSpinner) {
            this.setHue(((Number)this.hueSpinner.getValue()).floatValue() / 360.0f, false);
        } else if (changeEvent.getSource() == this.saturationSpinner) {
            this.setSaturation(((Number)this.saturationSpinner.getValue()).floatValue() / 255.0f);
        } else if (changeEvent.getSource() == this.valueSpinner) {
            this.setBrightness(((Number)this.valueSpinner.getValue()).floatValue() / 255.0f);
        } else if (changeEvent.getSource() == this.redSpinner) {
            this.setRed(((Number)this.redSpinner.getValue()).intValue());
        } else if (changeEvent.getSource() == this.greenSpinner) {
            this.setGreen(((Number)this.greenSpinner.getValue()).intValue());
        } else if (changeEvent.getSource() == this.blueSpinner) {
            this.setBlue(((Number)this.blueSpinner.getValue()).intValue());
        }
    }

    private class OpaqueLabel
    extends JLabel {
        private OpaqueLabel() {
        }

        @Override
        public boolean isOpaque() {
            return true;
        }
    }

    private static class ColorAction
    extends AbstractAction {
        private int type;

        ColorAction(String string, int n) {
            super(string);
            this.type = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorTriangle colorTriangle = (ColorTriangle)actionEvent.getSource();
            if (colorTriangle.isWheelFocused()) {
                float f = colorTriangle.getGTKColorChooserPanel().getHue();
                switch (this.type) {
                    case 0: 
                    case 2: {
                        colorTriangle.incrementHue(true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        colorTriangle.incrementHue(false);
                        break;
                    }
                    case 4: {
                        colorTriangle.focusTriangle();
                        break;
                    }
                    case 5: {
                        GTKColorChooserPanel.compositeRequestFocus(colorTriangle, false);
                    }
                }
            } else {
                int n = 0;
                int n2 = 0;
                switch (this.type) {
                    case 0: {
                        --n2;
                        break;
                    }
                    case 1: {
                        ++n2;
                        break;
                    }
                    case 2: {
                        --n;
                        break;
                    }
                    case 3: {
                        ++n;
                        break;
                    }
                    case 4: {
                        GTKColorChooserPanel.compositeRequestFocus(colorTriangle, true);
                        return;
                    }
                    case 5: {
                        colorTriangle.focusWheel();
                        return;
                    }
                }
                colorTriangle.adjustSB(colorTriangle.getColorX() + n, colorTriangle.getColorY() + n2, true);
            }
        }
    }

    private class ColorTriangle
    extends JPanel {
        private Image wheelImage;
        private Image triangleImage;
        private double angle;
        private int flags;
        private int circleX;
        private int circleY;

        public ColorTriangle() {
            this.enableEvents(4L);
            this.enableEvents(16L);
            this.enableEvents(32L);
            this.setMinimumSize(new Dimension(this.getWheelRadius() * 2 + 2, this.getWheelRadius() * 2 + 2));
            this.setPreferredSize(new Dimension(this.getWheelRadius() * 2 + 2, this.getWheelRadius() * 2 + 2));
            this.setFocusTraversalKeysEnabled(false);
            this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "up");
            this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "down");
            this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "left");
            this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "right");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_UP"), "up");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_DOWN"), "down");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_LEFT"), "left");
            this.getInputMap().put(KeyStroke.getKeyStroke("KP_RIGHT"), "right");
            this.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "focusNext");
            this.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), "focusLast");
            ActionMap actionMap = (ActionMap)UIManager.get("GTKColorChooserPanel.actionMap");
            if (actionMap == null) {
                actionMap = new ActionMapUIResource();
                actionMap.put("left", new ColorAction("left", 2));
                actionMap.put("right", new ColorAction("right", 3));
                actionMap.put("up", new ColorAction("up", 0));
                actionMap.put("down", new ColorAction("down", 1));
                actionMap.put("focusNext", new ColorAction("focusNext", 4));
                actionMap.put("focusLast", new ColorAction("focusLast", 5));
                UIManager.getLookAndFeelDefaults().put("GTKColorChooserPanel.actionMap", actionMap);
            }
            SwingUtilities.replaceUIActionMap(this, actionMap);
        }

        GTKColorChooserPanel getGTKColorChooserPanel() {
            return GTKColorChooserPanel.this;
        }

        void focusWheel() {
            this.setFocusType(1);
        }

        void focusTriangle() {
            this.setFocusType(2);
        }

        boolean isWheelFocused() {
            return this.isSet(16);
        }

        public void setColor(float f, float f2, float f3) {
            if (this.isSet(8)) {
                return;
            }
            this.setAngleFromHue(f);
            this.setSaturationAndBrightness(f2, f3);
        }

        public Color getColor() {
            return GTKColorChooserPanel.this.getColor();
        }

        int getColorX() {
            return this.circleX + this.getIndicatorSize() / 2 - this.getWheelXOrigin();
        }

        int getColorY() {
            return this.circleY + this.getIndicatorSize() / 2 - this.getWheelYOrigin();
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 501 || (this.isSet(2) || this.isSet(4)) && aWTEvent.getID() == 506) {
                int n = this.getWheelRadius();
                int n2 = ((MouseEvent)aWTEvent).getX() - n;
                int n3 = ((MouseEvent)aWTEvent).getY() - n;
                if (!this.hasFocus()) {
                    this.requestFocus();
                }
                if (!this.isSet(4) && this.adjustHue(n2, n3, aWTEvent.getID() == 501)) {
                    this.setFlag(2, true);
                    this.setFocusType(1);
                } else if (this.adjustSB(n2, n3, aWTEvent.getID() == 501)) {
                    this.setFlag(4, true);
                    this.setFocusType(2);
                } else {
                    this.setFocusType(2);
                }
            } else if (aWTEvent.getID() == 502) {
                this.setFlag(4, false);
                this.setFlag(2, false);
            } else if (aWTEvent.getID() == 1005) {
                this.setFocusType(0);
            } else if (aWTEvent.getID() == 1004) {
                if (!this.isSet(32) && !this.isSet(16)) {
                    this.setFlag(16, true);
                    this.setFocusType(1);
                }
                this.repaint();
            }
            super.processEvent(aWTEvent);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWheelRadius();
            int n2 = this.getWheelWidth();
            Image image = this.getImage(n);
            graphics.drawImage(image, this.getWheelXOrigin() - n, this.getWheelYOrigin() - n, null);
            if (this.hasFocus() && this.isSet(16)) {
                graphics.setColor(Color.BLACK);
                graphics.drawOval(this.getWheelXOrigin() - n, this.getWheelYOrigin() - n, 2 * n, 2 * n);
                graphics.drawOval(this.getWheelXOrigin() - n + n2, this.getWheelYOrigin() - n + n2, 2 * (n - n2), 2 * (n - n2));
            }
            if (Math.toDegrees(Math.PI * 2 - this.angle) <= 20.0 || Math.toDegrees(Math.PI * 2 - this.angle) >= 201.0) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.BLACK);
            }
            int n3 = (int)(Math.cos(this.angle) * (double)n);
            int n4 = (int)(Math.sin(this.angle) * (double)n);
            int n5 = (int)(Math.cos(this.angle) * (double)(n - n2));
            int n6 = (int)(Math.sin(this.angle) * (double)(n - n2));
            graphics.drawLine(n3 + n, n4 + n, n5 + n, n6 + n);
            if (this.hasFocus() && this.isSet(32)) {
                Graphics graphics2 = graphics.create();
                int n7 = this.getTriangleCircumscribedRadius();
                int n8 = (int)((double)(3 * n7) / Math.sqrt(3.0));
                graphics2.translate(this.getWheelXOrigin(), this.getWheelYOrigin());
                ((Graphics2D)graphics2).rotate(this.angle + 1.5707963267948966);
                graphics2.setColor(Color.BLACK);
                graphics2.drawLine(0, -n7, n8 / 2, n7 / 2);
                graphics2.drawLine(n8 / 2, n7 / 2, -n8 / 2, n7 / 2);
                graphics2.drawLine(-n8 / 2, n7 / 2, 0, -n7);
                graphics2.dispose();
            }
            graphics.setColor(Color.BLACK);
            graphics.drawOval(this.circleX, this.circleY, this.getIndicatorSize() - 1, this.getIndicatorSize() - 1);
            graphics.setColor(Color.WHITE);
            graphics.drawOval(this.circleX + 1, this.circleY + 1, this.getIndicatorSize() - 3, this.getIndicatorSize() - 3);
        }

        private Image getImage(int n) {
            if (!this.isSet(1) && this.wheelImage != null && this.wheelImage.getWidth(null) == n * 2) {
                return this.wheelImage;
            }
            if (this.wheelImage == null || this.wheelImage.getWidth(null) != n) {
                this.wheelImage = this.getWheelImage(n);
            }
            int n2 = this.getTriangleCircumscribedRadius();
            int n3 = (int)((double)n2 * 3.0 / 2.0);
            int n4 = (int)((double)(2 * n3) / Math.sqrt(3.0));
            if (this.triangleImage == null || this.triangleImage.getWidth(null) != n4) {
                this.triangleImage = new BufferedImage(n4, n4, 2);
            }
            Graphics graphics = this.triangleImage.getGraphics();
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillRect(0, 0, n4, n4);
            graphics.translate(n4 / 2, 0);
            this.paintTriangle(graphics, n3, this.getColor());
            graphics.translate(-n4 / 2, 0);
            graphics.dispose();
            graphics = this.wheelImage.getGraphics();
            graphics.setColor(new Color(0, 0, 0, 0));
            graphics.fillOval(this.getWheelWidth(), this.getWheelWidth(), 2 * (n - this.getWheelWidth()), 2 * (n - this.getWheelWidth()));
            double d = Math.toRadians(-30.0) + this.angle;
            graphics.translate(n, n);
            ((Graphics2D)graphics).rotate(d);
            graphics.drawImage(this.triangleImage, -n4 / 2, this.getWheelWidth() - n, null);
            ((Graphics2D)graphics).rotate(-d);
            graphics.translate(n4 / 2, n - this.getWheelWidth());
            this.setFlag(1, false);
            return this.wheelImage;
        }

        private void paintTriangle(Graphics graphics, int n, Color color) {
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            float f = fArray[0];
            double d = n;
            for (int i = 0; i < n; ++i) {
                int n2 = (int)((double)i * Math.tan(Math.toRadians(30.0)));
                float f2 = n2 * 2;
                if (n2 > 0) {
                    float f3 = (float)((double)i / d);
                    for (int j = -n2; j <= n2; ++j) {
                        float f4 = (float)j / f2 + 0.5f;
                        graphics.setColor(Color.getHSBColor(f, f4, f3));
                        graphics.fillRect(j, i, 1, 1);
                    }
                    continue;
                }
                graphics.setColor(color);
                graphics.fillRect(0, i, 1, 1);
            }
        }

        private Image getWheelImage(int n) {
            int n2 = n - this.getWheelWidth();
            int n3 = n * 2;
            BufferedImage bufferedImage = new BufferedImage(n3, n3, 2);
            for (int i = -n; i < n; ++i) {
                int n4 = i * i;
                for (int j = -n; j < n; ++j) {
                    double d = Math.sqrt(n4 + j * j);
                    if (!(d < (double)n) || !(d > (double)n2)) continue;
                    int n5 = this.colorWheelLocationToRGB(j, i, d) | 0xFF000000;
                    bufferedImage.setRGB(j + n, i + n, n5);
                }
            }
            this.wheelImage = bufferedImage;
            return this.wheelImage;
        }

        boolean adjustSB(int n, int n2, boolean bl) {
            int n3 = this.getWheelRadius() - this.getWheelWidth();
            boolean bl2 = false;
            n2 = -n2;
            if (bl && (n < -n3 || n > n3 || n2 < -n3 || n2 > n3)) {
                return false;
            }
            int n4 = n3 * 3 / 2;
            double d = Math.cos(this.angle) * (double)n - Math.sin(this.angle) * (double)n2;
            double d2 = Math.sin(this.angle) * (double)n + Math.cos(this.angle) * (double)n2;
            if (d < (double)(-(n3 / 2))) {
                if (bl) {
                    return false;
                }
                d = -n3 / 2;
                bl2 = true;
            } else if ((int)d > n3) {
                if (bl) {
                    return false;
                }
                d = n3;
                bl2 = true;
            }
            int n5 = (int)(((double)n4 - d - (double)n3 / 2.0) * Math.tan(Math.toRadians(30.0)));
            if (d2 <= (double)(-n5)) {
                if (bl) {
                    return false;
                }
                d2 = -n5;
                bl2 = true;
            } else if (d2 > (double)n5) {
                if (bl) {
                    return false;
                }
                d2 = n5;
                bl2 = true;
            }
            double d3 = Math.cos(Math.toRadians(-30.0)) * d - Math.sin(Math.toRadians(-30.0)) * d2;
            double d4 = Math.sin(Math.toRadians(-30.0)) * d + Math.cos(Math.toRadians(-30.0)) * d2;
            float f = Math.min(1.0f, (float)(((double)n3 - d4) / (double)n4));
            float f2 = (float)(Math.tan(Math.toRadians(30.0)) * ((double)n3 - d4));
            float f3 = Math.min(1.0f, (float)(d3 / (double)f2 / 2.0 + 0.5));
            this.setFlag(8, true);
            if (bl2) {
                this.setSaturationAndBrightness(f3, f);
            } else {
                this.setSaturationAndBrightness(f3, f, n + this.getWheelXOrigin(), this.getWheelYOrigin() - n2);
            }
            GTKColorChooserPanel.this.setSaturationAndBrightness(f3, f, true);
            this.setFlag(8, false);
            return true;
        }

        private void setSaturationAndBrightness(float f, float f2) {
            int n = this.getTriangleCircumscribedRadius();
            int n2 = n * 3 / 2;
            double d = f2 * (float)n2;
            double d2 = d * Math.tan(Math.toRadians(30.0));
            double d3 = 2.0 * d2 * (double)f - d2;
            double d4 = Math.cos(Math.toRadians(-60.0) - this.angle) * (d -= (double)n) - Math.sin(Math.toRadians(-60.0) - this.angle) * d3;
            double d5 = Math.sin(Math.toRadians(-60.0) - this.angle) * d + Math.cos(Math.toRadians(-60.0) - this.angle) * d3;
            int n3 = (int)d4 + this.getWheelXOrigin();
            int n4 = this.getWheelYOrigin() - (int)d5;
            this.setSaturationAndBrightness(f, f2, n3, n4);
        }

        private void setSaturationAndBrightness(float f, float f2, int n, int n2) {
            int n3 = Math.min(n -= this.getIndicatorSize() / 2, this.circleX);
            int n4 = Math.min(n2 -= this.getIndicatorSize() / 2, this.circleY);
            this.repaint(n3, n4, Math.max(this.circleX, n) - n3 + this.getIndicatorSize() + 1, Math.max(this.circleY, n2) - n4 + this.getIndicatorSize() + 1);
            this.circleX = n;
            this.circleY = n2;
        }

        private boolean adjustHue(int n, int n2, boolean bl) {
            double d = Math.sqrt(n * n + n2 * n2);
            int n3 = this.getWheelRadius();
            if (!bl || d >= (double)(n3 - this.getWheelWidth()) && d < (double)n3) {
                double d2;
                if (n == 0) {
                    d2 = n2 > 0 ? 1.5707963267948966 : 4.71238898038469;
                } else {
                    d2 = Math.atan((double)n2 / (double)n);
                    if (n < 0) {
                        d2 += Math.PI;
                    } else if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                }
                this.setFlag(8, true);
                GTKColorChooserPanel.this.setHue((float)(1.0 - d2 / Math.PI / 2.0), true);
                this.setFlag(8, false);
                this.setHueAngle(d2);
                this.setSaturationAndBrightness(GTKColorChooserPanel.this.getSaturation(), GTKColorChooserPanel.this.getBrightness());
                return true;
            }
            return false;
        }

        private void setAngleFromHue(float f) {
            this.setHueAngle((1.0 - (double)f) * Math.PI * 2.0);
        }

        private void setHueAngle(double d) {
            double d2 = this.angle;
            this.angle = d;
            if (d != d2) {
                this.setFlag(1, true);
                this.repaint();
            }
        }

        private int getIndicatorSize() {
            return 8;
        }

        private int getTriangleCircumscribedRadius() {
            return 72;
        }

        private int getWheelXOrigin() {
            return 85;
        }

        private int getWheelYOrigin() {
            return 85;
        }

        private int getWheelWidth() {
            return 13;
        }

        private void setFocusType(int n) {
            if (n == 0) {
                this.setFlag(16, false);
                this.setFlag(32, false);
                this.repaint();
            } else {
                int n2 = 16;
                int n3 = 32;
                if (n == 2) {
                    n2 = 32;
                    n3 = 16;
                }
                if (!this.isSet(n2)) {
                    this.setFlag(n2, true);
                    this.repaint();
                    this.setFlag(n3, false);
                }
            }
        }

        private int getWheelRadius() {
            return 85;
        }

        private void setFlag(int n, boolean bl) {
            this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
        }

        private boolean isSet(int n) {
            return (this.flags & n) == n;
        }

        private int colorWheelLocationToRGB(int n, int n2, double d) {
            int n3;
            double d2 = Math.acos((double)n / d);
            if (d2 < 1.0471975803375244) {
                n3 = n2 < 0 ? 0xFF0000 | Math.min(255, (int)(255.0 * d2 / 1.0471975803375244)) << 8 : 0xFF0000 | Math.min(255, (int)(255.0 * d2 / 1.0471975803375244));
            } else if (d2 < 2.094395160675049) {
                n3 = n2 < 0 ? 0xFF00 | Math.max(0, 255 - (int)(255.0 * d2 / 1.0471975803375244)) << 16 : 0xFF | Math.max(0, 255 - (int)(255.0 * (d2 -= 1.0471975803375244) / 1.0471975803375244)) << 16;
            } else {
                d2 -= 2.094395160675049;
                n3 = n2 < 0 ? 0xFF00 | Math.min(255, (int)(255.0 * d2 / 1.0471975803375244)) : 0xFF | Math.min(255, (int)(255.0 * d2 / 1.0471975803375244)) << 8;
            }
            return n3;
        }

        void incrementHue(boolean bl) {
            float f = GTKColorChooserPanel.this.triangle.getGTKColorChooserPanel().getHue();
            f = bl ? (f += 0.0027777778f) : (f -= 0.0027777778f);
            if (f > 1.0f) {
                f -= 1.0f;
            } else if (f < 0.0f) {
                f += 1.0f;
            }
            this.getGTKColorChooserPanel().setHue(f, true);
        }
    }
}

