/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.InternalErrorException;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.IssuerSerial;
import iaik.x509.attr.ObjectDigestInfo;

public class V2Form
implements AttCertIssuer {
    ObjectDigestInfo a;
    IssuerSerial c;
    GeneralNames b;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (this.b != null) {
            stringBuffer.append("issuerName: " + this.b);
            bl = false;
        }
        if (this.c != null) {
            stringBuffer.append(String.valueOf(bl ? "" : "\n") + "baseCertificateID: " + this.c);
            bl = false;
        }
        if (this.a != null) {
            stringBuffer.append(String.valueOf(bl ? "" : "\n") + "objectDigestInfo: " + this.a);
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b != null) {
            try {
                sEQUENCE.addComponent(this.b.toASN1Object());
            }
            catch (CodingException codingException) {
                throw new InternalErrorException("Error when adding issuerName component: " + codingException.getMessage(), codingException);
            }
        }
        if (this.c != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.c.toASN1Object(), bl));
        }
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(1, this.a.toASN1Object(), bl));
        }
        return sEQUENCE;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.b != null) {
            n2 += this.b.hashCode();
        }
        if (this.c != null) {
            n2 += this.c.hashCode();
        }
        if (this.a != null) {
            n2 += this.a.hashCode();
        }
        return n2;
    }

    public int getVForm() {
        return 2;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.a;
    }

    public GeneralNames getIssuerName() {
        return this.b;
    }

    public Name getIssuerDN() {
        GeneralName[] generalNameArray;
        Name name = null;
        if (this.b != null && (generalNameArray = this.b.getNames(4)) != null && generalNameArray.length > 0) {
            name = (Name)generalNameArray[0].getName();
        }
        return name;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.c;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof V2Form)) {
            return false;
        }
        V2Form v2Form = (V2Form)object;
        if (this.b != null && v2Form.b != null ? !this.b.equals(v2Form.b) : this.b != null || v2Form.b != null) {
            return false;
        }
        if (this.c != null && v2Form.c != null ? !this.c.equals(v2Form.c) : this.c != null || v2Form.c != null) {
            return false;
        }
        if (this.a != null && v2Form.a != null) {
            return this.a.equals(v2Form.a);
        }
        return this.a == null && v2Form.a == null;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n2 = aSN1Object.countComponents();
        if (n2 > 3) {
            throw new CodingException("Cannot decode V2Form: invalid number of components: " + n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            block8: {
                ASN1Object aSN1Object2;
                block7: {
                    aSN1Object2 = aSN1Object.getComponentAt(n3);
                    if (!aSN1Object2.isA(ASN.CON_SPEC)) break block7;
                    CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
                    cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                    int n4 = cON_SPEC.getAsnType().getTag();
                    switch (n4) {
                        case 0: {
                            this.c = new IssuerSerial((ASN1Object)cON_SPEC.getValue());
                            break block8;
                        }
                        case 1: {
                            this.a = new ObjectDigestInfo((ASN1Object)cON_SPEC.getValue());
                            break block8;
                        }
                        default: {
                            throw new CodingException("Cannot decode V2Form. Invalid tag: " + n4);
                        }
                    }
                }
                this.b = new GeneralNames(aSN1Object2);
            }
            ++n3;
        }
        if (this.b == null && this.c == null && this.a == null) {
            throw new CodingException("All components of a V2Form are not allowed to be null!");
        }
    }

    public V2Form(Name name) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot create V2Form: Missing issuerName!");
        }
        GeneralName generalName = new GeneralName(4, name);
        this.b = new GeneralNames(generalName);
    }

    public V2Form(GeneralNames generalNames, IssuerSerial issuerSerial, ObjectDigestInfo objectDigestInfo) {
        if (generalNames == null && issuerSerial == null && objectDigestInfo == null) {
            throw new IllegalArgumentException("All components of a V2Form are not allowed to be null!");
        }
        this.b = generalNames;
        this.c = issuerSerial;
        this.a = objectDigestInfo;
    }

    public V2Form(GeneralNames generalNames) {
        if (generalNames == null) {
            throw new IllegalArgumentException("Cannot create V2Form: Missing issuer name!");
        }
        this.b = generalNames;
    }

    public V2Form(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }
}

