/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.campi;

import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.GericoModel;

public class ToggleButtonModel
extends GericoModel {
    private String valorePredefinito = "0";
    public static final String ON_VALUE = "1";
    public static final String OFF_VALUE = "0";

    public ToggleButtonModel(String code, String errorDescription) {
        super(code, errorDescription, 1);
        this.setValorePredefinito();
    }

    public ToggleButtonModel(String codice, String descrizione, int lunghezza) {
        super(codice, descrizione, lunghezza);
        this.setValorePredefinito();
    }

    public String getValorePredefinito() {
        return this.valorePredefinito;
    }

    public boolean isValorePredefinito() {
        return this.getValorePredefinito().compareTo(this.getValue()) == 0;
    }

    public void setValore(String valore) throws ControlloFormaleException {
        if (valore.equals("")) {
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            throw new ControlloFormaleException(valore);
        }
        try {
            Long.parseLong(valore);
        }
        catch (NumberFormatException numberFormatException) {
            this.errore = "011";
            this.gravitaErrore = "scarto";
            throw new ControlloFormaleException(valore);
        }
        if (valore.length() > this.length()) {
            this.errore = "020";
            this.gravitaErrore = "scarto";
            throw new ControlloFormaleException(valore);
        }
        if (!valore.equals(OFF_VALUE) && !valore.equals(ON_VALUE)) {
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            throw new ControlloFormaleException(valore);
        }
        this.valore = valore;
    }

    public void setValorePredefinito() {
        this.valore = this.getValorePredefinito();
    }
}

