/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.util;

import java.util.Dictionary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class VersionUtil
extends AbstractUIPlugin {
    public static String getPluginVersion(String idPlugin) {
        String version = null;
        Dictionary dictionary = Platform.getBundle((String)idPlugin).getHeaders();
        version = (String)dictionary.get("Bundle-Version");
        dictionary.keys();
        return version;
    }

    public static String getPlatformVersion() {
        String version = null;
        try {
            Dictionary dictionary = WorkbenchPlugin.getDefault().getBundle().getHeaders();
            dictionary.keys();
            version = (String)dictionary.get("Bundle-Version");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            version = VersionUtil.getProductVersion();
        }
        return version;
    }

    public static String getProductVersion() {
        String version = null;
        try {
            IProduct product = Platform.getProduct();
            String aboutText = product.getProperty("aboutText");
            String pattern = "Version: (.*)\n";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(aboutText);
            boolean found = m.find();
            if (found) {
                version = m.group(1);
            }
        }
        catch (Exception exception) {
            version = "versione non disponibile";
        }
        return version;
    }

    public static String getFeatureVersion(String myFeatureId) {
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                IBundleGroup[] bundleGroups;
                IBundleGroup[] iBundleGroupArray = bundleGroups = providers[i].getBundleGroups();
                int n = bundleGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    IBundleGroup bg = iBundleGroupArray[n2];
                    if (bg.getIdentifier().equals(myFeatureId)) {
                        return bg.getVersion();
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return "versione non disponibile";
    }
}

